/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils;

import com.google.common.collect.Lists;
import de.jabc.cinco.meta.core.utils.MGLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mgl.Attribute;
import mgl.Edge;
import mgl.GraphModel;
import mgl.MGLModel;
import mgl.ModelElement;
import mgl.Node;
import mgl.NodeContainer;
import mgl.UserDefinedType;
import org.eclipse.emf.ecore.EObject;

public class InheritanceUtil {
    public List<String> checkMGLInheritance(ModelElement modelElement) {
        if (modelElement instanceof Node) {
            return this.checkNodeInheritance((Node)modelElement);
        }
        if (modelElement instanceof Edge) {
            return InheritanceUtil.checkEdgeInheritance((Edge)modelElement);
        }
        if (modelElement instanceof UserDefinedType) {
            return this.checkUserDefinedTypeInheritance((UserDefinedType)modelElement);
        }
        if (modelElement instanceof GraphModel) {
            return this.checkGraphModelInheritance((GraphModel)modelElement);
        }
        return null;
    }

    private List<String> checkGraphModelInheritance(GraphModel graphModel) {
        GraphModel curr = graphModel;
        ArrayList<String> ancestors = new ArrayList<String>();
        while (curr != null) {
            if (ancestors.contains(MGLUtil.getFqn((ModelElement)curr))) {
                return ancestors;
            }
            ancestors.add(MGLUtil.getFqn((ModelElement)curr));
            curr = curr.getExtends();
        }
        return null;
    }

    private List<String> checkUserDefinedTypeInheritance(UserDefinedType type) {
        UserDefinedType curr = type;
        ArrayList<String> ancestors = new ArrayList<String>();
        while (curr != null) {
            if (ancestors.contains(MGLUtil.getFqn((ModelElement)curr))) {
                return ancestors;
            }
            ancestors.add(MGLUtil.getFqn((ModelElement)curr));
            curr = curr.getExtends();
        }
        return null;
    }

    private List<String> checkNodeInheritance(Node node) {
        Node curr = node;
        ArrayList<String> ancestors = new ArrayList<String>();
        while (curr != null) {
            if (ancestors.contains(MGLUtil.getFqn((ModelElement)curr))) {
                return ancestors;
            }
            ancestors.add(MGLUtil.getFqn((ModelElement)curr));
            curr = curr.getExtends();
        }
        return null;
    }

    private static List<String> checkEdgeInheritance(Edge edge) {
        Edge curr = edge;
        ArrayList<String> ancestors = new ArrayList<String>();
        while (curr != null) {
            if (ancestors.contains(MGLUtil.getFqn((ModelElement)curr))) {
                return ancestors;
            }
            ancestors.add(MGLUtil.getFqn((ModelElement)curr));
            curr = curr.getExtends();
        }
        return null;
    }

    public List<Attribute> getInheritedAttributes(ModelElement modelElement) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        List<String> checked = this.checkMGLInheritance(modelElement);
        if (modelElement instanceof Node) {
            modelElement = ((Node)modelElement).getExtends();
        }
        if (modelElement instanceof Edge) {
            modelElement = ((Edge)modelElement).getExtends();
        }
        if (modelElement instanceof NodeContainer) {
            modelElement = ((NodeContainer)modelElement).getExtends();
        }
        while (modelElement != null && (checked == null || checked.isEmpty())) {
            attributes.addAll((Collection<Attribute>)modelElement.getAttributes());
            if (modelElement instanceof Node) {
                modelElement = ((Node)modelElement).getExtends();
            }
            if (modelElement instanceof Edge) {
                modelElement = ((Edge)modelElement).getExtends();
            }
            if (!(modelElement instanceof NodeContainer)) continue;
            modelElement = ((NodeContainer)modelElement).getExtends();
        }
        return attributes;
    }

    public GraphModel getLowestMutualSuperGraphModel(Iterable<GraphModel> graphModels) {
        if (graphModels != null) {
            HashSet<GraphModel> superGraphModels = new HashSet<GraphModel>();
            boolean first = true;
            for (GraphModel graphModel : graphModels) {
                if (first) {
                    superGraphModels.addAll(this.getAllSuperGraphModels(graphModel));
                    first = false;
                    continue;
                }
                superGraphModels.retainAll(this.getAllSuperGraphModels(graphModel));
            }
            if (superGraphModels.size() == 1) {
                return superGraphModels.toArray(new GraphModel[1])[0];
            }
            if (superGraphModels.size() > 1) {
                return this.sortGraphModelsByInheritance(Lists.newArrayList(superGraphModels)).get(superGraphModels.size() - 1);
            }
            return null;
        }
        return null;
    }

    public Node getLowestMutualSuperNode(Iterable<Node> nodes) {
        if (nodes != null) {
            HashSet<Node> superNodes = new HashSet<Node>();
            boolean first = true;
            for (Node node : nodes) {
                if (first) {
                    superNodes.addAll(this.getAllSuperNodes(node));
                    first = false;
                    continue;
                }
                superNodes.retainAll(this.getAllSuperNodes(node));
            }
            if (superNodes.size() == 1) {
                return superNodes.toArray(new Node[1])[0];
            }
            if (superNodes.size() > 1) {
                return this.sortByInheritance(Lists.newArrayList(superNodes)).get(superNodes.size() - 1);
            }
            return null;
        }
        return null;
    }

    public Edge getLowestMutualSuperEdge(Iterable<Edge> edges) {
        if (edges != null) {
            HashSet<? extends Edge> superEdges = new HashSet<Edge>();
            boolean first = true;
            for (Edge edge : edges) {
                if (first) {
                    superEdges.addAll(this.getAllSuperEdges(edge));
                    first = false;
                    continue;
                }
                superEdges.retainAll(this.getAllSuperEdges(edge));
            }
            if (superEdges.size() == 1) {
                return superEdges.toArray(new Edge[1])[0];
            }
            if (superEdges.size() > 1) {
                return this.sortEdgesByInheritance(Lists.newArrayList(superEdges)).get(superEdges.size() - 1);
            }
            return null;
        }
        return null;
    }

    public Collection<? extends Edge> getAllSuperEdges(Edge edge) {
        HashSet<Edge> superEdges = new HashSet<Edge>();
        superEdges.add(edge);
        Edge superEdge = edge.getExtends();
        List<String> checked = this.checkMGLInheritance((ModelElement)superEdge);
        while (superEdge != null && (checked == null || checked.isEmpty())) {
            superEdges.add(superEdge);
            superEdge = superEdge.getExtends();
        }
        return superEdges;
    }

    private List<GraphModel> sortGraphModelsByInheritance(List<GraphModel> graphModels) {
        graphModels.sort(new Comparator<GraphModel>(){

            @Override
            public int compare(GraphModel o1, GraphModel o2) {
                int j = 0;
                int i = 0;
                GraphModel sn = o1.getExtends();
                while (sn != null) {
                    sn = sn.getExtends();
                    ++i;
                }
                sn = o2.getExtends();
                while (sn != null) {
                    sn = sn.getExtends();
                    ++j;
                }
                return Integer.compare(i, j);
            }
        });
        return graphModels;
    }

    private List<Node> sortByInheritance(List<Node> nodes) {
        nodes.sort(new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                int j = 0;
                int i = 0;
                Node sn = o1.getExtends();
                while (sn != null) {
                    sn = sn.getExtends();
                    ++i;
                }
                sn = o2.getExtends();
                while (sn != null) {
                    sn = sn.getExtends();
                    ++j;
                }
                return Integer.compare(i, j);
            }
        });
        return nodes;
    }

    private List<Edge> sortEdgesByInheritance(List<Edge> edges) {
        edges.sort(new Comparator<Edge>(){

            @Override
            public int compare(Edge o1, Edge o2) {
                int j = 0;
                int i = 0;
                Edge sn = o1.getExtends();
                while (sn != null) {
                    sn = sn.getExtends();
                    ++i;
                }
                sn = o2.getExtends();
                while (sn != null) {
                    sn = sn.getExtends();
                    ++j;
                }
                return Integer.compare(i, j);
            }
        });
        return edges;
    }

    public Set<GraphModel> getAllSuperGraphModels(GraphModel graphModel) {
        HashSet<GraphModel> superGraphModels = new HashSet<GraphModel>();
        superGraphModels.add(graphModel);
        GraphModel superGraphModel = graphModel.getExtends();
        List<String> checked = this.checkMGLInheritance((ModelElement)superGraphModel);
        while (superGraphModel != null && (checked == null || checked.isEmpty())) {
            superGraphModels.add(superGraphModel);
            superGraphModel = superGraphModel.getExtends();
        }
        return superGraphModels;
    }

    public Set<Node> getAllSuperNodes(Node node) {
        HashSet<Node> superNodes = new HashSet<Node>();
        superNodes.add(node);
        Node superNode = node.getExtends();
        List<String> checked = this.checkMGLInheritance((ModelElement)superNode);
        while (superNode != null && (checked == null || checked.isEmpty())) {
            superNodes.add(superNode);
            superNode = superNode.getExtends();
        }
        return superNodes;
    }

    public Set<GraphModel> getAllSubGraphModels(GraphModel graphModel) throws RuntimeException {
        EObject eCon = graphModel.eContainer();
        if (eCon instanceof MGLModel) {
            MGLModel mgl = (MGLModel)eCon;
            HashSet<GraphModel> subGraphModels = new HashSet<GraphModel>();
            for (GraphModel other : mgl.getGraphModels()) {
                if (!this.isSuperGraphModelOf(graphModel, other)) continue;
                subGraphModels.add(other);
            }
            return subGraphModels;
        }
        throw new RuntimeException("Cannot find MGL model of graph model '" + graphModel.getName() + "'.");
    }

    public Set<Node> getAllSubNodes(Node node) throws RuntimeException {
        EObject eCon = node.eContainer();
        if (eCon instanceof MGLModel) {
            MGLModel mgl = (MGLModel)eCon;
            HashSet<Node> subNodes = new HashSet<Node>();
            for (Node other : mgl.getNodes()) {
                if (!this.isSuperNodeOf(node, other)) continue;
                subNodes.add(other);
            }
            return subNodes;
        }
        throw new RuntimeException("Cannot find MGL model of node '" + node.getName() + "'.");
    }

    public Set<Edge> getAllSubEdges(Edge edge) throws RuntimeException {
        EObject eCon = edge.eContainer();
        if (eCon instanceof MGLModel) {
            MGLModel mgl = (MGLModel)eCon;
            HashSet<Edge> subEdges = new HashSet<Edge>();
            for (Edge other : mgl.getEdges()) {
                if (!this.isSuperEdgeOf(edge, other)) continue;
                subEdges.add(other);
            }
            return subEdges;
        }
        throw new RuntimeException("Cannot find MGL model of edge '" + edge.getName() + "'.");
    }

    public boolean isSuperNodeOf(Node superCandidate, Node childCandidate) {
        Node current = childCandidate.getExtends();
        while (current != null && current != childCandidate) {
            if (current == superCandidate) {
                return true;
            }
            current = current.getExtends();
        }
        return false;
    }

    public boolean isSuperEdgeOf(Edge superCandidate, Edge childCandidate) {
        Edge current = childCandidate.getExtends();
        while (current != null && current != childCandidate) {
            if (current == superCandidate) {
                return false;
            }
            current = current.getExtends();
        }
        return false;
    }

    public boolean isSuperGraphModelOf(GraphModel superCandidate, GraphModel childCandidate) {
        GraphModel current = childCandidate.getExtends();
        while (current != null && current != childCandidate) {
            if (current == superCandidate) {
                return false;
            }
            current = current.getExtends();
        }
        return false;
    }
}

