/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils;

import de.jabc.cinco.meta.util.xapi.FileExtension;
import de.jabc.cinco.meta.util.xapi.ResourceExtension;
import de.jabc.cinco.meta.util.xapi.WorkspaceExtension;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import productDefinition.CincoProduct;

public class HeadlessUtils {
    public static IProject importProjectFromString(String importPath, IProgressMonitor monitor) throws CoreException {
        File baseDirectory = new File(importPath);
        IProjectDescription description = new WorkspaceExtension().getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(baseDirectory.getAbsolutePath()) + "/.project"));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
        if (!project.exists()) {
            project.create(description, monitor);
        }
        if (!project.isOpen()) {
            project.open(monitor);
        }
        return project;
    }

    public static IProject importProjectFromString(String workspacePath, String projectName, IProgressMonitor monitor) throws CoreException {
        String projectPath = String.format("%s/%s", workspacePath);
        return HeadlessUtils.importProjectFromString(projectPath, monitor);
    }

    public static Iterable<IProject> importAllProjects(Iterable<String> importPaths, IProgressMonitor monitor) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        importPaths.forEach(path -> {
            try {
                projects.add(HeadlessUtils.importProjectFromString(path, monitor));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not load Project: '%s'", path));
            }
        });
        return projects;
    }

    public static Iterable<IProject> importAllProjects(String workspacePath, Iterable<String> importPaths, IProgressMonitor monitor) {
        ArrayList projects = new ArrayList();
        ArrayList<String> paths = new ArrayList<String>();
        importPaths.forEach(path -> paths.add(String.format("%s/%s", workspacePath, path)));
        return HeadlessUtils.importAllProjects(paths, monitor);
    }

    public static CincoProduct loadCincoProduct(IProject project, String cpdPath) {
        System.out.println(cpdPath);
        IFile cpdFile = HeadlessUtils.getCPDFile(project, cpdPath);
        FileExtension fe = new FileExtension();
        ResourceExtension re = new ResourceExtension();
        return (CincoProduct)re.getContent(fe.getResource(cpdFile), CincoProduct.class);
    }

    public static CincoProduct loadCincoProduct(String importPath, String cpdPath, IProgressMonitor monitor) throws CoreException {
        IProject project = HeadlessUtils.importProjectFromString(importPath, monitor);
        return HeadlessUtils.loadCincoProduct(project, cpdPath);
    }

    public static IFile getCPDFile(IProject project, String cpdPath) {
        return project.getFile(cpdPath);
    }

    public static IFile getCPDFile(String importPath, String cpdPath, IProgressMonitor monitor) throws CoreException {
        IProject project = HeadlessUtils.importProjectFromString(importPath, monitor);
        return HeadlessUtils.getCPDFile(project, cpdPath);
    }

    public static IFile getCPDFile(String workspacePath, String projectName, String cpdPath, IProgressMonitor monitor) throws CoreException {
        String importPath = String.format("%s/%s", workspacePath, projectName);
        IProject project = HeadlessUtils.importProjectFromString(importPath, monitor);
        return HeadlessUtils.getCPDFile(project, cpdPath);
    }
}

