/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtend2.lib.StringConcatenation;

public class GeneratorHelper {
    public static void generateGenModelCode(IProject project, String modelName) throws IOException {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("src-gen/model/");
        _builder.append(modelName);
        _builder.append(".genmodel");
        IFile genModelFile = project.getFile(_builder.toString());
        boolean _exists = genModelFile.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("The file: ");
            _builder_1.append(modelName);
            _builder_1.append(".genmodel does not exist");
            throw new IOException(_builder_1.toString());
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource res = resourceSet.getResource(URI.createPlatformResourceURI((String)genModelFile.getFullPath().toOSString(), (boolean)true), true);
        res.load(null);
        EList _contents = res.getContents();
        for (EObject o : _contents) {
            if (!(o instanceof GenModel)) continue;
            GenModel genModel = (GenModel)o;
            EList _usedGenPackages = genModel.getUsedGenPackages();
            for (GenPackage gp : _usedGenPackages) {
                if (gp.getGenModel() == null || gp.getGenModel().equals(genModel)) continue;
                genModel.getUsedGenPackages().add((Object)gp);
            }
            GeneratorHelper.generateGenModelCode(genModel);
        }
    }

    public static void generateGenModelCode(IFile mglModelFile) throws IOException {
        String _xifexpression = null;
        boolean _endsWith = mglModelFile.getName().endsWith(".mgl");
        _xifexpression = _endsWith ? mglModelFile.getName().split("\\.")[0] : mglModelFile.getName();
        String modelName = _xifexpression;
        IProject project = mglModelFile.getProject();
        GeneratorHelper.generateGenModelCode(project, modelName);
    }

    public static void generateGenModelCode(GenModel genModel) {
        GeneratorHelper.generateCode(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject");
    }

    public static void generateEditCode(GenModel genModel) {
        GeneratorHelper.generateCode(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject");
    }

    public static void generateEditorCode(GenModel genModel) {
        GeneratorHelper.generateCode(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject");
    }

    public static void generateTestCode(GenModel genModel) {
        GeneratorHelper.generateCode(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject");
    }

    private static void generateCode(GenModel genModel, String modelType) {
        genModel.setCanGenerate(true);
        Generator generator = GenModelUtil.createGenerator((GenModel)genModel);
        BasicMonitor _basicMonitor = new BasicMonitor();
        generator.generate((Object)genModel, (Object)modelType, (Monitor)_basicMonitor);
    }
}

