/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.util.StringInputStream;
import org.osgi.framework.Bundle;

public class EclipseFileUtils {
    public static void mkdirs(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                EclipseFileUtils.mkdirs((IFolder)folder.getParent());
            }
            try {
                folder.create(true, true, null);
            }
            catch (CoreException coreException) {
                if (!coreException.getMessage().startsWith("A resource already exists on disk")) {
                    throw coreException;
                }
                System.out.println((Object)coreException);
            }
        }
    }

    public static void writeToFile(IFile file, CharSequence contents) {
        try {
            if (!file.exists()) {
                file.create((InputStream)new StringInputStream(contents.toString()), true, null);
            } else {
                file.setContents((InputStream)new StringInputStream(contents.toString()), true, true, null);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static File getFileForModel(EObject model) {
        URI resolvedFile = CommonPlugin.resolve((URI)EcoreUtil.getURI((EObject)model));
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resolvedFile.toFileString()));
        File file = iFile.getFullPath().toFile();
        if (file == null) {
            throw new RuntimeException("Could not find file for " + model);
        }
        if (!file.exists()) {
            throw new RuntimeException("File does not exist for " + model);
        }
        return file;
    }

    public static void copyFromBundleToDirectory(String bundleId, String pathInBundle, IFolder targetDirectory) {
        Bundle b = Platform.getBundle((String)bundleId);
        URL directoryURL = b.getEntry(pathInBundle);
        if (directoryURL == null) {
            throw new RuntimeException(String.format("path '%s' not found in bundle '%s'", pathInBundle, bundleId));
        }
        try {
            URL fileURL = FileLocator.toFileURL((URL)directoryURL);
            java.net.URI resolvedURI = new java.net.URI(fileURL.getProtocol(), fileURL.getPath(), null);
            File sourceFile = new File(resolvedURI);
            File targetDir = targetDirectory.getRawLocation().makeAbsolute().toFile();
            if (sourceFile.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)sourceFile, (File)targetDir);
            } else {
                FileUtils.copyFileToDirectory((File)sourceFile, (File)targetDir);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyFromBundleToFile(String bundleId, String pathInBundle, IFile targetFile) {
        Bundle b = Platform.getBundle((String)bundleId);
        URL directoryURL = b.getEntry(pathInBundle);
        if (directoryURL == null) {
            throw new RuntimeException(String.format("path '%s' not found in bundle '%s'", pathInBundle, bundleId));
        }
        try {
            URL fileURL = FileLocator.toFileURL((URL)directoryURL);
            java.net.URI resolvedURI = new java.net.URI(fileURL.getProtocol(), fileURL.getPath(), null);
            File source = new File(resolvedURI);
            File target = targetFile.getRawLocation().makeAbsolute().toFile();
            FileUtils.copyFile((File)source, (File)target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

