/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils;

import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.PathValidator;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import de.jabc.cinco.meta.util.xapi.FileExtension;
import de.jabc.cinco.meta.util.xapi.WorkspaceExtension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import mgl.Annotatable;
import mgl.Annotation;
import mgl.Attribute;
import mgl.Edge;
import mgl.GraphModel;
import mgl.GraphicalModelElement;
import mgl.Import;
import mgl.MGLModel;
import mgl.ModelElement;
import mgl.Node;
import mgl.UserDefinedType;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.util.StringInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import productDefinition.CincoProduct;
import style.EdgeStyle;
import style.NodeStyle;
import style.Style;
import style.Styles;

public class CincoUtil {
    static WorkspaceExtension workspaceExtension = new WorkspaceExtension();
    static FileExtension fileExtension = new FileExtension();
    static ResourceExtension resourceExtension = new ResourceExtension();
    public static final String ID_STYLE = "style";
    public static final String ID_ICON = "icon";
    public static final String ID_LABEL = "label";
    public static final String ID_DISABLE = "disable";
    public static final String ID_DISABLE_CREATE = "create";
    public static final String ID_DISABLE_DELETE = "delete";
    public static final String ID_DISABLE_MOVE = "move";
    public static final String ID_DISABLE_RESIZE = "resize";
    public static final String ID_DISABLE_RECONNECT = "reconnect";
    public static final String ID_DISABLE_SELECT = "select";
    public static final String ID_ATTRIBUTE_HIDDEN = "propertiesViewHidden";
    public static final String ID_DISABLE_HIGHLIGHT = "disableHighlight";
    public static final String ID_DISABLE_HIGHLIGHT_CONTAINMENT = "containment";
    public static final String ID_DISABLE_HIGHLIGHT_RECONNECTION = "reconnection";
    public static Set<String> DISABLE_NODE_VALUES = new HashSet<String>(Arrays.asList("create", "delete", "move", "resize", "select"));
    public static Set<String> DISABLE_EDGE_VALUES = new HashSet<String>(Arrays.asList("create", "delete", "reconnect", "select"));
    public static Set<String> DISABLE_HIGHLIGHT_VALUES = new HashSet<String>(Arrays.asList("containment", "reconnection"));
    private static final String PLUGIN_FRAME = "<?xml version=\"1.0\" encoding=\"" + System.getProperty("file.encoding") + "\"?>\n" + "<?eclipse version=\"3.0\"?>\n" + "<plugin>\n" + "</plugin>";

    public static boolean isCreateDisabled(ModelElement me) {
        return CincoUtil.isDisabled(me, ID_DISABLE_CREATE);
    }

    public static boolean isMoveDisabled(ModelElement modelElement) {
        return CincoUtil.isDisabled(modelElement, ID_DISABLE_MOVE);
    }

    public static boolean isResizeDisabled(ModelElement me) {
        return CincoUtil.isDisabled(me, ID_DISABLE_RESIZE);
    }

    public static boolean isSelectDisabled(ModelElement modelElement) {
        return CincoUtil.isDisabled(modelElement, ID_DISABLE_SELECT);
    }

    public static boolean isReconnectDisabled(ModelElement modelElement) {
        return CincoUtil.isDisabled(modelElement, ID_DISABLE_RECONNECT);
    }

    public static boolean isDeleteDisabled(ModelElement modelElement) {
        return CincoUtil.isDisabled(modelElement, ID_DISABLE_DELETE);
    }

    public static boolean isDisabled(ModelElement modelElement) {
        Set<String> values = DISABLE_NODE_VALUES;
        if (modelElement instanceof Edge) {
            values = DISABLE_EDGE_VALUES;
        }
        for (Annotation annot : modelElement.getAnnotations()) {
            if (!annot.getName().equals(ID_DISABLE)) continue;
            return annot.getValue().isEmpty() || annot.getValue().containsAll(values);
        }
        return false;
    }

    private static boolean isDisabled(ModelElement me, String id) {
        for (Annotation annot : me.getAnnotations()) {
            if (!annot.getName().equals(ID_DISABLE)) continue;
            return annot.getValue().isEmpty() || annot.getValue().contains((Object)id);
        }
        return false;
    }

    public static boolean isHighlightContainmentDisabled(Annotatable annotatable) {
        return CincoUtil.isHighlightDisabled(annotatable, ID_DISABLE_HIGHLIGHT_CONTAINMENT);
    }

    public static boolean isHighlightReconnectionDisabled(Annotatable annotatable) {
        return CincoUtil.isHighlightDisabled(annotatable, ID_DISABLE_HIGHLIGHT_RECONNECTION);
    }

    public static boolean isHighlightDisabled(Annotatable me) {
        for (Annotation annot : me.getAnnotations()) {
            if (!annot.getName().equals(ID_DISABLE_HIGHLIGHT)) continue;
            return annot.getValue().isEmpty() || annot.getValue().containsAll(DISABLE_HIGHLIGHT_VALUES);
        }
        return false;
    }

    private static boolean isHighlightDisabled(Annotatable me, String id) {
        for (Annotation annot : me.getAnnotations()) {
            if (!annot.getName().equals(ID_DISABLE_HIGHLIGHT)) continue;
            return annot.getValue().isEmpty() || annot.getValue().contains((Object)id);
        }
        return false;
    }

    public static boolean isAttributeReadOnly(Attribute attr) {
        for (Annotation annot : attr.getAnnotations()) {
            if (!annot.getName().equals("readOnly")) continue;
            return true;
        }
        return false;
    }

    public static boolean isAttributeFile(Attribute attr) {
        for (Annotation annot : attr.getAnnotations()) {
            if (!annot.getName().equals("file")) continue;
            return true;
        }
        return false;
    }

    public static boolean isAttributePossibleValuesProvider(Attribute attr) {
        for (Annotation annot : attr.getAnnotations()) {
            if (!annot.getName().equals("possibleValuesProvider")) continue;
            return true;
        }
        return false;
    }

    public static String getPossibleValuesProviderClass(Attribute attr) {
        for (Annotation annot : attr.getAnnotations()) {
            if (!annot.getName().equals("possibleValuesProvider") || annot.getValue().isEmpty() || annot.getValue().size() != 1) continue;
            return (String)annot.getValue().get(0);
        }
        return null;
    }

    public static boolean isAttributeColor(Attribute attr) {
        for (Annotation annot : attr.getAnnotations()) {
            if (!annot.getName().equals("color")) continue;
            return true;
        }
        return false;
    }

    public static boolean isAttributeHidden(Attribute attr) {
        for (Annotation annot : attr.getAnnotations()) {
            if (!annot.getName().equals(ID_ATTRIBUTE_HIDDEN)) continue;
            return true;
        }
        return false;
    }

    public static boolean isGrammarAttribute(Attribute attr) {
        for (Annotation annot : attr.getAnnotations()) {
            if (!annot.getName().equals("grammar")) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLabel(UserDefinedType userDefinedType) {
        for (Annotation annot : userDefinedType.getAnnotations()) {
            if (!annot.getName().equals(ID_LABEL)) continue;
            return true;
        }
        return false;
    }

    public static Resource getStylesResource(String pathToStyles, IProject project) {
        Resource res = null;
        URI uri = URI.createURI((String)pathToStyles, (boolean)true);
        try {
            if (uri.isPlatformResource()) {
                res = new ResourceSetImpl().getResource(uri, true);
            } else {
                IFile file = project.getFile(pathToStyles);
                URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true);
                res = new ResourceSetImpl().getResource(fileURI, true);
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Styles getStyles(GraphModel graphModel) {
        return CincoUtil.getStyles((MGLModel)graphModel.eContainer());
    }

    public static Styles getStyles(MGLModel mgl) {
        String path = mgl.getStylePath();
        if (path.length() > 0) {
            Resource res;
            block7: {
                URI uri = PathValidator.getURIForString((EObject)mgl, path);
                res = null;
                if (uri.isPlatformResource()) {
                    res = new ResourceSetImpl().getResource(uri, true);
                    break block7;
                }
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(mgl.eResource().getURI().toPlatformString(true))).getProject();
                IFile file = p.getFile(path);
                if (file.exists()) {
                    URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true);
                    res = new ResourceSetImpl().getResource(fileURI, true);
                    break block7;
                }
                return null;
            }
            try {
                for (Object o : res.getContents()) {
                    if (!(o instanceof Styles)) continue;
                    return (Styles)o;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static boolean hasAppearanceProvider(ModelElement modelElement) {
        Style style = CincoUtil.getStyleForModelElement(modelElement, CincoUtil.getStyles(MGLUtil.getMglModel(modelElement)));
        return style != null ? style.getAppearanceProvider() != null && !style.getAppearanceProvider().isEmpty() : false;
    }

    public static String getAppearanceProvider(ModelElement modelElement) {
        Style style = CincoUtil.getStyleForModelElement(modelElement, CincoUtil.getStyles(MGLUtil.getMglModel(modelElement)));
        return style != null ? style.getAppearanceProvider().replaceAll("\\\"", "") : "";
    }

    public static Style getStyleForModelElement(ModelElement modelElement, Styles styles) {
        if (modelElement instanceof Node) {
            return CincoUtil.getStyleForNode((Node)modelElement, styles);
        }
        if (modelElement instanceof Edge) {
            return CincoUtil.getStyleForEdge((Edge)modelElement, styles);
        }
        return null;
    }

    public static NodeStyle getStyleForNode(Node node, Styles styles) {
        String styleName = CincoUtil.getStyleName((GraphicalModelElement)node);
        Style findStyle = CincoUtil.findStyle(styles, styleName);
        if (findStyle instanceof NodeStyle) {
            return (NodeStyle)findStyle;
        }
        return null;
    }

    public static EdgeStyle getStyleForEdge(Edge edge, Styles styles) {
        String styleName = CincoUtil.getStyleName((GraphicalModelElement)edge);
        Style findStyle = CincoUtil.findStyle(styles, styleName);
        if (findStyle instanceof EdgeStyle) {
            return (EdgeStyle)findStyle;
        }
        return null;
    }

    @Deprecated
    public static Styles getStyles(MGLModel mgl, IProject project) {
        String path = mgl.getStylePath();
        if (!path.isEmpty()) {
            return null;
        }
        IFile iFile = project.getFile(path);
        return (Styles)new FileExtension().getContent(iFile, Styles.class);
    }

    public static Style findStyle(Styles styles, String name) {
        if (styles == null) {
            return null;
        }
        for (Style s : styles.getStyles()) {
            if (!name.equals(s.getName())) continue;
            return s;
        }
        return null;
    }

    public static String getStyleName(GraphicalModelElement graphicalModelElement) {
        String styleName = graphicalModelElement.getUsedStyle();
        if (styleName.isEmpty()) {
            return null;
        }
        return styleName;
    }

    public static CincoProduct getCincoProduct(IFile file) {
        URI uri = URI.createFileURI((String)file.getLocation().toString());
        Resource res = new ResourceSetImpl().getResource(uri, true);
        return CincoUtil.getCincoProduct(res);
    }

    public static CincoProduct getCincoProduct(Resource resource) {
        TreeIterator it = resource.getAllContents();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            if (!(o instanceof CincoProduct)) continue;
            return (CincoProduct)o;
        }
        return null;
    }

    public static Annotation getAnnotation(Attribute attr, String annotName) {
        List annots = attr.getAnnotations().stream().filter(a -> a.getName().equals(annotName)).collect(Collectors.toList());
        return annots.isEmpty() ? null : (Annotation)annots.get(0);
    }

    public static boolean isAttributeMultiValued(Attribute attr) {
        return attr.getUpperBound() != 1;
    }

    public static boolean isAttributeMultiLine(Attribute attr) {
        for (Annotation annot : attr.getAnnotations()) {
            if (!annot.getName().equals("multiLine")) continue;
            return true;
        }
        return false;
    }

    public static void refreshFiles(IProgressMonitor monitor, IFile ... files) {
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile f = iFileArray[n2];
            try {
                f.refreshLocal(0, monitor);
            }
            catch (CoreException e) {
                System.err.println("Refresh folder error...");
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public static void refreshFolders(IProgressMonitor monitor, IFolder ... folders) {
        IFolder[] iFolderArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder f = iFolderArray[n2];
            try {
                f.refreshLocal(1, monitor);
            }
            catch (CoreException e) {
                System.err.println("Refresh folder error...");
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public static void refreshProject(IProgressMonitor monitor, IProject project) {
        try {
            project.refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getUsedExtensions(GraphModel graphModel) {
        ArrayList<String> extensions = new ArrayList<String>();
        for (Import i : MGLUtil.mglModel(graphModel).getImports()) {
            GenModel gm;
            if (i.getImportURI().endsWith(".mgl")) {
                gm = CincoUtil.getImportedGraphModels(i);
                for (GraphModel n : gm) {
                    extensions.add(n.getFileExtension());
                }
            }
            if (!i.getImportURI().endsWith(".ecore")) continue;
            gm = CincoUtil.getImportedGenmodel(i);
            extensions.add(CincoUtil.getFileExtension(gm));
        }
        extensions.add(graphModel.getFileExtension());
        return extensions;
    }

    public static IFile getFile(URI uri, EObject obj) {
        IFile file = null;
        file = uri.isPlatform() ? workspaceExtension.getFile(uri) : workspaceExtension.getIResource(obj).getProject().getFile((IPath)new Path(uri.toString()));
        return file;
    }

    public static GenModel getImportedGenmodel(Import imprt) {
        String importURI = imprt.getImportURI();
        if (importURI.endsWith(".ecore")) {
            URI uri = URI.createURI((String)FilenameUtils.removeExtension((String)imprt.getImportURI()).concat(".genmodel"));
            Resource res = CincoUtil.getResource(uri.toString(), imprt.eResource());
            return (GenModel)resourceExtension.getContent(res, GenModel.class, 0);
        }
        return null;
    }

    public static MGLModel getImportedMGLModel(Import imprt) {
        URI uri = URI.createURI((String)imprt.getImportURI(), (boolean)true);
        IFile file = CincoUtil.getFile(uri, (EObject)imprt);
        return file != null ? (MGLModel)fileExtension.getContent(file, MGLModel.class, 0) : null;
    }

    public static GraphModel getImportedGraphModel(Import imprt) {
        URI uri = URI.createURI((String)imprt.getImportURI(), (boolean)true);
        IFile file = CincoUtil.getFile(uri, (EObject)imprt);
        return (GraphModel)fileExtension.getContent(file, GraphModel.class, 0);
    }

    public static List<GraphModel> getImportedGraphModels(Import imprt) {
        URI uri = URI.createURI((String)imprt.getImportURI(), (boolean)true);
        IFile file = CincoUtil.getFile(uri, (EObject)imprt);
        ArrayList<GraphModel> resultList = new ArrayList<GraphModel>();
        resultList.addAll((Collection<GraphModel>)((MGLModel)fileExtension.getContent(file, MGLModel.class, 0)).getGraphModels());
        return resultList;
    }

    private static String getFileExtension(GenModel genModel) {
        Iterator iterator = genModel.getAllGenPackagesWithClassifiers().iterator();
        if (iterator.hasNext()) {
            GenPackage gp = (GenPackage)iterator.next();
            return gp.getFileExtension();
        }
        return "";
    }

    public static CincoProduct getCPD(IFile cpdFile) {
        URI uri = URI.createFileURI((String)cpdFile.getLocation().toString());
        Resource res = new ResourceSetImpl().getResource(uri, true);
        if (res == null) {
            throw new RuntimeException("Could not load resource for: " + uri);
        }
        if (res.getContents().isEmpty()) {
            throw new RuntimeException("Resource: \"" + res + "\" is empty...");
        }
        return (CincoProduct)res.getContents().get(0);
    }

    public static void addExtension(String pluginXMLPath, String content, String extensionCommentID, String projectName) {
        String p = pluginXMLPath;
        String c = content;
        String pName = projectName;
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            File f = new File(p);
            if (f.exists()) {
                FileInputStream fis = new FileInputStream(f);
                BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
                String line = null;
                String originalText = new String();
                while ((line = reader.readLine()) != null) {
                    originalText = String.valueOf(originalText) + line.concat("\n");
                }
                fis.close();
                fis = new FileInputStream(f);
                reader = new BufferedReader(new InputStreamReader(fis));
                String CINCO_GEN = extensionCommentID;
                ArrayList<String> extensions = CincoUtil.getExtensionsWithDOM(originalText);
                ArrayList<String> remove = new ArrayList<String>();
                for (String ext : extensions) {
                    if (!ext.contains(CINCO_GEN)) continue;
                    remove.add(ext);
                }
                extensions.removeAll(remove);
                StringBuilder updatedText = new StringBuilder(PLUGIN_FRAME);
                int offset = updatedText.indexOf("</plugin>");
                for (String ext : extensions) {
                    updatedText.insert(offset, ext);
                }
                updatedText.insert(offset, c);
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(updatedText.toString().getBytes());
                fos.close();
                fis.close();
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(PLUGIN_FRAME);
                int offset = sb.indexOf("</plugin>");
                sb.insert(offset, c);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pName);
                IFile file = project.getFile("plugin.xml");
                if (!file.exists()) {
                    file.create((InputStream)new StringInputStream(sb.toString()), true, (IProgressMonitor)monitor);
                } else {
                    file.setContents((InputStream)new StringInputStream(sb.toString()), 2, (IProgressMonitor)monitor);
                }
                file.getProject().refreshLocal(2, (IProgressMonitor)monitor);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static Resource getResource(String path, Resource res) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        URI uri = URI.createURI((String)path);
        if (uri.isPlatform()) {
            return res.getResourceSet().getResource(uri, true);
        }
        IFile resFile = null;
        resFile = res.getURI().isPlatform() ? root.getFile((IPath)new Path(res.getURI().toPlatformString(true))) : root.getFileForLocation(Path.fromOSString((String)res.getURI().path()));
        IFile file = resFile.getProject().getFile(path);
        return res.getResourceSet().getResource(CincoUtil.getURI(file), true);
    }

    private static URI getURI(IFile file) {
        if (file != null && file.exists()) {
            return URI.createPlatformResourceURI((String)file.getFullPath().toPortableString(), (boolean)true);
        }
        return null;
    }

    private static ArrayList<String> getExtensionsWithDOM(String origText) {
        try {
            ArrayList<String> extensions = new ArrayList<String>();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse((InputStream)new StringInputStream(origText));
            doc.getDocumentElement().normalize();
            NodeList extensionNodes = doc.getElementsByTagName("extension");
            int extensionIndex = 0;
            while (extensionIndex < extensionNodes.getLength()) {
                org.w3c.dom.Node extensionNode = extensionNodes.item(extensionIndex);
                StringWriter writer = new StringWriter();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.transform(new DOMSource(extensionNode), new StreamResult(writer));
                String extensionString = writer.toString();
                extensionString = extensionString.substring(extensionString.indexOf("?>") + 2);
                extensions.add(extensionString);
                ++extensionIndex;
            }
            return extensions;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void writeContentToFile(IFile file, String contents) {
        StringInputStream sis = new StringInputStream(contents);
        try {
            if (file.exists()) {
                file.setContents((InputStream)sis, 1, null);
            } else {
                file.create((InputStream)sis, true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static Annotation findAnnotation(ModelElement modelElement, String annotName) {
        EList anno = modelElement.getAnnotations();
        for (Annotation next : anno) {
            if (!next.getName().equals(annotName)) continue;
            return next;
        }
        return null;
    }

    public static Annotation findAnnotationPostCreate(ModelElement modelElement) {
        return CincoUtil.findAnnotation(modelElement, "postCreate");
    }

    public static Annotation findAnnotationPostMove(ModelElement modelElement) {
        return CincoUtil.findAnnotation(modelElement, "postMove");
    }

    public static Annotation findAnnotationPostResize(ModelElement modelElement) {
        return CincoUtil.findAnnotation(modelElement, "postResize");
    }

    public static Annotation findAnnotationPostSelect(ModelElement modelElement) {
        return CincoUtil.findAnnotation(modelElement, "postSelect");
    }

    public static Annotation findAnnotationDoubleClick(ModelElement modelElement) {
        return CincoUtil.findAnnotation(modelElement, "doubleClickAction");
    }

    public static Annotation findAnnotationDisable(ModelElement modelElement) {
        return CincoUtil.findAnnotation(modelElement, ID_DISABLE);
    }

    public static boolean hasAnnotationDisableCreate(ModelElement modelElement) {
        Annotation anno = CincoUtil.findAnnotationDisable(modelElement);
        if (anno == null) {
            return false;
        }
        return anno.getValue().contains((Object)ID_DISABLE_CREATE);
    }

    public static boolean hasAnnotationDisableDelete(ModelElement modelElement) {
        Annotation anno = CincoUtil.findAnnotationDisable(modelElement);
        if (anno == null) {
            return false;
        }
        return anno.getValue().contains((Object)ID_DISABLE_DELETE);
    }

    public static boolean hasAnnotationDisableMove(ModelElement modelElement) {
        Annotation anno = CincoUtil.findAnnotationDisable(modelElement);
        if (anno == null) {
            return false;
        }
        return anno.getValue().contains((Object)ID_DISABLE_MOVE);
    }

    public static boolean hasAnnotationDisableReconnect(ModelElement modelElement) {
        Annotation anno = CincoUtil.findAnnotationDisable(modelElement);
        if (anno == null) {
            return false;
        }
        return anno.getValue().contains((Object)ID_DISABLE_RECONNECT);
    }

    public static boolean hasAnnotationDisableResize(ModelElement modelElement) {
        Annotation anno = CincoUtil.findAnnotationDisable(modelElement);
        if (anno == null) {
            return false;
        }
        return anno.getValue().contains((Object)ID_DISABLE_RESIZE);
    }

    public static boolean hasAnnotationDisableSelect(ModelElement modelElement) {
        Annotation anno = CincoUtil.findAnnotationDisable(modelElement);
        if (anno == null) {
            return false;
        }
        return anno.getValue().contains((Object)ID_DISABLE_SELECT);
    }
}

