/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CincoProperties
extends Properties {
    public static final String CONFIG_FOLDER = ".cinco";
    public static final String PROPERTIES_FILE_NAME = "cinco.properties";
    private static final Pair<String, Integer> MAX_THREADS = Pair.of((Object)"maxThreads", (Object)0);
    private static final Pair<String, String> DELETE_FOLDERS = Pair.of((Object)"deleteFolders", (Object)"");
    private static final Pair<String, String> VM_ARGS = Pair.of((Object)"vmArgs", (Object)"");
    private static final String OS_NAME = System.getProperty("os.name");
    private static CincoProperties INSTANCE;
    private static boolean headlessEnvironment;
    private static boolean shutdown;

    static {
        headlessEnvironment = false;
        shutdown = false;
    }

    private CincoProperties() {
    }

    public static CincoProperties newInstance() {
        CincoProperties _doubleArrow;
        CincoProperties _cincoProperties = new CincoProperties();
        Procedures.Procedure1<CincoProperties> _function = new Procedures.Procedure1<CincoProperties>(){

            public void apply(CincoProperties it) {
                it.load();
            }
        };
        INSTANCE = _doubleArrow = (CincoProperties)ObjectExtensions.operator_doubleArrow((Object)_cincoProperties, (Procedures.Procedure1)_function);
        return INSTANCE;
    }

    public static CincoProperties getInstance() {
        CincoProperties _newInstance;
        CincoProperties _elvis = null;
        _elvis = INSTANCE != null ? INSTANCE : (_newInstance = CincoProperties.newInstance());
        return _elvis;
    }

    public static Integer getMaxThreads() {
        return CincoProperties.getIntValue(MAX_THREADS);
    }

    public static List<String> getDeleteFolders() {
        return CincoProperties.getStrValues(DELETE_FOLDERS);
    }

    public static String getVmArgs() {
        return CincoProperties.getStrValue(VM_ARGS);
    }

    public static String getOSName() {
        return OS_NAME;
    }

    public static boolean isWindows() {
        return CincoProperties.getOSName().toLowerCase().contains("windows");
    }

    public void load() {
        String home = System.getProperty("user.home");
        if (home != null) {
            try {
                File file = Paths.get(home, new String[0]).resolve(CONFIG_FOLDER).resolve(PROPERTIES_FILE_NAME).toFile();
                boolean _exists = file.exists();
                if (_exists) {
                    FileInputStream _fileInputStream = new FileInputStream(file);
                    this.load(_fileInputStream);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    public String load(IProject project) {
        try {
            String _xblockexpression = null;
            InputOutput.println((Object)"Loading Cinco Properties...");
            IFile file = project.getFile(PROPERTIES_FILE_NAME);
            boolean _exists = file.exists();
            if (_exists) {
                super.load(file.getContents());
            }
            _xblockexpression = (String)InputOutput.println((Object)("Cinco Properties: " + this));
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static String getStrValue(Pair<String, String> p) {
        String _value;
        String _elvis = null;
        String _property = CincoProperties.getInstance().getProperty((String)p.getKey());
        _elvis = _property != null ? _property : (_value = (String)p.getValue());
        return _elvis;
    }

    private static List<String> getStrValues(Pair<String, String> p) {
        String _value;
        String _elvis = null;
        String _property = CincoProperties.getInstance().getProperty((String)p.getKey());
        _elvis = _property != null ? _property : (_value = (String)p.getValue());
        return IterableExtensions.toList(CincoProperties.splitValues(_elvis));
    }

    private static Integer getIntValue(Pair<String, Integer> p) {
        Integer _xblockexpression = null;
        String value = CincoProperties.getInstance().getProperty((String)p.getKey());
        Integer _xifexpression = null;
        _xifexpression = value != null ? Integer.valueOf(Integer.parseInt(value)) : (Integer)p.getValue();
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private static Iterable<String> splitValues(String listOfValues) {
        Iterable<String> _elvis = null;
        String[] _split = null;
        if (listOfValues != null) {
            _split = listOfValues.split(",");
        }
        List _map = null;
        if ((List)Conversions.doWrapArray((Object)_split) != null) {
            Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

                public String apply(String it) {
                    return it.trim();
                }
            };
            _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_split)), (Functions.Function1)_function);
        }
        Iterable<String> _filter = null;
        if (_map != null) {
            Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String it) {
                    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it);
                    return !_isNullOrEmpty;
                }
            };
            _filter = IterableExtensions.filter((Iterable)_map, (Functions.Function1)_function_1);
        }
        _elvis = _filter != null ? _filter : Collections.unmodifiableList(CollectionLiterals.newArrayList());
        return _elvis;
    }

    public static boolean headless(boolean headless) {
        headlessEnvironment = headless;
        return headlessEnvironment;
    }

    public static boolean isHeadless() {
        return headlessEnvironment;
    }

    public static boolean shutdown(boolean shouldShutdown) {
        shutdown = shouldShutdown;
        return shutdown;
    }

    public static boolean shouldShutdown() {
        return shutdown;
    }
}

