/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils;

import java.util.HashSet;
import java.util.Set;

public class BundleRegistry {
    public static BundleRegistry INSTANCE = new BundleRegistry();
    private Set<String> pluginIDs = new HashSet<String>();
    private Set<String> fragmentIDs = new HashSet<String>();
    private Set<String> modules = new HashSet<String>();

    private BundleRegistry() {
    }

    public static BundleRegistry resetRegistry() {
        INSTANCE = new BundleRegistry();
        return INSTANCE;
    }

    public Set<String> getPluginIDs() {
        return this.pluginIDs;
    }

    public Set<String> getFragmentIDs() {
        return this.fragmentIDs;
    }

    public Set<String> getModules() {
        return this.modules;
    }

    public boolean addBundle(String bundleID, boolean isFragment) {
        return this.addBundle(bundleID, isFragment, false);
    }

    public boolean addBundle(String bundleID, boolean isFragment, boolean isModule) {
        if (isModule) {
            this.modules.add(bundleID);
        }
        if (!isFragment) {
            return this.pluginIDs.add(bundleID);
        }
        return this.fragmentIDs.add(bundleID);
    }

    public boolean removeFragment(String fragmentID) {
        return this.fragmentIDs.remove(fragmentID);
    }

    public boolean removePlugin(String pluginID) {
        return this.pluginIDs.remove(pluginID);
    }
}

