/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.util.xapi;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.util.xapi.CodingExtension;
import de.jabc.cinco.meta.util.xapi.CollectionExtension;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class WorkspaceExtension {
    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public IWorkspaceRoot getWorkspaceRoot() {
        return this.getWorkspace().getRoot();
    }

    public IResource getIResource(URI uri) {
        IResource _xifexpression = null;
        if (uri != null) {
            IWorkspaceRoot _root = this.getWorkspace().getRoot();
            String _xifexpression_1 = null;
            boolean _isPlatformResource = uri.isPlatformResource();
            _xifexpression_1 = _isPlatformResource ? uri.toPlatformString(true) : uri.path();
            _xifexpression = _root.findMember(_xifexpression_1);
        }
        return _xifexpression;
    }

    public IResource getIResource(EObject eobj) {
        return this.getIResource(EcoreUtil.getURI((EObject)eobj));
    }

    public IProject getProject(EObject eobj) {
        URI _uRI = EcoreUtil.getURI((EObject)eobj);
        IResource _iResource = null;
        if (_uRI != null) {
            _iResource = this.getIResource(_uRI);
        }
        IProject _project = null;
        if (_iResource != null) {
            _project = _iResource.getProject();
        }
        return _project;
    }

    public IFile getFile(URI uri) {
        IFile _xblockexpression = null;
        IResource res = this.getIResource(uri);
        IFile _xifexpression = null;
        _xifexpression = res instanceof IFile ? (IFile)res : null;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public IFile getFile(EObject eobj) {
        return this.getFile(EcoreUtil.getURI((EObject)eobj));
    }

    public <T extends IResource> T create(T resource) throws CoreException {
        boolean _not;
        if (resource == null || resource.exists()) {
            return resource;
        }
        final NullProgressMonitor monitor = new NullProgressMonitor();
        boolean _exists = resource.getParent().exists();
        boolean bl = _not = !_exists;
        if (_not) {
            this.create(resource.getParent());
        }
        int _type = resource.getType();
        switch (_type) {
            case 1: {
                ((IFile)resource).create(this.newEmptyInputStream(), true, (IProgressMonitor)monitor);
                break;
            }
            case 2: {
                ((IFolder)resource).create(true, true, (IProgressMonitor)monitor);
                break;
            }
            case 4: {
                Procedures.Procedure1<IProject> _function = new Procedures.Procedure1<IProject>(){

                    public void apply(IProject it) {
                        try {
                            it.create((IProgressMonitor)monitor);
                            it.open((IProgressMonitor)monitor);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)((IProject)resource), (Procedures.Procedure1)_function);
            }
        }
        return resource;
    }

    public IFile createFile(IContainer container, String name, CharSequence content) {
        String _string = null;
        if (content != null) {
            _string = content.toString();
        }
        return this.createFile(container, name, _string, true);
    }

    public IFile createFile(IContainer container, String name, String content) {
        return this.createFile(container, name, content, true);
    }

    public IFile createFile(IContainer container, String name, String content, boolean createFolders) {
        Path _path = new Path(name);
        IFile file = container.getFile((IPath)_path);
        InputStream stream = this.toInputStream(content, this.getCharsetObject(file));
        try {
            this.createFile(container, name, stream, createFolders);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return file;
    }

    public IFile createFile(IContainer container, String name, InputStream content) {
        return this.createFile(container, name, content, true);
    }

    public IFile createFile(IContainer container, String name, InputStream content, boolean createFolders) {
        try {
            IFile file;
            block10: {
                InputStream _newEmptyInputStream;
                int index;
                if (createFolders && (index = name.lastIndexOf("/")) > -1) {
                    String folderPath = name.substring(0, index);
                    this.createFolder(container, folderPath);
                }
                Path _path = new Path(name);
                file = container.getFile((IPath)_path);
                InputStream _elvis = null;
                _elvis = content != null ? content : (_newEmptyInputStream = this.newEmptyInputStream());
                try (InputStream stream = _elvis;){
                    try {
                        boolean _exists = file.exists();
                        if (_exists) {
                            file.setContents(stream, true, true, null);
                            break block10;
                        }
                        file.create(stream, true, null);
                    }
                    catch (Throwable _t) {
                        if (!(_t instanceof Exception)) {
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        Exception e = (Exception)_t;
                        e.printStackTrace();
                        stream.close();
                    }
                }
            }
            return file;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IFolder createFolder(IContainer container, String name) {
        Path _path = new Path(name);
        return this.createFolder(container, (IPath)_path);
    }

    public IFolder createFolder(IContainer container, IPath path) {
        boolean _not;
        IFolder folder = container.getFolder(path);
        boolean _exists = folder.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            try {
                this.create(folder);
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return folder;
    }

    public IContainer createFolders(IContainer container, IPath path) {
        String[] _segments;
        IContainer _xblockexpression = null;
        IContainer currentContainer = container;
        String[] stringArray = _segments = path.segments();
        int n = _segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            Path _path = new Path(segment);
            currentContainer = this.createFolder(currentContainer, (IPath)_path);
            ++n2;
        }
        _xblockexpression = currentContainer;
        return _xblockexpression;
    }

    public void delete(IResource resource) {
        try {
            if (resource == null || !resource.exists()) {
                return;
            }
            NullProgressMonitor monitor = new NullProgressMonitor();
            int _type = resource.getType();
            switch (_type) {
                case 1: {
                    ((IFile)resource).delete(true, false, (IProgressMonitor)monitor);
                    break;
                }
                case 2: {
                    ((IFolder)resource).delete(true, false, (IProgressMonitor)monitor);
                    break;
                }
                case 4: {
                    ((IProject)resource).delete(true, true, (IProgressMonitor)monitor);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public List<IFile> getFiles(IContainer container) {
        return this.getFiles(container, null);
    }

    public List<IFile> getFiles(IContainer container, Predicate<IFile> fileConstraint) {
        return this.getResources(container, IFile.class, fileConstraint, null);
    }

    public List<IFile> getFiles(IContainer container, Predicate<IFile> fileConstraint, Predicate<IContainer> contConstraint) {
        return this.getResources(container, IFile.class, fileConstraint, contConstraint);
    }

    public IFolder getFolder(IContainer container) {
        IFolder _xblockexpression = null;
        IPath path = container.getProjectRelativePath();
        if (path == null) {
            return null;
        }
        _xblockexpression = container.getFolder(path);
        return _xblockexpression;
    }

    public <T extends IResource> List<T> getResources(IContainer container, Class<T> clazz) {
        return this.getResources(container, clazz, null, null);
    }

    public <T extends IResource> List<T> getResources(IContainer container, Class<T> clazz, Predicate<T> resConstraint) {
        return this.getResources(container, clazz, resConstraint, null);
    }

    public <T extends IResource> List<T> getResources(IContainer container, Class<T> clazz, Predicate<T> resConstraint, Predicate<IContainer> contConstraint) {
        ArrayList list = CollectionLiterals.newArrayList();
        if (container == null || !container.exists() || !container.isAccessible() || contConstraint != null && !contConstraint.test(container)) {
            return list;
        }
        IResource[] members = null;
        try {
            members = container.members();
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException e = (CoreException)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        if (members != null) {
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                boolean _isAssignableFrom = clazz.isAssignableFrom(member.getClass());
                if (_isAssignableFrom) {
                    IResource resource = member;
                    if (resConstraint == null || resConstraint.test(resource)) {
                        list.add(resource);
                    }
                }
                if (member instanceof IContainer) {
                    IContainer cont = (IContainer)member;
                    list.addAll(this.getResources(cont, clazz, resConstraint, contConstraint));
                }
                ++n2;
            }
        }
        return list;
    }

    public Resource createResource(final URI uri) {
        Resource _xblockexpression = null;
        final CodingExtension ext = new CodingExtension();
        Functions.Function1<CodingExtension.FunctionArgumentsNotSupported, Resource> _function = new Functions.Function1<CodingExtension.FunctionArgumentsNotSupported, Resource>(){

            public Resource apply(CodingExtension.FunctionArgumentsNotSupported it) {
                return new ResourceSetImpl().getResource(uri, true);
            }
        };
        Procedures.Procedure1<Exception> _function_1 = new Procedures.Procedure1<Exception>(){

            public void apply(Exception it) {
                ext.warn(it, "Failed to create Resource object for URI: " + uri);
            }
        };
        _xblockexpression = ext.onException(_function, (Procedures.Procedure1<? super Exception>)_function_1);
        return _xblockexpression;
    }

    public BundleContext getOSGiContext(Object caller) {
        Bundle _bundle = FrameworkUtil.getBundle(caller.getClass());
        BundleContext _bundleContext = null;
        if (_bundle != null) {
            _bundleContext = _bundle.getBundleContext();
        }
        return _bundleContext;
    }

    public Iterable<URI> findFiles(Bundle bundle, String fileExtension) {
        ArrayList _newArrayList;
        Iterable _xblockexpression = null;
        CollectionExtension ext = new CollectionExtension();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)fileExtension);
        if (_isNullOrEmpty) {
            throw new IllegalArgumentException("fileExtension must not be empty");
        }
        ArrayList _elvis = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("*.");
        _builder.append(fileExtension);
        Enumeration _findEntries = bundle.findEntries("/", _builder.toString(), true);
        ArrayList _list = null;
        if (_findEntries != null) {
            _list = ext.toList(_findEntries);
        }
        _elvis = _list != null ? _list : (_newArrayList = CollectionLiterals.newArrayList());
        Functions.Function1<URL, String> _function = new Functions.Function1<URL, String>(){

            public String apply(URL it) {
                return it.toString();
            }
        };
        Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                return it.endsWith("/");
            }
        };
        Functions.Function1<String, URI> _function_2 = new Functions.Function1<String, URI>(){

            public URI apply(String it) {
                return URI.createURI((String)it);
            }
        };
        _xblockexpression = IterableExtensions.map(ext.drop(ListExtensions.map((List)_elvis, (Functions.Function1)_function), _function_1), (Functions.Function1)_function_2);
        return _xblockexpression;
    }

    public Iterable<IFile> findFilesInWorkspace(String fileExtension) {
        return this.findFilesInContainer((IContainer)this.getWorkspaceRoot(), fileExtension);
    }

    private Iterable<IFile> findFilesInContainer(IContainer container, String fileExtension) {
        try {
            IResource[] _members;
            HashSet<IFile> result = new HashSet<IFile>();
            IResource[] iResourceArray = _members = container.members();
            int n = _members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member instanceof IContainer) {
                    Iterables.addAll(result, this.findFilesInContainer((IContainer)member, fileExtension));
                } else if (member instanceof IFile && Objects.equal((Object)((IFile)member).getFileExtension(), (Object)fileExtension)) {
                    result.add((IFile)member);
                }
                ++n2;
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void cleanAndBuild(IProject it) {
        try {
            it.build(15, null);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void buildFull(IProject it) {
        try {
            it.build(6, null);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void buildIncremental(IProject it) {
        try {
            it.build(10, null);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Iterable<Object> getExtensions(String extensionPointID) {
        return this.getExtensions(extensionPointID, Object.class);
    }

    public <T> Iterable<T> getExtensions(String extensionPointID, Class<T> expectedType) {
        IExtensionRegistry _extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] _configurationElementsFor = null;
        if (_extensionRegistry != null) {
            _configurationElementsFor = _extensionRegistry.getConfigurationElementsFor(extensionPointID);
        }
        List _map = null;
        if ((List)Conversions.doWrapArray((Object)_configurationElementsFor) != null) {
            Functions.Function1<IConfigurationElement, Object> _function = new Functions.Function1<IConfigurationElement, Object>(){

                public Object apply(IConfigurationElement it) {
                    return WorkspaceExtension.this.createExecutableExtension(it);
                }
            };
            _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_configurationElementsFor)), (Functions.Function1)_function);
        }
        Iterable _filter = null;
        if (_map != null) {
            _filter = Iterables.filter(_map, expectedType);
        }
        return _filter;
    }

    public Object createExecutableExtension(IConfigurationElement elem) {
        Object _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = elem.createExecutableExtension("class");
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException e = (CoreException)_t;
                e.printStackTrace();
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    public Path toPath(String stringPath) {
        return new Path(stringPath);
    }

    public IFile createFile(IFile file, InputStream content) throws CoreException, OperationCanceledException {
        try {
            InputStream _newEmptyInputStream;
            boolean _not;
            boolean _exists = file.getParent().exists();
            boolean bl = _not = !_exists;
            if (_not) {
                this.create(file.getParent());
            }
            InputStream _elvis = null;
            _elvis = content != null ? content : (_newEmptyInputStream = this.newEmptyInputStream());
            try (InputStream stream = _elvis;){
                boolean _exists_1 = file.exists();
                if (_exists_1) {
                    file.setContents(stream, true, true, null);
                } else {
                    file.create(stream, true, null);
                }
            }
            return file;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IFile createFile(IFile file, String content) {
        try {
            InputStream stream = this.toInputStream(content, this.getCharsetObject(file));
            return this.createFile(file, stream);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IFile createFile(IFile file, CharSequence content) {
        String _string = null;
        if (content != null) {
            _string = content.toString();
        }
        return this.createFile(file, _string);
    }

    public IFile createFile(IFile file, StringBuilder content) {
        String _string = null;
        if (content != null) {
            _string = content.toString();
        }
        return this.createFile(file, _string);
    }

    public IFile createFile(IFile file) {
        try {
            return this.createFile(file, (InputStream)null);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IPath makeWorkspaceRelative(IPath path) {
        IPath _xifexpression = null;
        _xifexpression = path.isAbsolute() && this.getWorkspaceRoot().getLocation().isPrefixOf(path) ? path.makeRelativeTo(this.getWorkspaceRoot().getLocation()) : path;
        return _xifexpression;
    }

    public IFile getFile(IPath path) {
        return this.getWorkspaceRoot().getFile(this.makeWorkspaceRelative(path));
    }

    public boolean exists(IPath path) {
        return this.getFile(path).exists();
    }

    public IFile createFile(IPath path, InputStream content) {
        try {
            return this.createFile(this.getFile(path), content);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IFile createFile(IPath path, String content) {
        return this.createFile(this.getFile(path), content);
    }

    public IFile createFile(IPath path, CharSequence content) {
        return this.createFile(this.getFile(path), content);
    }

    public IFile createFile(IPath path, StringBuilder content) {
        return this.createFile(this.getFile(path), content);
    }

    public IFile createFile(IPath path) {
        return this.createFile(this.getFile(path));
    }

    public InputStream toInputStream(String content, Charset charset) {
        Charset _defaultCharset;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)content);
        if (_isNullOrEmpty) {
            return this.newEmptyInputStream();
        }
        Charset _elvis = null;
        _elvis = charset != null ? charset : (_defaultCharset = Charset.defaultCharset());
        Charset nullsafeCharset = _elvis;
        byte[] bytes = content.getBytes(nullsafeCharset);
        return new ByteArrayInputStream(bytes);
    }

    public InputStream toInputStream(String content, String charsetName) {
        InputStream _xblockexpression = null;
        Charset _xtrycatchfinallyexpression = null;
        try {
            Charset _forName;
            _xtrycatchfinallyexpression = _forName = Charset.forName(charsetName);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                _xtrycatchfinallyexpression = null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        Charset charset = _xtrycatchfinallyexpression;
        _xblockexpression = this.toInputStream(content, charset);
        return _xblockexpression;
    }

    public InputStream toInputStream(String content) {
        return this.toInputStream(content, (Charset)null);
    }

    public InputStream newEmptyInputStream() {
        byte[] _newByteArrayOfSize = new byte[]{};
        return new ByteArrayInputStream(_newByteArrayOfSize);
    }

    public Charset getCharsetObject(IFile file) {
        try {
            return Charset.forName(file.getCharset());
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace();
                return Charset.defaultCharset();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

