/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.util.xapi;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.util.xapi.CollectionExtension;
import de.jabc.cinco.meta.util.xapi.ResourceExtension;
import de.jabc.cinco.meta.util.xapi.WorkbenchExtension;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class FileExtension {
    public URI getPlatformResourceURI(IFile file) {
        try {
            return URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true);
        }
        catch (Throwable _t) {
            if (_t instanceof NullPointerException) {
                NullPointerException e = (NullPointerException)_t;
                String _format = String.format("URI can't be created from path \"%s\"", file.getFullPath().toOSString());
                throw new RuntimeException(_format, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public Resource getResource(IFile file) {
        return this.getResource(this.getPlatformResourceURI(file));
    }

    public Resource getResource(URI uri) {
        return new ResourceSetImpl().getResource(uri, true);
    }

    public <T extends EObject> T getContent(IFile file, Class<T> contentClass, int defaultIndex) {
        T _xblockexpression = null;
        ResourceExtension ResourceExtension2 = new ResourceExtension();
        _xblockexpression = ResourceExtension2.getContent(this.getResource(file), contentClass, defaultIndex);
        return _xblockexpression;
    }

    public <T extends EObject> T getContent(IFile file, Class<T> contentClass) {
        T _xblockexpression = null;
        ResourceExtension ResourceExtension2 = new ResourceExtension();
        _xblockexpression = ResourceExtension2.getContent(this.getResource(file), contentClass);
        return _xblockexpression;
    }

    public IEditorPart getEditor(final IFile file) {
        IEditorPart _xblockexpression = null;
        final WorkbenchExtension ext = new WorkbenchExtension();
        Predicate<IEditorPart> _function = new Predicate<IEditorPart>(){

            @Override
            public boolean test(IEditorPart it) {
                Resource _resource = ext.getResource(it);
                Resource _resource_1 = FileExtension.this.getResource(file);
                return Objects.equal((Object)_resource, (Object)_resource_1);
            }
        };
        _xblockexpression = ext.getEditor(_function);
        return _xblockexpression;
    }

    public IEditorPart openInEditor(IFile file) {
        try {
            IEditorPart _xblockexpression = null;
            WorkbenchExtension ext = new WorkbenchExtension();
            _xblockexpression = IDE.openEditor((IWorkbenchPage)ext.getActivePage(), (IFile)file);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Iterable<URI> findFiles(final JarFile archive, final String ... fileExtensions) {
        Iterable _xblockexpression = null;
        CollectionExtension ext = new CollectionExtension();
        Functions.Function1<JarEntry, Boolean> _function = new Functions.Function1<JarEntry, Boolean>(){

            public Boolean apply(JarEntry it) {
                boolean _isEmpty;
                boolean _xblockexpression = false;
                final String fe = FilenameUtils.getExtension((String)it.toString());
                Iterable _filter = null;
                if ((Iterable)Conversions.doWrapArray((Object)fileExtensions) != null) {
                    Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                        public Boolean apply(String it) {
                            return it.equalsIgnoreCase(fe);
                        }
                    };
                    _filter = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)fileExtensions)), (Functions.Function1)_function);
                }
                _xblockexpression = !(_isEmpty = IterableExtensions.isEmpty(_filter));
                return _xblockexpression;
            }
        };
        Functions.Function1<JarEntry, URI> _function_1 = new Functions.Function1<JarEntry, URI>(){

            public URI apply(JarEntry it) {
                return FileExtension.this.getURI(archive, it);
            }
        };
        _xblockexpression = IterableExtensions.map((Iterable)IterableExtensions.filter(ext.toList(archive.entries()), (Functions.Function1)_function), (Functions.Function1)_function_1);
        return _xblockexpression;
    }

    public URI getURI(JarFile archive, JarEntry entry) {
        String _name = archive.getName();
        String _plus = "jar:file:" + _name;
        String _plus_1 = String.valueOf(_plus) + "!/";
        String _plus_2 = String.valueOf(_plus_1) + entry;
        return URI.createURI((String)_plus_2);
    }

    public void writeContent(IFile file, String content) {
        try {
            if (file != null && file.exists()) {
                StringInputStream _stringInputStream = new StringInputStream(content);
                file.setContents((InputStream)_stringInputStream, true, true, null);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ArrayList<IFile> findFiles(IContainer container, final String fileExtension) {
        try {
            IResource[] members;
            ArrayList<IFile> _xblockexpression = null;
            ArrayList<IFile> found = new ArrayList<IFile>();
            IResource[] _converted_members = members = container.members();
            Functions.Function1<IFile, Boolean> _function = new Functions.Function1<IFile, Boolean>(){

                public Boolean apply(IFile it) {
                    return !StringExtensions.isNullOrEmpty((String)it.getFileExtension()) && Objects.equal((Object)it.getFileExtension(), (Object)fileExtension);
                }
            };
            Iterables.addAll(found, (Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_members)), IFile.class), (Functions.Function1)_function));
            IResource[] _converted_members_1 = members;
            Iterable containers = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_members_1)), IContainer.class);
            Stack stack = new Stack();
            Iterables.addAll(stack, (Iterable)containers);
            while (!stack.isEmpty()) {
                IContainer currentContainer = (IContainer)stack.pop();
                IResource[] _converted_members_2 = members = currentContainer.members();
                Functions.Function1<IFile, Boolean> _function_1 = new Functions.Function1<IFile, Boolean>(){

                    public Boolean apply(IFile it) {
                        return !StringExtensions.isNullOrEmpty((String)it.getFileExtension()) && Objects.equal((Object)it.getFileExtension(), (Object)fileExtension);
                    }
                };
                Iterables.addAll(found, (Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_members_2)), IFile.class), (Functions.Function1)_function_1));
                IResource[] _converted_members_3 = members;
                Iterables.addAll(stack, (Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_members_3)), IContainer.class));
            }
            _xblockexpression = found;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

