/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class Table {
    private boolean useSafeCharacters = false;
    private String[] header;
    private Alignment[] alignment;
    private LinkedList<String[]> rows;
    private int[] columnWidths;
    private int columnCount;

    public Table() {
        this.header = new String[0];
        this.alignment = new Alignment[0];
        this.rows = CollectionLiterals.newLinkedList();
        this.columnWidths = new int[0];
        this.columnCount = 0;
    }

    public Table(String ... header) {
        this.setHeader(header);
        this.alignment = new Alignment[0];
        this.rows = CollectionLiterals.newLinkedList();
        this.columnWidths = new int[0];
        this.columnCount = 0;
    }

    public Table(Object ... header) {
        this.setHeader(header);
        this.alignment = new Alignment[0];
        this.rows = CollectionLiterals.newLinkedList();
        this.columnWidths = new int[0];
        this.columnCount = 0;
    }

    public Table setHeader(String ... header) {
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String value) {
                String _elvis = null;
                _elvis = value != null ? value : "(null)";
                return _elvis;
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)header)), (Functions.Function1)_function);
        this.header = (String[])Conversions.unwrapArray((Object)_map, String.class);
        return this;
    }

    public Table setHeader(Object ... header) {
        Functions.Function1<Object, String> _function = new Functions.Function1<Object, String>(){

            public String apply(Object value) {
                String _elvis = null;
                String _string = null;
                if (value != null) {
                    _string = value.toString();
                }
                _elvis = _string != null ? _string : "(null)";
                return _elvis;
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)header)), (Functions.Function1)_function);
        this.header = (String[])Conversions.unwrapArray((Object)_map, String.class);
        return this;
    }

    public Table setAlignment(Alignment ... alignment) {
        this.alignment = alignment;
        return this;
    }

    public Table addRow(String ... tuple) {
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String value) {
                String _elvis = null;
                _elvis = value != null ? value : "(null)";
                return _elvis;
            }
        };
        this.rows.add((String[])Conversions.unwrapArray((Object)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)tuple)), (Functions.Function1)_function), String.class));
        return this;
    }

    public Table addRow(Object ... tuple) {
        Functions.Function1<Object, String> _function = new Functions.Function1<Object, String>(){

            public String apply(Object value) {
                String _elvis = null;
                String _string = null;
                if (value != null) {
                    _string = value.toString();
                }
                _elvis = _string != null ? _string : "(null)";
                return _elvis;
            }
        };
        this.rows.add((String[])Conversions.unwrapArray((Object)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)tuple)), (Functions.Function1)_function), String.class));
        return this;
    }

    public Table addSeparator() {
        this.rows.add(null);
        return this;
    }

    public Table useSafeCharacters(boolean enable) {
        this.useSafeCharacters = enable;
        return this;
    }

    public String toString() {
        boolean _not;
        Functions.Function1<String[], Integer> _function = new Functions.Function1<String[], Integer>(){

            public Integer apply(String[] it) {
                return it.length;
            }
        };
        this.columnCount = Integer.max(this.header.length, (Integer)IterableExtensions.max((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull(this.rows), (Functions.Function1)_function)));
        Functions.Function1<Integer, Integer> _function_1 = new Functions.Function1<Integer, Integer>(){

            public Integer apply(final Integer i) {
                Functions.Function1<String[], Integer> _function = new Functions.Function1<String[], Integer>(){

                    public Integer apply(String[] it) {
                        return Table.this.safeLength((String)Table.this.safeGet((Iterable)Conversions.doWrapArray((Object)it), i));
                    }
                };
                return Integer.max(Table.this.safeLength((String)Table.this.safeGet((Iterable)Conversions.doWrapArray((Object)Table.this.header), i)), (Integer)IterableExtensions.max((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull(Table.this.rows), (Functions.Function1)_function)));
            }
        };
        this.columnWidths = (int[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)new ExclusiveRange(0, this.columnCount, true), (Functions.Function1)_function_1), Integer.TYPE);
        StringConcatenation _builder = new StringConcatenation();
        String _formatTop = this.formatTop();
        _builder.append(_formatTop);
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)this.header)));
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _formatRow = this.formatRow(this.header);
            _builder.append(_formatRow);
            _builder.newLineIfNotEmpty();
            String _formatSeparator = this.formatSeparator();
            _builder.append(_formatSeparator);
            _builder.newLineIfNotEmpty();
        }
        for (String[] row : this.rows) {
            String _formatRow_1 = this.formatRow(row);
            _builder.append(_formatRow_1);
            _builder.newLineIfNotEmpty();
        }
        String _formatBottom = this.formatBottom();
        _builder.append(_formatBottom);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public Table print() {
        InputOutput.print((Object)this.toString());
        return this;
    }

    private String formatValue(String[] row, int column) {
        Integer columnWidth = (Integer)this.safeGet((Iterable)Conversions.doWrapArray((Object)this.columnWidths), column);
        if (row == null) {
            if (this.useSafeCharacters) {
                return "-".repeat(columnWidth);
            }
            return "\u2500".repeat(columnWidth);
        }
        String _elvis = null;
        String _safeGet = (String)this.safeGet((Iterable)Conversions.doWrapArray((Object)row), column);
        _elvis = _safeGet != null ? _safeGet : "";
        String value = _elvis;
        if (value == null) {
            return " ".repeat(columnWidth);
        }
        int _length = value.length();
        int _minus = columnWidth - _length;
        String spaces = " ".repeat(_minus);
        Alignment _elvis_1 = null;
        Alignment _safeGet_1 = (Alignment)((Object)this.safeGet((Iterable)Conversions.doWrapArray((Object)this.alignment), column));
        _elvis_1 = _safeGet_1 != null ? _safeGet_1 : Alignment.LEFT;
        Alignment align = _elvis_1;
        String _switchResult = null;
        if (align != null) {
            switch (align) {
                case LEFT: {
                    _switchResult = String.valueOf(value) + spaces;
                    break;
                }
                case RIGHT: {
                    _switchResult = String.valueOf(spaces) + value;
                    break;
                }
            }
        }
        return _switchResult;
    }

    private String formatRow(final String[] row) {
        String _xifexpression = null;
        if (row == null) {
            _xifexpression = this.formatSeparator();
        } else {
            String _xifexpression_1 = null;
            if (this.useSafeCharacters) {
                Functions.Function1<Integer, CharSequence> _function = new Functions.Function1<Integer, CharSequence>(){

                    public CharSequence apply(Integer i) {
                        return Table.this.formatValue(row, i);
                    }
                };
                _xifexpression_1 = IterableExtensions.join((Iterable)new ExclusiveRange(0, this.columnCount, true), (CharSequence)"|", (CharSequence)"|", (CharSequence)"|", (Functions.Function1)_function);
            } else {
                Functions.Function1<Integer, CharSequence> _function_1 = new Functions.Function1<Integer, CharSequence>(){

                    public CharSequence apply(Integer i) {
                        return Table.this.formatValue(row, i);
                    }
                };
                _xifexpression_1 = IterableExtensions.join((Iterable)new ExclusiveRange(0, this.columnCount, true), (CharSequence)"\u2502", (CharSequence)"\u2502", (CharSequence)"\u2502", (Functions.Function1)_function_1);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private String formatTop() {
        String _xifexpression = null;
        if (!this.useSafeCharacters) {
            Functions.Function1<Integer, CharSequence> _function = new Functions.Function1<Integer, CharSequence>(){

                public CharSequence apply(Integer i) {
                    return Table.this.formatValue(null, i);
                }
            };
            _xifexpression = IterableExtensions.join((Iterable)new ExclusiveRange(0, this.columnCount, true), (CharSequence)"\u250c", (CharSequence)"\u252c", (CharSequence)"\u2510", (Functions.Function1)_function);
        }
        return _xifexpression;
    }

    private String formatSeparator() {
        String _xifexpression = null;
        if (this.useSafeCharacters) {
            Functions.Function1<Integer, CharSequence> _function = new Functions.Function1<Integer, CharSequence>(){

                public CharSequence apply(Integer i) {
                    return Table.this.formatValue(null, i);
                }
            };
            _xifexpression = IterableExtensions.join((Iterable)new ExclusiveRange(0, this.columnCount, true), (CharSequence)"|", (CharSequence)"+", (CharSequence)"|", (Functions.Function1)_function);
        } else {
            Functions.Function1<Integer, CharSequence> _function_1 = new Functions.Function1<Integer, CharSequence>(){

                public CharSequence apply(Integer i) {
                    return Table.this.formatValue(null, i);
                }
            };
            _xifexpression = IterableExtensions.join((Iterable)new ExclusiveRange(0, this.columnCount, true), (CharSequence)"\u251c", (CharSequence)"\u253c", (CharSequence)"\u2524", (Functions.Function1)_function_1);
        }
        return _xifexpression;
    }

    private String formatBottom() {
        String _xifexpression = null;
        if (!this.useSafeCharacters) {
            Functions.Function1<Integer, CharSequence> _function = new Functions.Function1<Integer, CharSequence>(){

                public CharSequence apply(Integer i) {
                    return Table.this.formatValue(null, i);
                }
            };
            _xifexpression = IterableExtensions.join((Iterable)new ExclusiveRange(0, this.columnCount, true), (CharSequence)"\u2514", (CharSequence)"\u2534", (CharSequence)"\u2518", (Functions.Function1)_function);
        }
        return _xifexpression;
    }

    private <T> T safeGet(Iterable<T> iterable, int index) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator == null) {
            return null;
        }
        int currentIndex = -1;
        while (iterator.hasNext()) {
            int _currentIndex = currentIndex;
            currentIndex = _currentIndex + 1;
            T currentObject = iterator.next();
            if (currentIndex != index) continue;
            return currentObject;
        }
        return null;
    }

    private int safeLength(String str) {
        if (str != null) {
            return str.length();
        }
        return 0;
    }

    public static enum Alignment {
        LEFT,
        RIGHT;

    }
}

