/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.util;

import de.jabc.cinco.meta.util.Table;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public class Stopwatch {
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PUBLIC_SETTER})
    private TimeUnit unit;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private boolean running;
    private long startTime;
    private final LinkedList<Long> times;
    private final LinkedList<String> labels;
    private final boolean debug;

    public Stopwatch() {
        this(TimeUnit.MILLISECOND, false);
    }

    public Stopwatch(boolean debug) {
        this(TimeUnit.MILLISECOND, debug);
    }

    public Stopwatch(TimeUnit unit) {
        this(unit, false);
    }

    public Stopwatch(TimeUnit unit, boolean debug) {
        this.unit = unit;
        this.running = false;
        this.startTime = 0L;
        this.times = CollectionLiterals.newLinkedList();
        this.labels = CollectionLiterals.newLinkedList();
        this.debug = debug;
    }

    public void start(String label) {
        if (this.running) {
            long endTime = System.nanoTime();
            this.times.add(endTime - this.startTime);
            this.startTime = endTime;
            if (this.debug) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Stop: ");
                String _last = this.labels.getLast();
                _builder.append(_last);
                _builder.append(": ");
                long _convert = this.convert(this.times.getLast());
                _builder.append((Object)_convert);
                _builder.append(" ");
                String _unitSymbol = this.getUnitSymbol();
                _builder.append(_unitSymbol);
                InputOutput.println((Object)_builder.toString());
            }
        } else {
            this.running = true;
            this.startTime = System.nanoTime();
        }
        this.labels.add(label);
        if (this.debug) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Start: ");
            String _last_1 = this.labels.getLast();
            _builder_1.append(_last_1);
            InputOutput.println((Object)_builder_1.toString());
        }
    }

    public void stop() {
        if (this.running) {
            long endTime = System.nanoTime();
            this.times.add(endTime - this.startTime);
            this.running = false;
            if (this.debug) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Stop: ");
                String _last = this.labels.getLast();
                _builder.append(_last);
                _builder.append(": ");
                long _convert = this.convert(this.times.getLast());
                _builder.append((Object)_convert);
                _builder.append(" ");
                String _unitSymbol = this.getUnitSymbol();
                _builder.append(_unitSymbol);
                InputOutput.println((Object)_builder.toString());
            }
        }
    }

    public void resume() {
        if (!this.running) {
            try {
                Long lastDuration = this.times.removeLast();
                this.running = true;
                long currentTime = System.nanoTime();
                this.startTime = currentTime - lastDuration;
                if (this.debug) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Resume: ");
                    String _last = this.labels.getLast();
                    _builder.append(_last);
                    InputOutput.println((Object)_builder.toString());
                }
            }
            catch (Throwable _t) {
                if (_t instanceof NoSuchElementException) {
                    System.err.println("Stopwatch: No measurement to resume");
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    public void reset() {
        this.running = false;
        this.times.clear();
        this.labels.clear();
    }

    public long getTotal() {
        Functions.Function2<Long, Long, Long> _function = new Functions.Function2<Long, Long, Long>(){

            public Long apply(Long a, Long b) {
                return a + b;
            }
        };
        return this.convert((Long)IterableExtensions.fold(this.times, (Object)0L, (Functions.Function2)_function));
    }

    public long getTime(int i) {
        return this.convert(this.times.get(i));
    }

    public List<Pair<String, Long>> getTimes() {
        List _xblockexpression = null;
        this.stop();
        int _size = this.times.size();
        Functions.Function1<Integer, Pair<String, Long>> _function = new Functions.Function1<Integer, Pair<String, Long>>(){

            public Pair<String, Long> apply(Integer i) {
                String _label = Stopwatch.this.getLabel(i);
                long _time = Stopwatch.this.getTime(i);
                return Pair.of((Object)_label, (Object)_time);
            }
        };
        _xblockexpression = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)new ExclusiveRange(0, _size, true), (Functions.Function1)_function));
        return _xblockexpression;
    }

    public String getLabel(int i) {
        return this.labels.get(i);
    }

    public ArrayList<String> getLabels() {
        ArrayList list = CollectionLiterals.newArrayList();
        list.addAll(this.labels);
        return list;
    }

    public String getUnitSymbol() {
        return Stopwatch.getUnitSymbol(this.unit);
    }

    public String getTable() {
        String _xblockexpression = null;
        this.stop();
        Functions.Function2<Long, Long, Long> _function = new Functions.Function2<Long, Long, Long>(){

            public Long apply(Long a, Long b) {
                return a + b;
            }
        };
        Long totalNanoSeconds = (Long)IterableExtensions.fold(this.times, (Object)0L, (Functions.Function2)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Time [");
        String _unitSymbol = this.getUnitSymbol();
        _builder.append(_unitSymbol);
        _builder.append("]");
        Table table = new Table("No.", "Label", _builder, "Relative [%]").setAlignment(Table.Alignment.RIGHT, Table.Alignment.LEFT, Table.Alignment.RIGHT, Table.Alignment.RIGHT);
        int _size = this.times.size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (Integer i : _doubleDotLessThan) {
            Long _get = this.times.get(i);
            double _multiply = 10000.0 * (double)_get.longValue();
            double _divide = _multiply / (double)totalNanoSeconds.longValue();
            long _round = Math.round(_divide);
            double relative = (double)_round / 100.0;
            table.addRow(i, this.getLabel(i), this.getTime(i), String.format(Locale.ENGLISH, "%.2f", relative));
        }
        _xblockexpression = table.addSeparator().addRow("", "Total", this.convert(totalNanoSeconds), String.format(Locale.ENGLISH, "%.2f", 100.0)).toString();
        return _xblockexpression;
    }

    public String printTable() {
        return (String)InputOutput.println((Object)this.getTable());
    }

    private long convert(long time) {
        return Stopwatch.convert(time, TimeUnit.NANOSECOND, this.unit);
    }

    public static long convert(long time, TimeUnit source, TimeUnit target) {
        if (source == target) {
            return time;
        }
        double _switchResult = 0.0;
        if (source != null) {
            switch (source) {
                case NANOSECOND: {
                    _switchResult = 1.0;
                    break;
                }
                case MICROSECOND: {
                    _switchResult = 1000.0;
                    break;
                }
                case MILLISECOND: {
                    _switchResult = 1000000.0;
                    break;
                }
                case SECOND: {
                    _switchResult = 1.0E9;
                    break;
                }
                case MINUTE: {
                    _switchResult = 6.0E10;
                    break;
                }
                case HOUR: {
                    _switchResult = 3.6E12;
                    break;
                }
                case DAY: {
                    _switchResult = 8.64E13;
                    break;
                }
            }
        }
        double toNanoSeconds = _switchResult;
        double _switchResult_1 = 0.0;
        if (target != null) {
            switch (target) {
                case NANOSECOND: {
                    _switchResult_1 = 1.0;
                    break;
                }
                case MICROSECOND: {
                    _switchResult_1 = 1000.0;
                    break;
                }
                case MILLISECOND: {
                    _switchResult_1 = 1000000.0;
                    break;
                }
                case SECOND: {
                    _switchResult_1 = 1.0E9;
                    break;
                }
                case MINUTE: {
                    _switchResult_1 = 6.0E10;
                    break;
                }
                case HOUR: {
                    _switchResult_1 = 3.6E12;
                    break;
                }
                case DAY: {
                    _switchResult_1 = 8.64E13;
                    break;
                }
            }
        }
        double toTarget = _switchResult_1;
        return Math.round((double)time * toNanoSeconds / toTarget);
    }

    public static String getUnitSymbol(TimeUnit unit) {
        String _switchResult = null;
        if (unit != null) {
            switch (unit) {
                case NANOSECOND: {
                    _switchResult = "ns";
                    break;
                }
                case MICROSECOND: {
                    _switchResult = "\u00b5s";
                    break;
                }
                case MILLISECOND: {
                    _switchResult = "ms";
                    break;
                }
                case SECOND: {
                    _switchResult = "s";
                    break;
                }
                case MINUTE: {
                    _switchResult = "min";
                    break;
                }
                case HOUR: {
                    _switchResult = "h";
                    break;
                }
                case DAY: {
                    _switchResult = "d";
                    break;
                }
            }
        }
        return _switchResult;
    }

    @Pure
    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    @Pure
    public boolean isRunning() {
        return this.running;
    }

    public static enum TimeUnit {
        NANOSECOND,
        MICROSECOND,
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY;

    }
}

