/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.util;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors(value={AccessorType.PUBLIC_GETTER})
public class DirectedGraph<T> {
    private final Set<Node<T>> nodes;
    private final Functions.Function2<? super T, ? super T, ? extends Boolean> contentComparator;

    public DirectedGraph() {
        this(new Functions.Function2<T, T, Boolean>(){

            public Boolean apply(T l, T r) {
                return Objects.equal(l, r);
            }
        });
    }

    public DirectedGraph(Functions.Function2<? super T, ? super T, ? extends Boolean> contentComparator) {
        HashSet<Node<T>> _hashSet = new HashSet<Node<T>>();
        this.nodes = _hashSet;
        this.contentComparator = contentComparator;
    }

    public Node<T> getNode(final T content) {
        Functions.Function1 _function = new Functions.Function1<Node<T>, Boolean>(){

            public Boolean apply(Node<T> node) {
                return (Boolean)DirectedGraph.this.contentComparator.apply(node.content, content);
            }
        };
        return (Node)IterableExtensions.findFirst(this.nodes, (Functions.Function1)_function);
    }

    public Node<T> addNode(T content) {
        Node<T> node = this.getNode(content);
        if (node == null) {
            Node<T> _node = new Node<T>(content, this);
            node = _node;
            this.nodes.add(node);
        }
        return node;
    }

    public Iterable<Node<T>> addNodes(Iterable<T> contents) {
        Functions.Function1 _function = new Functions.Function1<T, Node<T>>(){

            public Node<T> apply(T it) {
                return DirectedGraph.this.addNode(it);
            }
        };
        return IterableExtensions.map(contents, (Functions.Function1)_function);
    }

    public List<Node<T>> addNodes(T ... contents) {
        Functions.Function1 _function = new Functions.Function1<T, Node<T>>(){

            public Node<T> apply(T it) {
                return DirectedGraph.this.addNode(it);
            }
        };
        return ListExtensions.map((List)((List)Conversions.doWrapArray(contents)), (Functions.Function1)_function);
    }

    public boolean contains(final T content) {
        Functions.Function1 _function = new Functions.Function1<Node<T>, Boolean>(){

            public Boolean apply(Node<T> node) {
                return (Boolean)DirectedGraph.this.contentComparator.apply(node.content, content);
            }
        };
        return IterableExtensions.exists(this.nodes, (Functions.Function1)_function);
    }

    public boolean containsAll(T ... contents) {
        Functions.Function1 _function = new Functions.Function1<T, Boolean>(){

            public Boolean apply(T it) {
                return DirectedGraph.this.contains(it);
            }
        };
        return IterableExtensions.forall((Iterable)((Iterable)Conversions.doWrapArray(contents)), (Functions.Function1)_function);
    }

    public List<T> getContents() {
        Functions.Function1 _function = new Functions.Function1<Node<T>, T>(){

            public T apply(Node<T> it) {
                return it.content;
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.map(this.nodes, (Functions.Function1)_function));
    }

    public List<Node<T>> getRoots() {
        Functions.Function1 _function = new Functions.Function1<Node<T>, Boolean>(){

            public Boolean apply(Node<T> it) {
                return it.isRoot();
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(this.nodes, (Functions.Function1)_function));
    }

    public List<Node<T>> getLeaves() {
        Functions.Function1 _function = new Functions.Function1<Node<T>, Boolean>(){

            public Boolean apply(Node<T> it) {
                return it.isLeaf();
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(this.nodes, (Functions.Function1)_function));
    }

    public LinkedList<DirectedGraph<T>> getSubgraphs() {
        LinkedList<Node<T>> queue = new LinkedList<Node<T>>(this.nodes);
        LinkedList<DirectedGraph<T>> subgraphs = new LinkedList<DirectedGraph<T>>();
        while (!queue.isEmpty()) {
            Node<T> node = queue.removeFirst();
            final DirectedGraph<T> subgraph = node.getSubgraph();
            subgraphs.add(subgraph);
            Predicate _function = new Predicate<Node<T>>(){

                @Override
                public boolean test(Node<T> it) {
                    return subgraph.contains(it.content);
                }
            };
            queue.removeIf(_function);
        }
        return subgraphs;
    }

    public List<Node<T>> getTopSortedNodes() throws GraphContainsCyclesException {
        boolean _isEmpty = this.nodes.isEmpty();
        if (_isEmpty) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        boolean _isCyclic = this.isCyclic();
        if (_isCyclic) {
            throw new GraphContainsCyclesException();
        }
        final List<Node<T>> sorted = this.getRoots();
        while (sorted.size() < this.size()) {
            Functions.Function1 _function = new Functions.Function1<Node<T>, Boolean>(){

                public Boolean apply(Node<T> node) {
                    return sorted.contains(node);
                }
            };
            Functions.Function1 _function_1 = new Functions.Function1<Node<T>, Boolean>(){

                public Boolean apply(Node<T> node) {
                    Functions.Function1 _function = new Functions.Function1<Node<T>, Boolean>(){

                        public Boolean apply(Node<T> parent) {
                            return sorted.contains(parent);
                        }
                    };
                    return IterableExtensions.forall(node.parents, (Functions.Function1)_function);
                }
            };
            Consumer _function_2 = new Consumer<Node<T>>(){

                @Override
                public void accept(Node<T> node) {
                    sorted.add(node);
                }
            };
            IterableExtensions.filter((Iterable)IterableExtensions.reject(this.nodes, (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
        }
        return sorted;
    }

    public List<T> getTopSortedContents() throws GraphContainsCyclesException {
        Functions.Function1 _function = new Functions.Function1<Node<T>, T>(){

            public T apply(Node<T> it) {
                return it.content;
            }
        };
        return ListExtensions.map(this.getTopSortedNodes(), (Functions.Function1)_function);
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public boolean isConnected() {
        int _size = this.getSubgraphs().size();
        return _size <= 1;
    }

    public boolean isCyclic() {
        HashSet<Node<T>> visited = new HashSet<Node<T>>();
        Stack<Node<T>> path = new Stack<Node<T>>();
        for (Node<T> node : this.nodes) {
            boolean _isCyclic = this.isCyclic(node, visited, path);
            if (!_isCyclic) continue;
            return true;
        }
        return false;
    }

    private boolean isCyclic(Node<T> node, Set<Node<T>> visited, Stack<Node<T>> path) {
        boolean _contains = path.contains(node);
        if (_contains) {
            return true;
        }
        boolean _add = visited.add(node);
        if (_add) {
            path.push(node);
            for (Node child : node.children) {
                boolean _isCyclic = this.isCyclic(child, visited, path);
                if (!_isCyclic) continue;
                return true;
            }
            path.pop();
            return false;
        }
        return false;
    }

    public boolean isTree() {
        List<Node<T>> roots = this.getRoots();
        final Node root = (Node)IterableExtensions.head(roots);
        return roots.size() == 1 && IterableExtensions.forall(this.nodes, (Functions.Function1)new Functions.Function1<Node<T>, Boolean>(){

            public Boolean apply(Node<T> node) {
                return node.parents.size() == 1 || node == root;
            }
        }) && this.isConnected();
    }

    public boolean isForest() {
        Functions.Function1 _function = new Functions.Function1<DirectedGraph<T>, Boolean>(){

            public Boolean apply(DirectedGraph<T> it) {
                return it.isTree();
            }
        };
        return IterableExtensions.forall(this.getSubgraphs(), (Functions.Function1)_function);
    }

    public String toString() {
        Functions.Function1 _function = new Functions.Function1<T, CharSequence>(){

            public CharSequence apply(T content) {
                return content.toString();
            }
        };
        return this.toString(_function);
    }

    public String toString(final Functions.Function1<? super T, ? extends CharSequence> nameMap) {
        Functions.Function1 _function = new Functions.Function1<Node<T>, String>(){

            public String apply(Node<T> node) {
                return node.toString(nameMap);
            }
        };
        List nodeStrings = IterableExtensions.sort((Iterable)IterableExtensions.map(this.nodes, (Functions.Function1)_function));
        StringConcatenation _builder = new StringConcatenation();
        String _simpleName = this.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(" {");
        Functions.Function1<String, CharSequence> _function_1 = new Functions.Function1<String, CharSequence>(){

            public CharSequence apply(String it) {
                return it;
            }
        };
        String _join = IterableExtensions.join((Iterable)nodeStrings, (CharSequence)"\n\t", (CharSequence)",\n\t", (CharSequence)"\n", (Functions.Function1)_function_1);
        _builder.append(_join);
        _builder.append("}");
        return _builder.toString();
    }

    public DirectedGraph<T> print() {
        InputOutput.println((Object)this.toString());
        return this;
    }

    public DirectedGraph<T> print(Functions.Function1<? super T, ? extends CharSequence> nameMap) {
        InputOutput.println((Object)this.toString(nameMap));
        return this;
    }

    public DirectedGraph<T> printTree() {
        Functions.Function1 _function = new Functions.Function1<T, CharSequence>(){

            public CharSequence apply(T content) {
                return content.toString();
            }
        };
        return this.printTree(_function);
    }

    public DirectedGraph<T> printTree(Functions.Function1<? super T, ? extends CharSequence> nameMap) {
        boolean _not;
        boolean _isForest = this.isForest();
        boolean bl = _not = !_isForest;
        if (_not) {
            throw new GraphIsNotForestException();
        }
        List<Node<T>> _roots = this.getRoots();
        for (Node<T> root : _roots) {
            Stack<Boolean> _stack = new Stack<Boolean>();
            this.printTreeRecursive(root, _stack, nameMap);
        }
        return this;
    }

    private void printTreeRecursive(Node<T> node, Stack<Boolean> stack, Functions.Function1<? super T, ? extends CharSequence> nameMap) {
        boolean isRoot;
        Boolean _xtrycatchfinallyexpression = null;
        try {
            Boolean _pop;
            _xtrycatchfinallyexpression = _pop = stack.pop();
        }
        catch (Throwable _t) {
            if (_t instanceof EmptyStackException) {
                _xtrycatchfinallyexpression = null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        Boolean isLast = _xtrycatchfinallyexpression;
        boolean bl = isRoot = isLast == null;
        if (isRoot) {
            InputOutput.println((Object)((CharSequence)nameMap.apply(node.content)));
        } else {
            StringConcatenation _builder = new StringConcatenation();
            Functions.Function1<Boolean, String> _function = new Functions.Function1<Boolean, String>(){

                public String apply(Boolean it) {
                    String _xifexpression = null;
                    _xifexpression = it != false ? "    " : "\u2502   ";
                    return _xifexpression;
                }
            };
            String _join = IterableExtensions.join((Iterable)ListExtensions.map(stack, (Functions.Function1)_function));
            _builder.append(_join);
            String _xifexpression = null;
            _xifexpression = isLast != false ? "\u2514" : "\u251c";
            _builder.append(_xifexpression);
            _builder.append("\u2500\u25ba ");
            CharSequence _apply = (CharSequence)nameMap.apply(node.content);
            _builder.append((Object)_apply);
            InputOutput.println((Object)_builder.toString());
            stack.push(isLast);
        }
        int _size = node.children.size();
        int lastIndex = _size - 1;
        Iterable _indexed = IterableExtensions.indexed(node.children);
        for (Pair it : _indexed) {
            Integer index = (Integer)it.getKey();
            Node child = (Node)it.getValue();
            stack.push(index == lastIndex);
            this.printTreeRecursive(child, stack, nameMap);
            stack.pop();
        }
    }

    @Pure
    public Set<Node<T>> getNodes() {
        return this.nodes;
    }

    @Pure
    public Functions.Function2<? super T, ? super T, ? extends Boolean> getContentComparator() {
        return this.contentComparator;
    }

    public static class GraphContainsCyclesException
    extends RuntimeException {
        public GraphContainsCyclesException() {
        }

        public GraphContainsCyclesException(String message) {
            super(message);
        }
    }

    public static class GraphIsNotForestException
    extends RuntimeException {
        public GraphIsNotForestException() {
        }

        public GraphIsNotForestException(String message) {
            super(message);
        }
    }

    public static class Node<T> {
        @Accessors(value={AccessorType.PUBLIC_GETTER})
        private final T content;
        @Accessors(value={AccessorType.PUBLIC_GETTER})
        private final DirectedGraph<T> graph;
        private final Set<Node<T>> parents;
        private final Set<Node<T>> children;

        private Node(T content, DirectedGraph<T> graph) {
            this.content = content;
            this.graph = graph;
            HashSet<Node<T>> _hashSet = new HashSet<Node<T>>();
            this.parents = _hashSet;
            HashSet<Node<T>> _hashSet_1 = new HashSet<Node<T>>();
            this.children = _hashSet_1;
        }

        public Node<T> getNode(T content) {
            return this.graph.getNode(content);
        }

        public Node<T> addNode(T content) {
            return this.graph.addNode(content);
        }

        public Iterable<Node<T>> addNodes(Iterable<T> contents) {
            return this.graph.addNodes(contents);
        }

        public List<Node<T>> addNodes(T ... contents) {
            return this.graph.addNodes(contents);
        }

        public List<Node<T>> getParents() {
            return IterableExtensions.toList(this.parents);
        }

        public Node<T> addParent(T parent) {
            Node<T> parentNode = this.graph.addNode(parent);
            this.parents.add(parentNode);
            parentNode.children.add(this);
            return this;
        }

        public Node<T> addParents(Iterable<T> parents) {
            for (T parent : parents) {
                this.addParent(parent);
            }
            return this;
        }

        public Node<T> addParents(T ... parents) {
            T[] TArray = parents;
            int n = parents.length;
            int n2 = 0;
            while (n2 < n) {
                T parent = TArray[n2];
                this.addParent(parent);
                ++n2;
            }
            return this;
        }

        public List<Node<T>> getChildren() {
            return IterableExtensions.toList(this.children);
        }

        public Node<T> addChild(T child) {
            Node<T> childNode = this.graph.addNode(child);
            this.children.add(childNode);
            childNode.parents.add(this);
            return this;
        }

        public Node<T> addChildren(Iterable<T> children) {
            for (T child : children) {
                this.addChild(child);
            }
            return this;
        }

        public Node<T> addChildren(T ... children) {
            T[] TArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                T child = TArray[n2];
                this.addChild(child);
                ++n2;
            }
            return this;
        }

        public List<Node<T>> getAncestorsAndSelf() {
            boolean _not;
            List<Node<T>> ancestorNodes = this.getAncestors();
            boolean _contains = ancestorNodes.contains(this);
            boolean bl = _not = !_contains;
            if (_not) {
                ancestorNodes.add(0, this);
            }
            return ancestorNodes;
        }

        public List<Node<T>> getAncestors() {
            HashSet<Node<T>> ancestorNodes = new HashSet<Node<T>>();
            this.getAncestorsRecursive(ancestorNodes);
            return IterableExtensions.toList(ancestorNodes);
        }

        private void getAncestorsRecursive(Set<Node<T>> ancestorNodes) {
            for (Node<T> parent : this.parents) {
                boolean _add = ancestorNodes.add(parent);
                if (!_add) continue;
                parent.getAncestorsRecursive(ancestorNodes);
            }
        }

        public List<Node<T>> getDescendantsAndSelf() {
            boolean _not;
            List<Node<T>> descendantNodes = this.getDescendants();
            boolean _contains = descendantNodes.contains(this);
            boolean bl = _not = !_contains;
            if (_not) {
                descendantNodes.add(0, this);
            }
            return descendantNodes;
        }

        public List<Node<T>> getDescendants() {
            HashSet<Node<T>> descendantNodes = new HashSet<Node<T>>();
            this.getDescendantsRecursive(descendantNodes);
            return IterableExtensions.toList(descendantNodes);
        }

        private void getDescendantsRecursive(Set<Node<T>> descendantNodes) {
            for (Node<T> child : this.children) {
                boolean _add = descendantNodes.add(child);
                if (!_add) continue;
                child.getDescendantsRecursive(descendantNodes);
            }
        }

        public DirectedGraph<T> getSubgraph() {
            HashSet<Node<T>> nodes = new HashSet<Node<T>>();
            this.getSubgraphRecursive(nodes);
            DirectedGraph<T> subgraph = new DirectedGraph<T>();
            for (Node<T> node : nodes) {
                Functions.Function1 _function = new Functions.Function1<Node<T>, T>(){

                    public T apply(Node<T> it) {
                        return it.content;
                    }
                };
                Functions.Function1 _function_1 = new Functions.Function1<Node<T>, T>(){

                    public T apply(Node<T> it) {
                        return it.content;
                    }
                };
                subgraph.addNode(node.content).addParents(IterableExtensions.map(node.parents, (Functions.Function1)_function)).addChildren(IterableExtensions.map(node.children, (Functions.Function1)_function_1));
            }
            return subgraph;
        }

        private void getSubgraphRecursive(Set<Node<T>> nodes) {
            boolean _add = nodes.add(this);
            if (_add) {
                for (Node<T> parent : this.parents) {
                    parent.getSubgraphRecursive(nodes);
                }
                for (Node<T> child : this.children) {
                    child.getSubgraphRecursive(nodes);
                }
            }
        }

        public boolean isRoot() {
            return this.parents.isEmpty();
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public boolean equals(Object other) {
            boolean _switchResult = false;
            boolean _matched = false;
            if (other instanceof Node) {
                _matched = true;
                _switchResult = this.content.equals(((Node)other).content);
            }
            if (!_matched) {
                _switchResult = false;
            }
            return _switchResult;
        }

        public String toString() {
            Functions.Function1 _function = new Functions.Function1<T, CharSequence>(){

                public CharSequence apply(T content) {
                    return content.toString();
                }
            };
            return this.toString(_function);
        }

        public String toString(final Functions.Function1<? super T, ? extends CharSequence> nameMap) {
            Functions.Function1 _function = new Functions.Function1<Node<T>, String>(){

                public String apply(Node<T> child) {
                    return ((Object)((CharSequence)nameMap.apply(child.content))).toString();
                }
            };
            List childrenStrings = IterableExtensions.sort((Iterable)IterableExtensions.map(this.children, (Functions.Function1)_function));
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _apply = (CharSequence)nameMap.apply(this.content);
            _builder.append((Object)_apply);
            _builder.append(" -> {");
            String _join = IterableExtensions.join((Iterable)childrenStrings, (CharSequence)", ");
            _builder.append(_join);
            _builder.append("}");
            return _builder.toString();
        }

        public Node<T> print() {
            InputOutput.println((Object)this.toString());
            return this;
        }

        public Node<T> print(Functions.Function1<? super T, ? extends CharSequence> nameMap) {
            InputOutput.println((Object)this.toString(nameMap));
            return this;
        }

        @Pure
        public T getContent() {
            return this.content;
        }

        @Pure
        public DirectedGraph<T> getGraph() {
            return this.graph;
        }
    }
}

