/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.fragment;

import de.jabc.cinco.meta.core.pluginregistry.validation.IMetaPluginValidator;
import de.jabc.cinco.meta.core.pluginregistry.validation.ValidationResult;
import de.jabc.cinco.meta.core.utils.CincoUtil;
import de.jabc.cinco.meta.core.utils.PathValidator;
import java.util.Collection;
import mgl.Annotation;
import mgl.Edge;
import mgl.GraphModel;
import mgl.GraphicalModelElement;
import mgl.MGLModel;
import mgl.ModelElement;
import mgl.Node;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import style.EdgeStyle;
import style.NodeStyle;
import style.Style;
import style.Styles;

public class StylesValidator
implements IMetaPluginValidator {
    public ValidationResult<String, EStructuralFeature> checkOnEdit(EObject eObject) {
        ValidationResult<String, EStructuralFeature> ep = null;
        if (eObject instanceof MGLModel) {
            return this.checkMGLModelStylePathAttribute((MGLModel)eObject);
        }
        if (eObject instanceof Node || eObject instanceof Edge) {
            return this.checkStyleAttribute((GraphicalModelElement)eObject);
        }
        if (!(eObject instanceof Annotation)) {
            return null;
        }
        Annotation annotation = (Annotation)eObject;
        ModelElement me = this.getModelElement((Annotation)eObject);
        if (me instanceof GraphModel && annotation.getName().equals("disableHighlight")) {
            ep = this.checkGraphModelDisableHighlight((GraphModel)me, annotation);
        }
        if (annotation.getName().equals("icon")) {
            ep = this.checkIcon(annotation);
        }
        if (me instanceof ModelElement && annotation.getName().equals("disable")) {
            ep = this.checkDisable(me, annotation);
        }
        return ep;
    }

    private ValidationResult<String, EStructuralFeature> checkDisable(ModelElement me, Annotation annotation) {
        ValidationResult<String, EStructuralFeature> result = null;
        if (me instanceof Node) {
            result = this.checkPredefinedValue(CincoUtil.DISABLE_NODE_VALUES, annotation);
        }
        if (me instanceof Edge) {
            result = this.checkPredefinedValue(CincoUtil.DISABLE_EDGE_VALUES, annotation);
        }
        return result;
    }

    private ValidationResult<String, EStructuralFeature> checkPredefinedValue(Collection<String> values, Annotation annotation) {
        for (String s : annotation.getValue()) {
            if (values.contains(s)) continue;
            return ValidationResult.newError((Object)("Invalid value: \"" + s + "\". Possible values are: " + values), (Object)annotation.eClass().getEStructuralFeature(0));
        }
        return null;
    }

    private ValidationResult<String, EStructuralFeature> checkIcon(Annotation annotation) {
        if (annotation.getValue().size() == 0) {
            return ValidationResult.newError((Object)"Please specify an icon by relative or platform path", (Object)annotation.eClass().getEStructuralFeature("value"));
        }
        String path = (String)annotation.getValue().get(0);
        String retval = PathValidator.checkPath((EObject)annotation, (String)path);
        ValidationResult.Error ep = ValidationResult.newError((Object)retval, (Object)annotation.eClass().getEStructuralFeature("value"));
        return retval.isEmpty() ? null : ep;
    }

    private ValidationResult<String, EStructuralFeature> checkStyleAttribute(GraphicalModelElement gme) {
        int providedStyleParametersCount;
        String styleName = gme.getUsedStyle();
        if (!gme.isIsAbstract() && (styleName == null || styleName.isEmpty())) {
            return ValidationResult.newError((Object)"Please provide a style atrribute", (Object)gme.eClass().getEStructuralFeature("usedStyle"));
        }
        Styles styles = this.getStyles(this.getMGLModel((ModelElement)gme));
        if (styles == null) {
            return null;
        }
        RequiredStyleType reqStyleType = null;
        if (gme instanceof Node) {
            reqStyleType = RequiredStyleType.NodeStyle;
        } else if (gme instanceof Edge) {
            reqStyleType = RequiredStyleType.EdgeStyle;
        }
        Style style = null;
        for (Style s : styles.getStyles()) {
            if (!s.getName().equals(styleName)) continue;
            if (reqStyleType == RequiredStyleType.NodeStyle && s instanceof EdgeStyle) {
                return ValidationResult.newError((Object)"Edge style assigned to a node.", (Object)gme.eClass().getEStructuralFeature("usedStyle"));
            }
            if (reqStyleType == RequiredStyleType.EdgeStyle && s instanceof NodeStyle) {
                return ValidationResult.newError((Object)"Node style assigned to an edge.", (Object)gme.eClass().getEStructuralFeature("usedStyle"));
            }
            style = s;
            break;
        }
        if (styleName != null && !styleName.isEmpty() && style == null) {
            return ValidationResult.newError((Object)("Style: " + styleName + " does not exist"), (Object)gme.eClass().getEStructuralFeature("usedStyle"));
        }
        int params = style.getParameterCount();
        if (params > (providedStyleParametersCount = gme.getStyleParameters().size())) {
            return ValidationResult.newError((Object)("Style: " + styleName + " contains text element with " + params + " parameter(s) but you provided: " + providedStyleParametersCount), (Object)gme.eClass().getEStructuralFeature("usedStyle"));
        }
        if (params < providedStyleParametersCount) {
            return ValidationResult.newError((Object)("Style: " + styleName + " contains text element with " + params + " parameter(s) but you provided: " + providedStyleParametersCount), (Object)gme.eClass().getEStructuralFeature("usedStyle"));
        }
        return null;
    }

    private ValidationResult<String, EStructuralFeature> checkMGLModelStylePathAttribute(MGLModel mm) {
        if (mm.getStylePath() != null && mm.getStylePath().length() == 0) {
            return ValidationResult.newError((Object)"Missing path to style file", (Object)mm.eClass().getEStructuralFeature("stylePath"));
        }
        PathValidator.checkPath((EObject)mm, (String)mm.getStylePath());
        Styles styles = this.getStyles(mm);
        if (styles == null) {
            return ValidationResult.newError((Object)("Style file " + mm.getStylePath() + " does not exist"), (Object)mm.eClass().getEStructuralFeature("stylePath"));
        }
        return null;
    }

    private ValidationResult<String, EStructuralFeature> checkGraphModelDisableHighlight(GraphModel me, Annotation annotation) {
        return this.checkPredefinedValue(CincoUtil.DISABLE_HIGHLIGHT_VALUES, annotation);
    }

    private ModelElement getModelElement(Annotation annot) {
        if (annot.getParent() instanceof ModelElement) {
            return (ModelElement)annot.getParent();
        }
        return null;
    }

    private MGLModel getMGLModel(ModelElement me) {
        return (MGLModel)me.eContainer();
    }

    private Styles getStyles(MGLModel mm) {
        String path = mm.getStylePath();
        if (path.length() > 0) {
            Resource res;
            block7: {
                URI uri = URI.createURI((String)path, (boolean)true);
                res = null;
                if (uri.isPlatformResource()) {
                    res = new ResourceSetImpl().getResource(uri, true);
                    break block7;
                }
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(mm.eResource().getURI().toPlatformString(true))).getProject();
                IFile file = p.getFile(path);
                if (file.exists()) {
                    URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true);
                    res = new ResourceSetImpl().getResource(fileURI, true);
                    break block7;
                }
                return null;
            }
            try {
                for (Object o : res.getContents()) {
                    if (!(o instanceof Styles)) continue;
                    return (Styles)o;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private static enum RequiredStyleType {
        EdgeStyle,
        NodeStyle;

    }
}

