/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.fragment;

import de.jabc.cinco.meta.core.pluginregistry.proposalprovider.IMetaPluginAcceptor;
import de.jabc.cinco.meta.core.utils.xtext.ChooseFileTextApplier;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mgl.Annotation;
import mgl.Edge;
import mgl.GraphModel;
import mgl.MGLModel;
import mgl.Node;
import mgl.NodeContainer;
import mgl.Type;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import style.EdgeStyle;
import style.NodeStyle;
import style.Style;
import style.Styles;

public class StyleValueProposalProvider
implements IMetaPluginAcceptor {
    private final String STYLE_ID = "style";
    private final String ICON_ID = "icon";

    public List<String> getAcceptedStrings(Annotation annotation) {
        String annotName = annotation.getName();
        if ("style".equals(annotName) && annotation.getParent() instanceof Type) {
            Type type = (Type)annotation.getParent();
            MGLModel gModel = this.getMGLModel(type);
            try {
                Styles styles = this.getStyles(gModel);
                if (type instanceof Node) {
                    return this.getNodeStyles(styles);
                }
                if (type instanceof Edge) {
                    return this.getEdgeStyles(styles);
                }
                if (type instanceof NodeContainer) {
                    return this.getNodeStyles(styles);
                }
                if (type instanceof GraphModel) {
                    return Collections.emptyList();
                }
            }
            catch (FileNotFoundException fnfe) {
                return Collections.emptyList();
            }
        }
        if ("icon".equals(annotName)) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("Choose file...");
            return ret;
        }
        return Collections.emptyList();
    }

    MGLModel getMGLModel(Type me) {
        return (MGLModel)me.eContainer();
    }

    private List<String> getNodeStyles(Styles styles) {
        ArrayList<String> nodeStyles = new ArrayList<String>();
        for (Style s : styles.getStyles()) {
            if (!(s instanceof NodeStyle)) continue;
            nodeStyles.add(s.getName());
        }
        return nodeStyles;
    }

    private List<String> getEdgeStyles(Styles styles) {
        ArrayList<String> edgeStyles = new ArrayList<String>();
        for (Style s : styles.getStyles()) {
            if (!(s instanceof EdgeStyle)) continue;
            edgeStyles.add(s.getName());
        }
        return edgeStyles;
    }

    private Styles getStyles(MGLModel mglModel) throws FileNotFoundException {
        String stylePath = mglModel.getStylePath();
        if (stylePath != null && !stylePath.isEmpty()) {
            URI uri = URI.createURI((String)stylePath, (boolean)true);
            Resource res = null;
            if (uri.isPlatformResource()) {
                res = new ResourceSetImpl().getResource(uri, true);
            } else {
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(mglModel.eResource().getURI().toPlatformString(true))).getProject();
                IFile file = p.getFile(stylePath);
                URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true);
                res = new ResourceSetImpl().getResource(fileURI, true);
            }
            if (res == null) {
                throw new FileNotFoundException(stylePath);
            }
            Object o = res.getContents().get(0);
            if (o instanceof Styles) {
                return (Styles)o;
            }
            throw new FileNotFoundException(stylePath);
        }
        return null;
    }

    public ConfigurableCompletionProposal.IReplacementTextApplier getTextApplier(Annotation annotation) {
        if ("icon".equals(annotation.getName())) {
            return new ChooseFileTextApplier((EObject)annotation);
        }
        return null;
    }
}

