/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.generator.runtime.registry;

import de.jabc.cinco.meta.plugin.generator.runtime.IGenerator;
import de.jabc.cinco.meta.plugin.generator.runtime.registry.GeneratorDiscription;
import graphmodel.GraphModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ClassUtils;

public class GraphModelGeneratorRegistry<T extends GraphModel> {
    HashMap<String, List<GeneratorDiscription<T>>> generators = new HashMap();
    public static GraphModelGeneratorRegistry<GraphModel> INSTANCE = new GraphModelGeneratorRegistry();

    private GraphModelGeneratorRegistry() {
    }

    public void addGenerator(String graphModelClassName, IGenerator<T> generator, String outlet) {
        List<GeneratorDiscription<T>> _generators = this.generators.get(graphModelClassName);
        if (_generators == null) {
            _generators = new ArrayList<GeneratorDiscription<T>>();
        }
        _generators.add(new GeneratorDiscription<T>(generator, outlet));
        this.generators.put(graphModelClassName, _generators);
    }

    public GeneratorDiscription<T> getGeneratorAt(String graphModelClassName, int i) {
        return this.generators.get(graphModelClassName).get(i);
    }

    public List<GeneratorDiscription<T>> getAllGenerators(String graphModelClassName) {
        return this.generators.get(graphModelClassName);
    }

    public List<GeneratorDiscription<T>> getAllGenerators(Class<?> graphModelClass) {
        List<GeneratorDiscription<T>> list = this.generators.get(graphModelClass.getName().replace("Impl", "").replace(".impl", ""));
        if (list != null && !list.isEmpty()) {
            return list;
        }
        for (Object ntrfc : ClassUtils.getAllInterfaces(graphModelClass)) {
            if (!(ntrfc instanceof Class) || (list = this.getAllGenerators((Class)ntrfc)) == null || list.isEmpty()) continue;
            return list;
        }
        return list;
    }
}

