/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.generator.runtime.handler;

import de.jabc.cinco.meta.core.utils.job.CompoundJob;
import de.jabc.cinco.meta.core.utils.job.JobFactory;
import de.jabc.cinco.meta.plugin.generator.runtime.registry.GeneratorDiscription;
import de.jabc.cinco.meta.plugin.generator.runtime.registry.GraphModelGeneratorRegistry;
import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.GraphModel;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class GraphModelCodeGenerationHandler
extends AbstractHandler {
    private static WorkbenchExtension eapi = new WorkbenchExtension();
    private IEditorPart activeEditor;
    private GraphModel graphModel;
    private GeneratorDiscription<GraphModel> generatorDescription;
    private String fileName;
    private IProject project;
    private IPath outlet;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CompoundJob job = JobFactory.job((String)"Code Generation");
        job.consume(100, "Initializing...").task("Retrieve active editor", () -> this.retrieveActiveEditor(event)).task("Retrieve graph model", this::retrieveGraphModel).task("Retrieve generator", this::retrieveGenerator).cancelIf(this::isGeneratorMissing, "Failed to retrieve generator.\n\nEither this type of model is not associated with a generator or something went seriously wrong. In the latter case, try to restart the application.").task("Initialize outlet", this::initOutlet);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        IStatus result = job.getResult();
        if (result.getSeverity() != 0) {
            return null;
        }
        job = JobFactory.job((String)"Code Generation").label("Generating for model " + this.fileName + " ...");
        this.generatorDescription.getGenerator().collectTasks(this.graphModel, this.outlet, job);
        job.consume(5, "Refreshing workspace...").task("Refresh workspace", this::refreshProject).onFinishedShowMessage("Code generation successful.").schedule();
        return null;
    }

    private void retrieveActiveEditor(ExecutionEvent event) {
        try {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
            this.activeEditor = window.getActivePage().getActiveEditor();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve active editor.", e);
        }
    }

    private void retrieveGraphModel() {
        try {
            this.fileName = eapi.getResource(this.activeEditor).getURI().lastSegment();
            this.graphModel = eapi.getGraphModel(this.activeEditor);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve graph model for editor: " + this.activeEditor, e);
        }
    }

    private void retrieveGenerator() {
        try {
            System.err.println("### model.class: " + this.graphModel.getClass());
            List<GeneratorDiscription<GraphModel>> generatorDescriptions = GraphModelGeneratorRegistry.INSTANCE.getAllGenerators(this.graphModel.getClass());
            if (generatorDescriptions != null && !generatorDescriptions.isEmpty()) {
                this.generatorDescription = generatorDescriptions.get(0);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve generator.", e);
        }
    }

    private boolean isGeneratorMissing() {
        return this.generatorDescription == null || this.generatorDescription.getGenerator() == null;
    }

    private void initOutlet() {
        try {
            this.project = eapi.getProject(this.activeEditor);
            if (this.project == null || !this.project.isOpen()) {
                throw new RuntimeException("The project is closed or does not exist: " + this.project);
            }
            this.outlet = this.project.getLocation().append(this.generatorDescription.getOutlet());
            if (!this.outlet.toFile().exists()) {
                this.outlet.toFile().mkdirs();
                this.project.refreshLocal(2, null);
            } else if (!this.outlet.toFile().isDirectory()) {
                throw new RuntimeException("Outlet exists, but is no directory: " + this.outlet);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception. Failed to initialize the outlet: " + this.outlet, e);
        }
    }

    private void refreshProject() {
        try {
            this.project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

