/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.generator.runtime;

import de.jabc.cinco.meta.plugin.generator.runtime.IGenerator;
import de.jabc.cinco.meta.plugin.generator.runtime.registry.GraphModelGeneratorRegistry;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static final String GENERATOR = "generator";
    private static final String CLASS = "class";
    private static final String GRAPHMODEL = "graphmodel";
    private static final String EXTENSION_POINT_ID = "de.jabc.cinco.meta.plugin.generator.runtime.registry";
    private static BundleContext context;
    private static Activator plugin;

    static {
        plugin = null;
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        IExtension[] extensions;
        context = bundleContext;
        super.start(context);
        plugin = this;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT_ID);
        if (point == null) {
            return;
        }
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.createGenerator(extension);
            ++n2;
        }
    }

    private void createGenerator(IExtension extension) {
        IGenerator generator = null;
        String graphModelClassName = null;
        String outlet = null;
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(GRAPHMODEL)) {
                graphModelClassName = element.getAttribute(CLASS);
            } else if (element.getName().equals(GENERATOR)) {
                String generatorClassName = element.getAttribute(CLASS);
                try {
                    Class cl = Platform.getBundle((String)element.getAttribute("bundle_id")).loadClass(generatorClassName);
                    generator = (IGenerator)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
                    outlet = element.getAttribute("outlet");
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException | InvalidRegistryObjectException e) {
                    throw new IllegalStateException(String.format("Could not load Generator: %s", generatorClassName), e);
                }
                GraphModelGeneratorRegistry.INSTANCE.addGenerator(graphModelClassName, generator, outlet);
            }
            ++n2;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        context = null;
    }

    public static Activator getDefault() {
        return plugin;
    }
}

