/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.templates;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.ge.style.generator.templates.util.APIUtils;
import de.jabc.cinco.meta.core.ui.properties.CincoPropertyView;
import de.jabc.cinco.meta.core.ui.properties.IValuesProposalProvider;
import de.jabc.cinco.meta.core.utils.CincoUtil;
import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.plugin.event.api.util.EventApiExtension;
import de.jabc.cinco.meta.plugin.event.api.util.EventEnum;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mgl.Annotatable;
import mgl.Annotation;
import mgl.Attribute;
import mgl.ContainingElement;
import mgl.Edge;
import mgl.GraphModel;
import mgl.ModelElement;
import mgl.Node;
import mgl.Type;
import mgl.UserDefinedType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PropertyViewTmpl {
    @Extension
    private GeneratorUtils _generatorUtils = GeneratorUtils.getInstance();
    @Extension
    private APIUtils _aPIUtils = new APIUtils();
    @Extension
    private EventApiExtension _eventApiExtension = new EventApiExtension();

    public CharSequence generatePropertyView(final GraphModel gm) {
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        CharSequence _packageName = this._generatorUtils.packageName((Annotatable)gm);
        _builder.append((Object)_packageName);
        _builder.append(".property.view;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.function.Consumer;");
        _builder.newLine();
        _builder.append("import org.eclipse.emf.ecore.EObject;");
        _builder.newLine();
        _builder.append("import org.eclipse.xtext.xbase.lib.Functions.Function3;");
        _builder.newLine();
        _builder.append("import org.eclipse.xtext.xbase.lib.Procedures.Procedure3;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        String _fuName = this._generatorUtils.fuName((ModelElement)gm);
        _builder.append(_fuName);
        _builder.append("PropertyView implements ");
        String _name = IValuesProposalProvider.class.getName();
        _builder.append(_name);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                Annotation _findAnnotationPostSelect = CincoUtil.findAnnotationPostSelect((ModelElement)it);
                return _findAnnotationPostSelect != null;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)MGLUtil.modelElements((GraphModel)gm), (Functions.Function1)_function);
        for (ModelElement me : _filter) {
            _builder.append("\t");
            String postSelectClass = (String)IterableExtensions.head((Iterable)CincoUtil.findAnnotationPostSelect((ModelElement)me).getValue());
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("static Consumer<EObject> postSelect");
            String _fuName_1 = this._generatorUtils.fuName(me);
            _builder.append(_fuName_1, "\t");
            _builder.append(" = (bo) -> {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (bo instanceof ");
            CharSequence _fqBeanName = this._generatorUtils.fqBeanName((EObject)me);
            _builder.append((Object)_fqBeanName, "\t\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("new ");
            _builder.append(postSelectClass, "\t\t\t");
            _builder.append("().postSelect((");
            CharSequence _fqBeanName_1 = this._generatorUtils.fqBeanName((EObject)me);
            _builder.append((Object)_fqBeanName_1, "\t\t\t");
            _builder.append(") bo);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("};");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("static Consumer<EObject> postSelectEvents = (bo) -> {");
        _builder.newLine();
        _builder.append("\t\t");
        Iterable postSelectEventEnabledElements = this._eventApiExtension.getEventEnabledElements(gm, EventEnum.POST_SELECT);
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)postSelectEventEnabledElements);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("\t\t");
            CharSequence _nonInternalElement = this._generatorUtils.toNonInternalElement("bo");
            _builder.append((Object)_nonInternalElement, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            Functions.Function1<ModelElement, CharSequence> _function_1 = new Functions.Function1<ModelElement, CharSequence>(){

                public CharSequence apply(ModelElement me) {
                    return PropertyViewTmpl.this._generatorUtils.instanceofCheck(me, "bo");
                }
            };
            Functions.Function1<ModelElement, CharSequence> _function_2 = new Functions.Function1<ModelElement, CharSequence>(){

                public CharSequence apply(ModelElement me) {
                    StringConcatenation _builder = new StringConcatenation();
                    CharSequence _fqBeanName = PropertyViewTmpl.this._generatorUtils.fqBeanName((EObject)me);
                    _builder.append((Object)_fqBeanName);
                    _builder.append(" element = (");
                    CharSequence _fqBeanName_1 = PropertyViewTmpl.this._generatorUtils.fqBeanName((EObject)me);
                    _builder.append((Object)_fqBeanName_1);
                    _builder.append(") bo;");
                    _builder.newLineIfNotEmpty();
                    _builder.append("if (element.getRootElement() instanceof ");
                    CharSequence _fqCName = PropertyViewTmpl.this._aPIUtils.fqCName(gm);
                    _builder.append((Object)_fqCName);
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _notifyCallJava = EventEnum.POST_SELECT.getNotifyCallJava(me, new String[]{"element"});
                    _builder.append(_notifyCallJava, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("}");
                    _builder.newLine();
                    return _builder.toString();
                }
            };
            CharSequence _ifElseCascade = this._eventApiExtension.ifElseCascade((Iterable)ListExtensions.reverse((List)this._eventApiExtension.sortByInheritance(postSelectEventEnabledElements)), (Functions.Function1)_function_1, (Functions.Function1)_function_2);
            _builder.append((Object)_ifElseCascade, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("static Function3<EObject, String, Object, String> canAttributeChangeEvents = (bo, attrName, value) -> {");
        _builder.newLine();
        _builder.append("\t\t");
        Iterable canAttributeChangeEventEnabledElements = this._eventApiExtension.getEventEnabledElements(gm, EventEnum.CAN_ATTRIBUTE_CHANGE);
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)canAttributeChangeEventEnabledElements);
        if (_isNullOrEmpty_1) {
            _builder.append("\t\t");
            _builder.append("return null;");
            _builder.newLine();
        } else {
            _builder.append("\t\t");
            CharSequence _nonInternalElement_1 = this._generatorUtils.toNonInternalElement("bo");
            _builder.append((Object)_nonInternalElement_1, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            Functions.Function1<ModelElement, CharSequence> _function_3 = new Functions.Function1<ModelElement, CharSequence>(){

                public CharSequence apply(ModelElement me) {
                    return PropertyViewTmpl.this._generatorUtils.instanceofCheck(me, "bo");
                }
            };
            Functions.Function1<ModelElement, CharSequence> _function_4 = new Functions.Function1<ModelElement, CharSequence>(){

                public CharSequence apply(ModelElement me) {
                    StringConcatenation _builder = new StringConcatenation();
                    CharSequence _fqBeanName = PropertyViewTmpl.this._generatorUtils.fqBeanName((EObject)me);
                    _builder.append((Object)_fqBeanName);
                    _builder.append(" element = (");
                    CharSequence _fqBeanName_1 = PropertyViewTmpl.this._generatorUtils.fqBeanName((EObject)me);
                    _builder.append((Object)_fqBeanName_1);
                    _builder.append(") bo;");
                    _builder.newLineIfNotEmpty();
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("canAttributeChange");
                    String _fuName = PropertyViewTmpl.this._generatorUtils.fuName(me);
                    _builder_1.append(_fuName);
                    _builder_1.append("EventResult");
                    String _notifyCallJava = EventEnum.CAN_ATTRIBUTE_CHANGE.getNotifyCallJava(_builder_1.toString(), me, new String[]{"element", "attrName", "value"});
                    _builder.append(_notifyCallJava);
                    _builder.newLineIfNotEmpty();
                    _builder.append("return canAttributeChange");
                    String _fuName_1 = PropertyViewTmpl.this._generatorUtils.fuName(me);
                    _builder.append(_fuName_1);
                    _builder.append("EventResult;");
                    _builder.newLineIfNotEmpty();
                    return _builder.toString();
                }
            };
            Functions.Function0<CharSequence> _function_5 = new Functions.Function0<CharSequence>(){

                public CharSequence apply() {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("return null;");
                    _builder.newLine();
                    return _builder.toString();
                }
            };
            CharSequence _ifElseCascade_1 = this._eventApiExtension.ifElseCascade((Iterable)ListExtensions.reverse((List)this._eventApiExtension.sortByInheritance(canAttributeChangeEventEnabledElements)), (Functions.Function1)_function_3, (Functions.Function1)_function_4, (Functions.Function0)_function_5);
            _builder.append((Object)_ifElseCascade_1, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("static Procedure3<EObject, String, Object> preAttributeChangeEvents = (bo, attrName, value) -> {");
        _builder.newLine();
        _builder.append("\t\t");
        Iterable preAttributeChangeEventEnabledElements = this._eventApiExtension.getEventEnabledElements(gm, EventEnum.PRE_ATTRIBUTE_CHANGE);
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty((Iterable)preAttributeChangeEventEnabledElements);
        boolean bl2 = _not_1 = !_isNullOrEmpty_2;
        if (_not_1) {
            _builder.append("\t\t");
            CharSequence _nonInternalElement_2 = this._generatorUtils.toNonInternalElement("bo");
            _builder.append((Object)_nonInternalElement_2, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            Functions.Function1<ModelElement, CharSequence> _function_6 = new Functions.Function1<ModelElement, CharSequence>(){

                public CharSequence apply(ModelElement me) {
                    return PropertyViewTmpl.this._generatorUtils.instanceofCheck(me, "bo");
                }
            };
            Functions.Function1<ModelElement, CharSequence> _function_7 = new Functions.Function1<ModelElement, CharSequence>(){

                public CharSequence apply(ModelElement me) {
                    StringConcatenation _builder = new StringConcatenation();
                    CharSequence _fqBeanName = PropertyViewTmpl.this._generatorUtils.fqBeanName((EObject)me);
                    _builder.append((Object)_fqBeanName);
                    _builder.append(" element = (");
                    CharSequence _fqBeanName_1 = PropertyViewTmpl.this._generatorUtils.fqBeanName((EObject)me);
                    _builder.append((Object)_fqBeanName_1);
                    _builder.append(") bo;");
                    _builder.newLineIfNotEmpty();
                    String _notifyCallJava = EventEnum.PRE_ATTRIBUTE_CHANGE.getNotifyCallJava(me, new String[]{"element", "attrName", "value"});
                    _builder.append(_notifyCallJava);
                    _builder.newLineIfNotEmpty();
                    return _builder.toString();
                }
            };
            CharSequence _ifElseCascade_2 = this._eventApiExtension.ifElseCascade((Iterable)ListExtensions.reverse((List)this._eventApiExtension.sortByInheritance(preAttributeChangeEventEnabledElements)), (Functions.Function1)_function_6, (Functions.Function1)_function_7);
            _builder.append((Object)_ifElseCascade_2, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("static Consumer<EObject> refreshPossibleValues = (bo) -> new ");
        String _fuName_2 = this._generatorUtils.fuName((ModelElement)gm);
        _builder.append(_fuName_2, "\t");
        _builder.append("PropertyView().refreshValues(bo);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public static void initEStructuralFeatureInformation() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        Functions.Function1<Attribute, Boolean> _function_8 = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                return CincoUtil.isAttributeHidden((Attribute)it);
            }
        };
        Iterable allNonHiddenGraphModelAttributes = IterableExtensions.reject((Iterable)gm.getAttributes(), (Functions.Function1)_function_8);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _name_1 = CincoPropertyView.class.getName();
        _builder.append(_name_1, "\t\t");
        _builder.append(".init_EStructuralFeatures(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        String _beanPackage = this._generatorUtils.beanPackage((Type)gm);
        _builder.append(_beanPackage, "\t\t\t");
        _builder.append(".internal.impl.Internal");
        String _fuName_3 = this._generatorUtils.fuName((ModelElement)gm);
        _builder.append(_fuName_3, "\t\t\t");
        _builder.append("Impl.class");
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)allNonHiddenGraphModelAttributes);
        boolean bl3 = _not_2 = !_isEmpty;
        if (_not_2) {
            _builder.append(",");
        }
        _builder.newLineIfNotEmpty();
        boolean _hasElements = false;
        for (Attribute attr : allNonHiddenGraphModelAttributes) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t\t\t");
            }
            _builder.append("\t\t\t");
            String _beanPackage_1 = this._generatorUtils.beanPackage((Type)gm);
            _builder.append(_beanPackage_1, "\t\t\t");
            _builder.append(".internal.InternalPackage.eINSTANCE.getInternal");
            String _fuName_4 = this._generatorUtils.fuName((ModelElement)gm);
            _builder.append(_fuName_4, "\t\t\t");
            _builder.append("_");
            String _firstUpper = StringExtensions.toFirstUpper((String)attr.getName());
            _builder.append(_firstUpper, "\t\t\t");
            _builder.append("()");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append(");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        Set usableNodes = this._generatorUtils.getUsableNodes((ContainingElement)gm, true);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        Functions.Function1<Node, Set<Node>> _function_9 = new Functions.Function1<Node, Set<Node>>(){

            public Set<Node> apply(Node it) {
                return PropertyViewTmpl.this._generatorUtils.getAllSuperNodes(it);
            }
        };
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)usableNodes, (Functions.Function1)_function_9);
        Set usableNodesAndSuperNodes = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)usableNodes, (Iterable)_flatMap));
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        Set usableEdges = this._generatorUtils.getUsableEdges((ContainingElement)gm);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        Functions.Function1<Edge, Collection<? extends Edge>> _function_10 = new Functions.Function1<Edge, Collection<? extends Edge>>(){

            public Collection<? extends Edge> apply(Edge it) {
                return PropertyViewTmpl.this._generatorUtils.getAllSuperEdges(it);
            }
        };
        Iterable _flatten = Iterables.concat((Iterable)IterableExtensions.map((Iterable)usableEdges, (Functions.Function1)_function_10));
        Set usableEdgesAndSuperEdges = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)usableEdges, (Iterable)_flatten));
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        Set usableUserDefiendTypes = this._generatorUtils.getUsableUserDefinedTypes((ContainingElement)gm, false, true);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        Set usableUserDefiendTypesAndSuperUserDefiendTypes = this._generatorUtils.getUsableUserDefinedTypes((ContainingElement)gm, true, true);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        Iterable _plus = Iterables.concat((Iterable)usableNodes, (Iterable)usableEdges);
        Set usableModelElements = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)_plus, (Iterable)usableUserDefiendTypes));
        _builder.newLineIfNotEmpty();
        Iterable _plus_1 = Iterables.concat((Iterable)usableNodesAndSuperNodes, (Iterable)usableEdgesAndSuperEdges);
        for (Object edge : _plus_1) {
            boolean _not_3;
            _builder.append("\t\t");
            Functions.Function1<Attribute, Boolean> _function_11 = new Functions.Function1<Attribute, Boolean>(){

                public Boolean apply(Attribute it) {
                    return CincoUtil.isAttributeHidden((Attribute)it);
                }
            };
            Iterable allNonHiddenAttributes = IterableExtensions.reject((Iterable)MGLUtil.allAttributes((ModelElement)edge, (boolean)false), (Functions.Function1)_function_11);
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            String _name_2 = CincoPropertyView.class.getName();
            _builder.append(_name_2, "\t\t");
            _builder.append(".init_EStructuralFeatures(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            String _beanPackage_2 = this._generatorUtils.beanPackage((Type)edge);
            _builder.append(_beanPackage_2, "\t\t\t");
            _builder.append(".internal.impl.Internal");
            String _fuName_5 = this._generatorUtils.fuName((ModelElement)edge);
            _builder.append(_fuName_5, "\t\t\t");
            _builder.append("Impl.class");
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)allNonHiddenAttributes);
            boolean bl4 = _not_3 = !_isEmpty_1;
            if (_not_3) {
                _builder.append(",");
            }
            _builder.newLineIfNotEmpty();
            boolean _hasElements_1 = false;
            for (Attribute attr_1 : allNonHiddenAttributes) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t\t\t");
                }
                _builder.append("\t\t");
                _builder.append("\t");
                String _beanPackage_3 = this._generatorUtils.beanPackage((Type)edge);
                _builder.append(_beanPackage_3, "\t\t\t");
                _builder.append(".internal.InternalPackage.eINSTANCE.getInternal");
                String _fuName_6 = this._generatorUtils.fuName((ModelElement)edge);
                _builder.append(_fuName_6, "\t\t\t");
                _builder.append("_");
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)attr_1.getName());
                _builder.append(_firstUpper_1, "\t\t\t");
                _builder.append("()");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append(");");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.newLine();
        for (UserDefinedType udType : usableUserDefiendTypesAndSuperUserDefiendTypes) {
            boolean _not_4;
            _builder.append("\t\t");
            Functions.Function1<Attribute, Boolean> _function_12 = new Functions.Function1<Attribute, Boolean>(){

                public Boolean apply(Attribute it) {
                    return CincoUtil.isAttributeHidden((Attribute)it);
                }
            };
            Iterable allNonHiddenAttributes_1 = IterableExtensions.reject((Iterable)MGLUtil.allAttributes((ModelElement)udType, (boolean)false), (Functions.Function1)_function_12);
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            String _name_3 = CincoPropertyView.class.getName();
            _builder.append(_name_3, "\t\t");
            _builder.append(".init_EStructuralFeatures(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            String _beanPackage_4 = this._generatorUtils.beanPackage((Type)udType);
            _builder.append(_beanPackage_4, "\t\t\t");
            _builder.append(".internal.impl.Internal");
            String _fuName_7 = this._generatorUtils.fuName((ModelElement)udType);
            _builder.append(_fuName_7, "\t\t\t");
            _builder.append("Impl.class");
            boolean _isEmpty_2 = IterableExtensions.isEmpty((Iterable)allNonHiddenAttributes_1);
            boolean bl5 = _not_4 = !_isEmpty_2;
            if (_not_4) {
                _builder.append(",");
            }
            _builder.newLineIfNotEmpty();
            boolean _hasElements_2 = false;
            for (Attribute attr_2 : allNonHiddenAttributes_1) {
                if (!_hasElements_2) {
                    _hasElements_2 = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t\t\t");
                }
                _builder.append("\t\t");
                _builder.append("\t");
                String _beanPackage_5 = this._generatorUtils.beanPackage((Type)udType);
                _builder.append(_beanPackage_5, "\t\t\t");
                _builder.append(".internal.InternalPackage.eINSTANCE.getInternal");
                String _fuName_8 = this._generatorUtils.fuName((ModelElement)udType);
                _builder.append(_fuName_8, "\t\t\t");
                _builder.append("_");
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)attr_2.getName());
                _builder.append(_firstUpper_2, "\t\t\t");
                _builder.append("()");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append(");");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t\t");
        String _name_4 = CincoPropertyView.class.getName();
        _builder.append(_name_4, "\t\t");
        _builder.append(".init_MultiLineAttributes(");
        _builder.newLineIfNotEmpty();
        Functions.Function1<Attribute, Boolean> _function_13 = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                return CincoUtil.isAttributeMultiLine((Attribute)it);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)this._generatorUtils.allModelAttributes(gm), (Functions.Function1)_function_13);
        boolean _hasElements_3 = false;
        for (Attribute attr_3 : _filter_1) {
            if (!_hasElements_3) {
                _hasElements_3 = true;
            } else {
                _builder.appendImmediate((Object)",", "\t\t\t");
            }
            _builder.append("\t\t\t");
            String _beanPackage_6 = this._generatorUtils.beanPackage((Type)gm);
            _builder.append(_beanPackage_6, "\t\t\t");
            _builder.append(".internal.InternalPackage.eINSTANCE.getInternal");
            String _fuName_9 = this._generatorUtils.fuName(attr_3.getModelElement());
            _builder.append(_fuName_9, "\t\t\t");
            _builder.append("_");
            String _firstUpper_3 = StringExtensions.toFirstUpper((String)attr_3.getName());
            _builder.append(_firstUpper_3, "\t\t\t");
            _builder.append("()");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append(");");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        String _name_5 = CincoPropertyView.class.getName();
        _builder.append(_name_5, "\t\t");
        _builder.append(".init_ReadOnlyAttributes(");
        _builder.newLineIfNotEmpty();
        Functions.Function1<ModelElement, Boolean> _function_14 = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                Functions.Function1<Attribute, Boolean> _function = new Functions.Function1<Attribute, Boolean>(){

                    public Boolean apply(Attribute it) {
                        return CincoUtil.isAttributeReadOnly((Attribute)it);
                    }
                };
                return IterableExtensions.exists((Iterable)MGLUtil.allAttributes((ModelElement)it, (boolean)false), (Functions.Function1)_function);
            }
        };
        Iterable _filter_2 = IterableExtensions.filter((Iterable)MGLUtil.modelElements((GraphModel)gm), (Functions.Function1)_function_14);
        boolean _hasElements_4 = false;
        for (ModelElement me_1 : _filter_2) {
            if (!_hasElements_4) {
                _hasElements_4 = true;
            } else {
                _builder.appendImmediate((Object)",", "\t\t\t");
            }
            Functions.Function1<Attribute, Boolean> _function_15 = new Functions.Function1<Attribute, Boolean>(){

                public Boolean apply(Attribute it) {
                    return CincoUtil.isAttributeReadOnly((Attribute)it);
                }
            };
            Iterable _filter_3 = IterableExtensions.filter((Iterable)MGLUtil.allAttributes((ModelElement)me_1, (boolean)false), (Functions.Function1)_function_15);
            boolean _hasElements_5 = false;
            for (Attribute attr_4 : _filter_3) {
                if (!_hasElements_5) {
                    _hasElements_5 = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t\t\t");
                }
                _builder.append("\t\t\t");
                String _beanPackage_7 = this._generatorUtils.beanPackage((Type)gm);
                _builder.append(_beanPackage_7, "\t\t\t");
                _builder.append(".internal.InternalPackage.eINSTANCE.getInternal");
                String _fuName_10 = this._generatorUtils.fuName(me_1);
                _builder.append(_fuName_10, "\t\t\t");
                _builder.append("_");
                String _firstUpper_4 = StringExtensions.toFirstUpper((String)attr_4.getName());
                _builder.append(_firstUpper_4, "\t\t\t");
                _builder.append("()");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t\t");
        _builder.append(");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        String _name_6 = CincoPropertyView.class.getName();
        _builder.append(_name_6, "\t\t");
        _builder.append(".init_FileAttributes(");
        _builder.newLineIfNotEmpty();
        Functions.Function1<Attribute, Boolean> _function_16 = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                return CincoUtil.isAttributeFile((Attribute)it);
            }
        };
        Iterable _filter_4 = IterableExtensions.filter((Iterable)this._generatorUtils.allModelAttributes(gm), (Functions.Function1)_function_16);
        boolean _hasElements_6 = false;
        for (Attribute attr_5 : _filter_4) {
            if (!_hasElements_6) {
                _hasElements_6 = true;
            } else {
                _builder.appendImmediate((Object)",", "\t\t\t");
            }
            _builder.append("\t\t\t");
            String _beanPackage_8 = this._generatorUtils.beanPackage((Type)attr_5.getModelElement());
            _builder.append(_beanPackage_8, "\t\t\t");
            _builder.append(".internal.InternalPackage.eINSTANCE.getInternal");
            String _fuName_11 = this._generatorUtils.fuName(attr_5.getModelElement());
            _builder.append(_fuName_11, "\t\t\t");
            _builder.append("_");
            String _firstUpper_5 = StringExtensions.toFirstUpper((String)attr_5.getName());
            _builder.append(_firstUpper_5, "\t\t\t");
            _builder.append("()");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append(");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        Functions.Function1<Attribute, Boolean> _function_17 = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                return CincoUtil.isAttributeFile((Attribute)it);
            }
        };
        boolean _exists = IterableExtensions.exists((Iterable)this._generatorUtils.allModelAttributes(gm), (Functions.Function1)_function_17);
        if (_exists) {
            Functions.Function1<Attribute, Boolean> _function_18 = new Functions.Function1<Attribute, Boolean>(){

                public Boolean apply(Attribute it) {
                    return CincoUtil.isAttributeFile((Attribute)it);
                }
            };
            Iterable _filter_5 = IterableExtensions.filter((Iterable)this._generatorUtils.allModelAttributes(gm), (Functions.Function1)_function_18);
            for (Attribute attr_6 : _filter_5) {
                _builder.append("\t\t");
                String _name_7 = CincoPropertyView.class.getName();
                _builder.append(_name_7, "\t\t");
                _builder.append(".init_FileAttributesExtensionFilters(");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                String _beanPackage_9 = this._generatorUtils.beanPackage((Type)gm);
                _builder.append(_beanPackage_9, "\t\t\t");
                _builder.append(".internal.InternalPackage.eINSTANCE.getInternal");
                String _fuName_12 = this._generatorUtils.fuName(attr_6.getModelElement());
                _builder.append(_fuName_12, "\t\t\t");
                _builder.append("_");
                String _firstUpper_6 = StringExtensions.toFirstUpper((String)attr_6.getName());
                _builder.append(_firstUpper_6, "\t\t\t");
                _builder.append("()");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                Functions.Function1<Annotation, Boolean> _function_19 = new Functions.Function1<Annotation, Boolean>(){

                    public Boolean apply(Annotation it) {
                        String _name = it.getName();
                        return Objects.equal((Object)_name, (Object)"file");
                    }
                };
                Functions.Function1<Annotation, EList<String>> _function_20 = new Functions.Function1<Annotation, EList<String>>(){

                    public EList<String> apply(Annotation it) {
                        return it.getValue();
                    }
                };
                Functions.Function1<String, CharSequence> _function_21 = new Functions.Function1<String, CharSequence>(){

                    public CharSequence apply(String ext) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append(",\"");
                        _builder.append(ext);
                        _builder.append("\"");
                        return _builder.toString();
                    }
                };
                String _join = IterableExtensions.join((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filter((Iterable)attr_6.getAnnotations(), (Functions.Function1)_function_19), (Functions.Function1)_function_20), (CharSequence)" ", (Functions.Function1)_function_21);
                _builder.append(_join, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append(");");
                _builder.newLine();
            }
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        String _name_8 = CincoPropertyView.class.getName();
        _builder.append(_name_8, "\t\t");
        _builder.append(".init_ColorAttributes(");
        _builder.newLineIfNotEmpty();
        Functions.Function1<Attribute, Boolean> _function_22 = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                return CincoUtil.isAttributeColor((Attribute)it);
            }
        };
        Iterable _filter_6 = IterableExtensions.filter((Iterable)this._generatorUtils.allModelAttributes(gm), (Functions.Function1)_function_22);
        boolean _hasElements_7 = false;
        for (Attribute attr_7 : _filter_6) {
            if (!_hasElements_7) {
                _hasElements_7 = true;
            } else {
                _builder.appendImmediate((Object)",", "\t\t\t");
            }
            _builder.append("\t\t\t");
            String _beanPackage_10 = this._generatorUtils.beanPackage((Type)attr_7.getModelElement());
            _builder.append(_beanPackage_10, "\t\t\t");
            _builder.append(".internal.InternalPackage.eINSTANCE.getInternal");
            String _fuName_13 = this._generatorUtils.fuName(attr_7.getModelElement());
            _builder.append(_fuName_13, "\t\t\t");
            _builder.append("_");
            String _firstUpper_7 = StringExtensions.toFirstUpper((String)attr_7.getName());
            _builder.append(_firstUpper_7, "\t\t\t");
            _builder.append("()");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append(");");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1<Attribute, Boolean> _function_23 = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                return CincoUtil.isAttributeColor((Attribute)it);
            }
        };
        boolean _exists_1 = IterableExtensions.exists((Iterable)this._generatorUtils.allModelAttributes(gm), (Functions.Function1)_function_23);
        if (_exists_1) {
            Functions.Function1<Attribute, Boolean> _function_24 = new Functions.Function1<Attribute, Boolean>(){

                public Boolean apply(Attribute it) {
                    return CincoUtil.isAttributeColor((Attribute)it);
                }
            };
            Iterator _filter_7 = IterableExtensions.filter((Iterable)this._generatorUtils.allModelAttributes(gm), (Functions.Function1)_function_24);
            Iterator _beanPackage_10 = _filter_7.iterator();
            while (_beanPackage_10.hasNext()) {
                Attribute attr_8 = (Attribute)_beanPackage_10.next();
                _builder.append("\t\t");
                String _name_9 = CincoPropertyView.class.getName();
                _builder.append(_name_9, "\t\t");
                _builder.append(".init_ColorAttributesParameter(");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                String _beanPackage_11 = this._generatorUtils.beanPackage((Type)gm);
                _builder.append(_beanPackage_11, "\t\t\t");
                _builder.append(".internal.InternalPackage.eINSTANCE.getInternal");
                String _fuName_14 = this._generatorUtils.fuName(attr_8.getModelElement());
                _builder.append(_fuName_14, "\t\t\t");
                _builder.append("_");
                String _firstUpper_8 = StringExtensions.toFirstUpper((String)attr_8.getName());
                _builder.append(_firstUpper_8, "\t\t\t");
                _builder.append("(),");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("\"");
                Functions.Function1<Annotation, Boolean> _function_25 = new Functions.Function1<Annotation, Boolean>(){

                    public Boolean apply(Annotation it) {
                        String _name = it.getName();
                        return Objects.equal((Object)_name, (Object)"color");
                    }
                };
                Functions.Function1<Annotation, EList<String>> _function_26 = new Functions.Function1<Annotation, EList<String>>(){

                    public EList<String> apply(Annotation it) {
                        return it.getValue();
                    }
                };
                String _head = (String)IterableExtensions.head((Iterable)((Iterable)IterableExtensions.head((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)attr_8.getAnnotations(), (Functions.Function1)_function_25), (Functions.Function1)_function_26))));
                _builder.append(_head, "\t\t\t");
                _builder.append("\"");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append(");");
                _builder.newLine();
            }
        }
        _builder.append("\t\t");
        _builder.newLine();
        Functions.Function1<UserDefinedType, Boolean> _function_27 = new Functions.Function1<UserDefinedType, Boolean>(){

            public Boolean apply(UserDefinedType it) {
                return CincoUtil.hasLabel((UserDefinedType)it);
            }
        };
        Iterable _filter_8 = IterableExtensions.filter((Iterable)usableUserDefiendTypes, (Functions.Function1)_function_27);
        for (UserDefinedType udType_1 : _filter_8) {
            _builder.append("\t\t");
            String _name_10 = CincoPropertyView.class.getName();
            _builder.append(_name_10, "\t\t");
            _builder.append(".init_TypeLabel(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            String _beanPackage_12 = this._generatorUtils.beanPackage((Type)gm);
            _builder.append(_beanPackage_12, "\t\t\t");
            _builder.append(".internal.impl.Internal");
            String _fuName_15 = this._generatorUtils.fuName((ModelElement)udType_1);
            _builder.append(_fuName_15, "\t\t\t");
            _builder.append("Impl.class,");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            String _beanPackage_13 = this._generatorUtils.beanPackage((Type)gm);
            _builder.append(_beanPackage_13, "\t\t\t");
            _builder.append(".internal.InternalPackage.eINSTANCE.getInternal");
            String _fuName_16 = this._generatorUtils.fuName((ModelElement)udType_1);
            _builder.append(_fuName_16, "\t\t\t");
            _builder.append("_");
            Functions.Function1<Annotation, Boolean> _function_28 = new Functions.Function1<Annotation, Boolean>(){

                public Boolean apply(Annotation it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)"label");
                }
            };
            String _firstUpper_9 = StringExtensions.toFirstUpper((String)((String)IterableExtensions.head((Iterable)((Annotation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)udType_1.getAnnotations(), (Functions.Function1)_function_28))).getValue())));
            _builder.append(_firstUpper_9, "\t\t\t");
            _builder.append("()");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append(");");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.newLine();
        Functions.Function1<Attribute, Boolean> _function_29 = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                return CincoUtil.isGrammarAttribute((Attribute)it);
            }
        };
        Iterable _filter_9 = IterableExtensions.filter((Iterable)this._generatorUtils.allModelAttributes(gm), (Functions.Function1)_function_29);
        for (Attribute attr_9 : _filter_9) {
            Set _allSubclasses = MGLUtil.getAllSubclasses((ModelElement)attr_9.getModelElement());
            ModelElement _modelElement = attr_9.getModelElement();
            Iterable _plus_2 = Iterables.concat((Iterable)_allSubclasses, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ModelElement[]{_modelElement})));
            for (ModelElement subType : _plus_2) {
                _builder.append("\t\t");
                String _name_11 = CincoPropertyView.class.getName();
                _builder.append(_name_11, "\t\t");
                _builder.append(".init_GrammarEditor(");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                String _beanPackage_14 = this._generatorUtils.beanPackage((Type)gm);
                _builder.append(_beanPackage_14, "\t\t\t");
                _builder.append(".internal.InternalPackage.eINSTANCE.getInternal");
                String _fuName_17 = this._generatorUtils.fuName(subType);
                _builder.append(_fuName_17, "\t\t\t");
                _builder.append("_");
                String _firstUpper_10 = StringExtensions.toFirstUpper((String)attr_9.getName());
                _builder.append(_firstUpper_10, "\t\t\t");
                _builder.append("(),");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                Functions.Function1<Annotation, Boolean> _function_30 = new Functions.Function1<Annotation, Boolean>(){

                    public Boolean apply(Annotation it) {
                        String _name = it.getName();
                        return Objects.equal((Object)_name, (Object)"grammar");
                    }
                };
                String _get = (String)((Annotation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)attr_9.getAnnotations(), (Functions.Function1)_function_30))).getValue().get(1);
                _builder.append(_get, "\t\t\t");
                _builder.append(".getInstance().getInjector(\"");
                Functions.Function1<Annotation, Boolean> _function_31 = new Functions.Function1<Annotation, Boolean>(){

                    public Boolean apply(Annotation it) {
                        String _name = it.getName();
                        return Objects.equal((Object)_name, (Object)"grammar");
                    }
                };
                String _head_1 = (String)IterableExtensions.head((Iterable)((Annotation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)attr_9.getAnnotations(), (Functions.Function1)_function_31))).getValue());
                _builder.append(_head_1, "\t\t\t");
                _builder.append("\")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append(");");
                _builder.newLine();
            }
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        String _name_12 = CincoPropertyView.class.getName();
        _builder.append(_name_12, "\t\t");
        _builder.append(".init_DisableCreate(");
        _builder.newLineIfNotEmpty();
        Functions.Function1<ModelElement, Boolean> _function_32 = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                return CincoUtil.hasAnnotationDisableCreate((ModelElement)it);
            }
        };
        Iterable _filter_10 = IterableExtensions.filter((Iterable)usableModelElements, (Functions.Function1)_function_32);
        boolean _hasElements_8 = false;
        for (ModelElement me_2 : _filter_10) {
            if (!_hasElements_8) {
                _hasElements_8 = true;
            } else {
                _builder.appendImmediate((Object)",", "\t\t\t");
            }
            _builder.append("\t\t\t");
            _builder.append("// The use of non-internal EClasses is intentional.");
            _builder.newLine();
            _builder.append("\t\t\t");
            Object _xifexpression = null;
            String _fuName_18 = this._generatorUtils.fuName(me_2);
            boolean _equals = Objects.equal((Object)_fuName_18, (Object)"Name");
            if (_equals) {
                _xifexpression = "_";
            }
            String underscore = _xifexpression;
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            String _beanPackage_15 = this._generatorUtils.beanPackage((Type)me_2);
            _builder.append(_beanPackage_15, "\t\t\t");
            _builder.append(".");
            String _firstUpper_11 = StringExtensions.toFirstUpper((String)this._generatorUtils.getFileName(this._eventApiExtension.getModel((ModelElement)gm)).toLowerCase());
            _builder.append(_firstUpper_11, "\t\t\t");
            _builder.append("Package.eINSTANCE.get");
            String _fuName_19 = this._generatorUtils.fuName(me_2);
            _builder.append(_fuName_19, "\t\t\t");
            _builder.append(underscore, "\t\t\t");
            _builder.append("()");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append(");");
        _builder.newLine();
        _builder.append("\t\t");
        String _name_13 = CincoPropertyView.class.getName();
        _builder.append(_name_13, "\t\t");
        _builder.append(".init_DisableDelete(");
        _builder.newLineIfNotEmpty();
        Functions.Function1<ModelElement, Boolean> _function_33 = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                return CincoUtil.hasAnnotationDisableDelete((ModelElement)it);
            }
        };
        Iterable _filter_11 = IterableExtensions.filter((Iterable)usableModelElements, (Functions.Function1)_function_33);
        boolean _hasElements_9 = false;
        for (Object me_3 : _filter_11) {
            if (!_hasElements_9) {
                _hasElements_9 = true;
            } else {
                _builder.appendImmediate((Object)",", "\t\t\t");
            }
            _builder.append("\t\t\t");
            _builder.append("// The use of internal EClasses is intentional.");
            _builder.newLine();
            _builder.append("\t\t\t");
            String _beanPackage_16 = this._generatorUtils.beanPackage((Type)me_3);
            _builder.append(_beanPackage_16, "\t\t\t");
            _builder.append(".internal.InternalPackage.eINSTANCE.getInternal");
            String _fuName_20 = this._generatorUtils.fuName((ModelElement)me_3);
            _builder.append(_fuName_20, "\t\t\t");
            _builder.append("()");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append(");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        Functions.Function1<ModelElement, Boolean> _function_34 = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                Annotation _findAnnotationPostSelect = CincoUtil.findAnnotationPostSelect((ModelElement)it);
                return _findAnnotationPostSelect == null;
            }
        };
        Iterable _reject = IterableExtensions.reject((Iterable)MGLUtil.modelElements((GraphModel)gm), (Functions.Function1)_function_34);
        for (ModelElement me_4 : _reject) {
            _builder.append("\t\t");
            String _name_14 = CincoPropertyView.class.getName();
            _builder.append(_name_14, "\t\t");
            _builder.append(".postSelects.add(postSelect");
            String _fuName_21 = this._generatorUtils.fuName(me_4);
            _builder.append(_fuName_21, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        String _name_15 = CincoPropertyView.class.getName();
        _builder.append(_name_15, "\t\t");
        _builder.append(".postSelects.add(postSelectEvents);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _name_16 = CincoPropertyView.class.getName();
        _builder.append(_name_16, "\t\t");
        _builder.append(".canAttributeChange = canAttributeChangeEvents;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _name_17 = CincoPropertyView.class.getName();
        _builder.append(_name_17, "\t\t");
        _builder.append(".preAttributeChange = preAttributeChangeEvents;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        String _name_18 = CincoPropertyView.class.getName();
        _builder.append(_name_18, "\t\t");
        _builder.append(".possibleValueRefreshs.add(refreshPossibleValues);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        String _name_19 = CincoPropertyView.class.getName();
        _builder.append(_name_19, "\t\t");
        _builder.append(".assertSelectionListener();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void refreshValues(");
        String _name_20 = EObject.class.getName();
        _builder.append(_name_20, "\t");
        _builder.append(" bo) {");
        _builder.newLineIfNotEmpty();
        Functions.Function1<Attribute, Boolean> _function_35 = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute it) {
                return CincoUtil.isAttributePossibleValuesProvider((Attribute)it);
            }
        };
        Iterable _filter_12 = IterableExtensions.filter((Iterable)this._generatorUtils.allModelAttributes(gm), (Functions.Function1)_function_35);
        for (Attribute attr_10 : _filter_12) {
            Set _allSubclasses_1 = MGLUtil.getAllSubclasses((ModelElement)attr_10.getModelElement());
            ModelElement _modelElement_1 = attr_10.getModelElement();
            Iterable _plus_3 = Iterables.concat((Iterable)_allSubclasses_1, Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new ModelElement[]{_modelElement_1})));
            for (ModelElement element : _plus_3) {
                _builder.append("\t\t");
                _builder.append("if (bo instanceof ");
                CharSequence _fqBeanName_2 = this._generatorUtils.fqBeanName((EObject)attr_10.getModelElement());
                _builder.append((Object)_fqBeanName_2, "\t\t");
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                String _name_21 = CincoPropertyView.class.getName();
                _builder.append(_name_21, "\t\t\t");
                _builder.append(".refreshPossibleValues(");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t\t");
                String _beanPackage_17 = this._generatorUtils.beanPackage((Type)gm);
                _builder.append(_beanPackage_17, "\t\t\t\t");
                _builder.append(".internal.InternalPackage.eINSTANCE.getInternal");
                String _name_22 = attr_10.getModelElement().getName();
                _builder.append(_name_22, "\t\t\t\t");
                _builder.append("_");
                String _firstUpper_12 = StringExtensions.toFirstUpper((String)attr_10.getName());
                _builder.append(_firstUpper_12, "\t\t\t\t");
                _builder.append("(),");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t\t");
                _builder.append("new ");
                String _possibleValuesProviderClass = CincoUtil.getPossibleValuesProviderClass((Attribute)attr_10);
                _builder.append(_possibleValuesProviderClass, "\t\t\t\t");
                _builder.append("().getPossibleValues((");
                CharSequence _fqBeanName_3 = this._generatorUtils.fqBeanName((EObject)attr_10.getModelElement());
                _builder.append((Object)_fqBeanName_3, "\t\t\t\t");
                _builder.append(") bo)");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append(");");
                _builder.newLine();
            }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

