/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.templates;

import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import java.util.ArrayList;
import java.util.List;
import mgl.Annotatable;
import mgl.GraphModel;
import mgl.MGLModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PluginXMLTmpl {
    @Extension
    private GeneratorUtils _generatorUtils = GeneratorUtils.getInstance();
    private MGLModel mgl;
    private String mglName;
    private String pkgName;
    private String nsUri;

    public List<CharSequence> generatePluginXML(MGLModel mgl) {
        this.mgl = mgl;
        this.mglName = this._generatorUtils.getFileName(mgl);
        this.pkgName = this._generatorUtils.packageName((Annotatable)mgl).toString();
        this.nsUri = MGLUtil.nsURI((Annotatable)mgl);
        return this.extensions();
    }

    public List<CharSequence> extensions() {
        ArrayList<CharSequence> exts = new ArrayList<CharSequence>();
        CollectionExtensions.addAll(exts, (Object[])new CharSequence[]{this.diagramTypeProviders(), this.diagramTypes(), this.editors(), this.imageProvider(), this.wizards(), this.contentTypes(), this.navigatorContent(), this.referenceRegistry(), this.contentParser(), this.factoryOverride(), this.resourceContributor()});
        return exts;
    }

    public CharSequence getCode() {
        StringConcatenation _builder = new StringConcatenation();
        String _diagramTypeProviders = this.diagramTypeProviders();
        _builder.append(_diagramTypeProviders);
        _builder.newLineIfNotEmpty();
        String _diagramTypes = this.diagramTypes();
        _builder.append(_diagramTypes);
        _builder.newLineIfNotEmpty();
        String _editors = this.editors();
        _builder.append(_editors);
        _builder.newLineIfNotEmpty();
        CharSequence _imageProvider = this.imageProvider();
        _builder.append((Object)_imageProvider);
        _builder.newLineIfNotEmpty();
        String _wizards = this.wizards();
        _builder.append(_wizards);
        _builder.newLineIfNotEmpty();
        String _contentTypes = this.contentTypes();
        _builder.append(_contentTypes);
        _builder.newLineIfNotEmpty();
        String _navigatorContent = this.navigatorContent();
        _builder.append(_navigatorContent);
        _builder.newLineIfNotEmpty();
        String _referenceRegistry = this.referenceRegistry();
        _builder.append(_referenceRegistry);
        _builder.newLineIfNotEmpty();
        CharSequence _perspectives = this.perspectives();
        _builder.append((Object)_perspectives);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public String diagramTypeProviders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<extension");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("point=\"org.eclipse.graphiti.ui.diagramTypeProviders\">");
        _builder.newLine();
        String result = _builder.toString();
        Functions.Function1<GraphModel, Boolean> _function = new Functions.Function1<GraphModel, Boolean>(){

            public Boolean apply(GraphModel it) {
                boolean _isIsAbstract = it.isIsAbstract();
                return !_isIsAbstract;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)this.mgl.getGraphModels(), (Functions.Function1)_function);
        for (GraphModel gm : _filter) {
            String _result = result;
            CharSequence _diagramTypeProviders = this.diagramTypeProviders(this._generatorUtils.packageName((Annotatable)gm).toString(), gm.getName());
            result = String.valueOf(_result) + _diagramTypeProviders;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("</extension>");
        return String.valueOf(result) + _builder_1;
    }

    public CharSequence diagramTypeProviders(String pkgName, String gmName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<diagramTypeProvider");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("class=\"");
        _builder.append(pkgName, "\t");
        _builder.append(".");
        _builder.append(gmName, "\t");
        _builder.append("DiagramTypeProvider\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("description=\"This is the generated editor for the ");
        _builder.append(gmName, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("id=\"");
        _builder.append(pkgName, "\t");
        _builder.append(".");
        _builder.append(gmName, "\t");
        _builder.append("DiagramTypeProvider\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("name=\".");
        _builder.append(gmName, "\t");
        _builder.append(" Diagram Editor\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<diagramType");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("id=\"");
        _builder.append(pkgName, "\t\t");
        _builder.append(".");
        _builder.append(gmName, "\t\t");
        _builder.append("DiagramType\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("</diagramType>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<imageProvider");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("id=\"");
        CharSequence _packageName = this._generatorUtils.packageName((Annotatable)this.mgl);
        _builder.append((Object)_packageName, "\t\t");
        _builder.append(".");
        _builder.append(this.mglName, "\t\t");
        _builder.append("ImageProvider\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("</imageProvider>");
        _builder.newLine();
        _builder.append("</diagramTypeProvider>");
        _builder.newLine();
        return _builder;
    }

    public String diagramTypes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<extension ");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("point=\"org.eclipse.graphiti.ui.diagramTypes\">");
        _builder.newLine();
        String result = _builder.toString();
        Functions.Function1<GraphModel, Boolean> _function = new Functions.Function1<GraphModel, Boolean>(){

            public Boolean apply(GraphModel it) {
                boolean _isIsAbstract = it.isIsAbstract();
                return !_isIsAbstract;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)this.mgl.getGraphModels(), (Functions.Function1)_function);
        for (GraphModel gm : _filter) {
            String _result = result;
            CharSequence _diagramTypes = this.diagramTypes(this._generatorUtils.packageName((Annotatable)gm).toString(), gm.getName());
            result = String.valueOf(_result) + _diagramTypes;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("</extension>");
        return String.valueOf(result) + _builder_1;
    }

    public CharSequence diagramTypes(String pkgName, String gmName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<!--@CincoGen ");
        _builder.append(gmName, "\t");
        _builder.append("-->");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("<diagramType");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("description=\"This is the generated diagram Type for ");
        _builder.append(gmName, "\t\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("id=\"");
        _builder.append(pkgName, "\t\t\t");
        _builder.append(".");
        _builder.append(gmName, "\t\t\t");
        _builder.append("DiagramType\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("name=\"");
        _builder.append(gmName, "\t\t\t");
        _builder.append(" Graphiti Diagram Type\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("type=\"");
        _builder.append(gmName, "\t\t\t");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("</diagramType>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence imageProvider() {
        return this.imageProvider(this.pkgName, this.mglName);
    }

    public CharSequence imageProvider(String pkgName, String gmName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<extension");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("point=\"org.eclipse.graphiti.ui.imageProviders\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<!--@CincoGen ");
        _builder.append(gmName, "\t");
        _builder.append("-->");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<imageProvider");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("class=\"");
        _builder.append(pkgName, "\t\t");
        _builder.append(".");
        _builder.append(gmName, "\t\t");
        _builder.append("ImageProvider\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("id=\"");
        _builder.append(pkgName, "\t\t");
        _builder.append(".");
        _builder.append(gmName, "\t\t");
        _builder.append("ImageProvider\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("</imageProvider>");
        _builder.newLine();
        _builder.append("</extension>");
        _builder.newLine();
        return _builder;
    }

    public String wizards() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<extension");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("point=\"org.eclipse.ui.newWizards\">");
        _builder.newLine();
        String result = _builder.toString();
        Functions.Function1<GraphModel, Boolean> _function = new Functions.Function1<GraphModel, Boolean>(){

            public Boolean apply(GraphModel it) {
                boolean _isIsAbstract = it.isIsAbstract();
                return !_isIsAbstract;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)this.mgl.getGraphModels(), (Functions.Function1)_function);
        for (GraphModel gm : _filter) {
            String _result = result;
            String _elvis = null;
            String _wizardClass = this._generatorUtils.getWizardClass(gm);
            if (_wizardClass != null) {
                _elvis = _wizardClass;
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _string = this._generatorUtils.packageName((Annotatable)gm).toString();
                _builder_1.append(_string);
                _builder_1.append(".wizard.");
                String _name = gm.getName();
                _builder_1.append(_name);
                _builder_1.append("DiagramWizard");
                _elvis = _builder_1.toString();
            }
            String _string_1 = this._generatorUtils.packageName((Annotatable)gm).toString();
            String _name_1 = gm.getName();
            String _iconPath = gm.getIconPath();
            String _elvis_1 = null;
            String _wizardLabel = this._generatorUtils.getWizardLabel(gm);
            if (_wizardLabel != null) {
                _elvis_1 = _wizardLabel;
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("New ");
                String _name_2 = gm.getName();
                _builder_2.append(_name_2);
                _elvis_1 = _builder_2.toString();
            }
            CharSequence _wizard = this.wizard(_elvis, _string_1, _name_1, _iconPath, _elvis_1);
            result = String.valueOf(_result) + _wizard;
        }
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("</extension>");
        return String.valueOf(result) + _builder_3;
    }

    public CharSequence wizard(String className, String pkgName, String gmName, String icon, String name) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<!--@CincoGen ");
        _builder.append(gmName);
        _builder.append("-->");
        _builder.newLineIfNotEmpty();
        _builder.append("<wizard");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("category=\"de.jabc.cinco.meta.core.wizards.category.cinco\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("class=\"");
        _builder.append(className, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)icon);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("\t");
            _builder.append("icon=\"");
            _builder.append(icon, "\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("id=\"");
        _builder.append(pkgName, "\t");
        _builder.append(".wizard.");
        String _lowerCase = gmName.toLowerCase();
        _builder.append(_lowerCase, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("name=\"");
        _builder.append(name, "\t");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("</wizard>");
        _builder.newLine();
        return _builder;
    }

    public String editors() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<extension");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("point=\"org.eclipse.ui.editors\">");
        _builder.newLine();
        String result = _builder.toString();
        Functions.Function1<GraphModel, Boolean> _function = new Functions.Function1<GraphModel, Boolean>(){

            public Boolean apply(GraphModel it) {
                boolean _isIsAbstract = it.isIsAbstract();
                return !_isIsAbstract;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)this.mgl.getGraphModels(), (Functions.Function1)_function);
        for (GraphModel gm : _filter) {
            String _result = result;
            CharSequence _editors = this.editors(this._generatorUtils.packageName((Annotatable)gm).toString(), gm.getName(), gm.getIconPath());
            result = String.valueOf(_result) + _editors;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("</extension>");
        return String.valueOf(result) + _builder_1;
    }

    public CharSequence editors(String pkgName, String gmName, String icon) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<!--@CincoGen ");
        _builder.append(gmName);
        _builder.append("-->");
        _builder.newLineIfNotEmpty();
        _builder.append("<editor");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("class=\"");
        _builder.append(pkgName, "\t");
        _builder.append(".");
        _builder.append(gmName, "\t");
        _builder.append("DiagramEditor\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("contributorClass=\"org.eclipse.graphiti.ui.editor.DiagramEditorActionBarContributor\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("default=\"false\"");
        _builder.newLine();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)icon);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("\t");
            _builder.append("icon=\"");
            _builder.append(icon, "\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("id=\"");
        _builder.append(pkgName, "\t");
        _builder.append(".");
        _builder.append(gmName, "\t");
        _builder.append("Editor\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("matchingStrategy=\"org.eclipse.graphiti.ui.editor.DiagramEditorMatchingStrategy\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("name=\"");
        _builder.append(gmName, "\t");
        _builder.append(" Editor\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<contentTypeBinding");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("contentTypeId=\"");
        _builder.append(pkgName, "\t\t");
        _builder.append(".");
        _builder.append(gmName, "\t\t");
        _builder.append("ContentType\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("</contentTypeBinding>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<contentTypeBinding");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("contentTypeId=\"org.eclipse.graphiti.content.diagram\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</contentTypeBinding>");
        _builder.newLine();
        _builder.append("</editor>");
        _builder.newLine();
        return _builder;
    }

    public String contentTypes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<extension");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("point=\"org.eclipse.core.contenttype.contentTypes\">");
        _builder.newLine();
        String result = _builder.toString();
        Functions.Function1<GraphModel, Boolean> _function = new Functions.Function1<GraphModel, Boolean>(){

            public Boolean apply(GraphModel it) {
                boolean _isIsAbstract = it.isIsAbstract();
                return !_isIsAbstract;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)this.mgl.getGraphModels(), (Functions.Function1)_function);
        for (GraphModel gm : _filter) {
            String _result = result;
            CharSequence _contentTypes = this.contentTypes(this._generatorUtils.packageName((Annotatable)gm).toString(), gm.getName(), gm.getFileExtension());
            result = String.valueOf(_result) + _contentTypes;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("</extension>");
        return String.valueOf(result) + _builder_1;
    }

    public CharSequence contentTypes(String pkgName, String gmName, String fileExtension) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<!--@CincoGen ");
        _builder.append(gmName);
        _builder.append("-->");
        _builder.newLineIfNotEmpty();
        _builder.append("<content-type");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("file-extensions=\"");
        _builder.append(fileExtension, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("id=\"");
        _builder.append(pkgName, "\t");
        _builder.append(".");
        _builder.append(gmName, "\t");
        _builder.append("ContentType\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("name=\"");
        _builder.append(gmName, "\t");
        _builder.append(" Content Type\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("priority=\"normal\">");
        _builder.newLine();
        _builder.append("</content-type>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence perspectives() {
        return this.perspectives(this.pkgName, this.mglName, null);
    }

    public CharSequence perspectives(String pkgName, String gmName, String icon) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<extension");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("point=\"org.eclipse.ui.perspectives\">");
        _builder.newLine();
        _builder.append("<!--@CincoGen ");
        _builder.append(gmName);
        _builder.append("-->");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<perspective");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("class=\"");
        _builder.append(pkgName, "\t\t");
        _builder.append(".");
        _builder.append(gmName, "\t\t");
        _builder.append("PerspectiveFactory\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("fixed=\"false\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("id=\"");
        _builder.append(pkgName, "\t\t");
        _builder.append(".");
        String _lowerCase = gmName.toLowerCase();
        _builder.append(_lowerCase, "\t\t");
        _builder.append("perspective\"");
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)icon);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("\t\t");
            _builder.append("icon=\"");
            _builder.append(icon, "\t\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("name=\"");
        _builder.append(gmName, "\t\t");
        _builder.append(" Perspective\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("</perspective>");
        _builder.newLine();
        _builder.append("</extension>");
        _builder.newLine();
        return _builder;
    }

    public String navigatorContent() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<extension");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("point=\"org.eclipse.ui.navigator.navigatorContent\">");
        _builder.newLine();
        String result = _builder.toString();
        Functions.Function1<GraphModel, Boolean> _function = new Functions.Function1<GraphModel, Boolean>(){

            public Boolean apply(GraphModel it) {
                boolean _isIsAbstract = it.isIsAbstract();
                return !_isIsAbstract;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)this.mgl.getGraphModels(), (Functions.Function1)_function);
        for (GraphModel gm : _filter) {
            String _result = result;
            CharSequence _navigatorContent = this.navigatorContent(this._generatorUtils.packageName((Annotatable)gm).toString(), gm.getName());
            result = String.valueOf(_result) + _navigatorContent;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("</extension>");
        return String.valueOf(result) + _builder_1;
    }

    public CharSequence navigatorContent(String pkgName, String gmName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<!--@CincoGen ");
        _builder.append(gmName);
        _builder.append("-->");
        _builder.newLineIfNotEmpty();
        _builder.append("<commonWizard");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("menuGroupId=\"mgl\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("type=\"new\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("wizardId=\"");
        _builder.append(pkgName, "\t");
        _builder.append(".wizard.");
        String _lowerCase = gmName.toLowerCase();
        _builder.append(_lowerCase, "\t");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<enablement></enablement>");
        _builder.newLine();
        _builder.append("</commonWizard>");
        _builder.newLine();
        return _builder;
    }

    public String referenceRegistry() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<extension");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("point=\"de.jabc.cinco.meta.core.referenceregistry\">");
        _builder.newLine();
        String result = _builder.toString();
        Functions.Function1<GraphModel, Boolean> _function = new Functions.Function1<GraphModel, Boolean>(){

            public Boolean apply(GraphModel it) {
                boolean _isIsAbstract = it.isIsAbstract();
                return !_isIsAbstract;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)this.mgl.getGraphModels(), (Functions.Function1)_function);
        for (GraphModel gm : _filter) {
            String _result = result;
            CharSequence _referenceRegistry = this.referenceRegistry(this._generatorUtils.packageName((Annotatable)gm).toString(), gm.getName());
            result = String.valueOf(_result) + _referenceRegistry;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("</extension>");
        return String.valueOf(result) + _builder_1;
    }

    public CharSequence referenceRegistry(String pkgName, String gmName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<!--@CincoGen ");
        _builder.append(gmName);
        _builder.append("-->");
        _builder.newLineIfNotEmpty();
        _builder.append("<FileExtensionsRegistry");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("class=\"");
        _builder.append(pkgName, "\t");
        _builder.append(".");
        _builder.append(gmName, "\t");
        _builder.append("FileExtensions\">");
        _builder.newLineIfNotEmpty();
        _builder.append("</FileExtensionsRegistry>");
        _builder.newLine();
        return _builder;
    }

    public String contentParser() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<extension");
        _builder.newLine();
        _builder.append("\t      ");
        _builder.append("point=\"org.eclipse.emf.ecore.content_parser\">");
        _builder.newLine();
        String result = _builder.toString();
        Functions.Function1<GraphModel, Boolean> _function = new Functions.Function1<GraphModel, Boolean>(){

            public Boolean apply(GraphModel it) {
                boolean _isIsAbstract = it.isIsAbstract();
                return !_isIsAbstract;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)this.mgl.getGraphModels(), (Functions.Function1)_function);
        for (GraphModel gm : _filter) {
            String _result = result;
            CharSequence _contentParser = this.contentParser(this._generatorUtils.packageName((Annotatable)gm).toString(), gm.getName());
            result = String.valueOf(_result) + _contentParser;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("</extension>");
        return String.valueOf(result) + _builder_1;
    }

    public CharSequence contentParser(String pkgName, String gmName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<!--@CincoGen ");
        _builder.append(gmName);
        _builder.append("-->");
        _builder.newLineIfNotEmpty();
        _builder.append("<parser");
        _builder.newLine();
        _builder.append("class=\"");
        _builder.append(pkgName);
        _builder.append(".");
        _builder.append(gmName);
        _builder.append("APIParser\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("contentTypeIdentifier=\"");
        _builder.append(pkgName, "\t");
        _builder.append(".");
        _builder.append(gmName, "\t");
        _builder.append("ContentType\">");
        _builder.newLineIfNotEmpty();
        _builder.append("</parser>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence factoryOverride() {
        return this.factoryOverride(this.pkgName, this.mglName);
    }

    public CharSequence factoryOverride(String pkgName, String gmName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<extension");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("point=\"org.eclipse.emf.ecore.factory_override\">");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<!--@CincoGen ");
        _builder.append(gmName, "\t\t");
        _builder.append("-->");
        _builder.newLineIfNotEmpty();
        _builder.append("   \t\t");
        _builder.append("<factory");
        _builder.newLine();
        _builder.append("        \t");
        _builder.append("class=\"");
        _builder.append(pkgName, "        \t");
        _builder.append(".");
        _builder.append(gmName, "        \t");
        _builder.append("Factory\"");
        _builder.newLineIfNotEmpty();
        _builder.append("        \t");
        _builder.append("uri=\"");
        _builder.append(this.nsUri, "        \t");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("   \t\t");
        _builder.append("</factory>");
        _builder.newLine();
        _builder.append("</extension>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence resourceContributor() {
        return this.resourceContributor(this.pkgName);
    }

    public CharSequence resourceContributor(String pkgName) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1<GraphModel, Boolean> _function = new Functions.Function1<GraphModel, Boolean>(){

            public Boolean apply(GraphModel it) {
                boolean _isIsAbstract = it.isIsAbstract();
                return !_isIsAbstract;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)this.mgl.getGraphModels(), (Functions.Function1)_function);
        for (GraphModel gm : _filter) {
            _builder.append("<extension");
            _builder.newLine();
            _builder.append("      ");
            _builder.append("id=\"");
            _builder.append(pkgName, "      ");
            _builder.append(".");
            String _firstUpper = StringExtensions.toFirstUpper((String)gm.getName());
            _builder.append(_firstUpper, "      ");
            _builder.append("ResourceContributor\"");
            _builder.newLineIfNotEmpty();
            _builder.append("      ");
            _builder.append("name=\"");
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)gm.getName());
            _builder.append(_firstUpper_1, "      ");
            _builder.append(" Resource Contributor\"");
            _builder.newLineIfNotEmpty();
            _builder.append("      ");
            _builder.append("point=\"de.jabc.cinco.meta.core.ui.ResourceContributor\">");
            _builder.newLine();
            _builder.append("<!--@CincoGen ");
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)gm.getName());
            _builder.append(_firstUpper_2);
            _builder.append("-->");
            _builder.newLineIfNotEmpty();
            _builder.append("   ");
            _builder.append("<Contributor");
            _builder.newLine();
            _builder.append("         ");
            _builder.append("class=\"");
            _builder.append(pkgName, "         ");
            _builder.append(".");
            String _firstUpper_3 = StringExtensions.toFirstUpper((String)gm.getName());
            _builder.append(_firstUpper_3, "         ");
            _builder.append("ResourceContributor\">");
            _builder.newLineIfNotEmpty();
            _builder.append("   ");
            _builder.append("</Contributor>");
            _builder.newLine();
            _builder.append("</extension>");
            _builder.newLine();
        }
        return _builder;
    }
}

