/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.templates;

import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;
import de.jabc.cinco.meta.runtime.xapi.WorkspaceExtension;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mgl.Annotatable;
import mgl.Annotation;
import mgl.GraphModel;
import mgl.MGLModel;
import mgl.ModelElement;
import mgl.Node;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.ui.platform.AbstractImageProvider;
import org.eclipse.graphiti.ui.platform.IImageProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.osgi.framework.Bundle;

public class ImageProviderTmpl {
    @Extension
    private GeneratorUtils _generatorUtils = GeneratorUtils.getInstance();

    public CharSequence generateImageProvider(MGLModel mgl) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        CharSequence _packageName = this._generatorUtils.packageName((Annotatable)mgl);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        String _fuName = this._generatorUtils.fuName(mgl);
        _builder.append(_fuName);
        _builder.append("ImageProvider extends ");
        String _name = AbstractImageProvider.class.getName();
        _builder.append(_name);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("implements ");
        String _name_1 = IImageProvider.class.getName();
        _builder.append(_name_1, "\t");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private ");
        String _name_2 = Hashtable.class.getName();
        _builder.append(_name_2, "\t");
        _builder.append("<");
        String _name_3 = String.class.getName();
        _builder.append(_name_3, "\t");
        _builder.append(", ");
        String _name_4 = String.class.getName();
        _builder.append(_name_4, "\t");
        _builder.append("> images;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Sets an ImageProvider");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _fuName_1 = this._generatorUtils.fuName(mgl);
        _builder.append(_fuName_1, "\t");
        _builder.append("ImageProvider() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _fuName_2 = this._generatorUtils.fuName(mgl);
        _builder.append(_fuName_2, "\t\t");
        _builder.append("GraphitiUtils.getInstance().setImageProvider(this);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Adds an image to the editor");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param id : Id of an image");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param path : Path of the image");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void addImage(");
        String _name_5 = String.class.getName();
        _builder.append(_name_5, "\t");
        _builder.append(" id, ");
        String _name_6 = String.class.getName();
        _builder.append(_name_6, "\t");
        _builder.append(" path) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if (images == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("images = new ");
        String _name_7 = Hashtable.class.getName();
        _builder.append(_name_7, "\t\t\t");
        _builder.append("<");
        String _name_8 = String.class.getName();
        _builder.append(_name_8, "\t\t\t");
        _builder.append(", ");
        String _name_9 = String.class.getName();
        _builder.append(_name_9, "\t\t\t");
        _builder.append(">();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("images.put(id, path);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Returns the id of an image.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param path : Path is the path of an image");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return Returns the id of an image.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _name_10 = String.class.getName();
        _builder.append(_name_10, "\t");
        _builder.append(" getImageId(");
        String _name_11 = String.class.getName();
        _builder.append(_name_11, "\t");
        _builder.append(" path) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("for (");
        CharSequence _entryName = this._generatorUtils.entryName(Map.Entry.class);
        _builder.append((Object)_entryName, "\t\t");
        _builder.append("<");
        String _name_12 = String.class.getName();
        _builder.append(_name_12, "\t\t");
        _builder.append(", ");
        String _name_13 = String.class.getName();
        _builder.append(_name_13, "\t\t");
        _builder.append("> e : images.entrySet()){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("if (e.getValue().equals(path))");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return e.getKey();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t");
        String _name_14 = WorkspaceExtension.class.getName();
        _builder.append(_name_14, "\t\t\t");
        _builder.append(" workspaceExtension = new ");
        String _name_15 = WorkspaceExtension.class.getName();
        _builder.append(_name_15, "\t\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        String _name_16 = IWorkspaceRoot.class.getName();
        _builder.append(_name_16, "\t\t\t");
        _builder.append(" root = workspaceExtension.getWorkspaceRoot();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        String _name_17 = List.class.getName();
        _builder.append(_name_17, "\t\t\t");
        _builder.append("<");
        String _name_18 = IFile.class.getName();
        _builder.append(_name_18, "\t\t\t");
        _builder.append("> files = workspaceExtension.getFiles(root, f -> f.getFullPath().toString().contains(path));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("if (files.size() == 1) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        String _name_19 = IFile.class.getName();
        _builder.append(_name_19, "\t\t\t\t");
        _builder.append(" f = files.get(0);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        String _name_20 = URL.class.getName();
        _builder.append(_name_20, "\t\t\t\t");
        _builder.append(" url = f.getLocationURI().toURL();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("if (images.get(path) == null) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("addImage(path, url.toString());");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("addImageFilePath(path, url.toString());");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}  else {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("java.io.File f = new ");
        String _name_21 = File.class.getName();
        _builder.append(_name_21, "\t\t\t\t");
        _builder.append("(path);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("if (f.exists()) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("addImage(path, f.toURI().toURL().toString());");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} catch (");
        String _name_22 = MalformedURLException.class.getName();
        _builder.append(_name_22, "\t\t");
        _builder.append(" e) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("e.printStackTrace();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return path;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* Adds available images if the 'ImageFilePath' is is null");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* If the HashTable 'images' is null a new one will be created");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected void addAvailableImages() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (images == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("images = new ");
        String _name_23 = Hashtable.class.getName();
        _builder.append(_name_23, "\t\t\t");
        _builder.append("<");
        String _name_24 = String.class.getName();
        _builder.append(_name_24, "\t\t\t");
        _builder.append(", ");
        String _name_25 = String.class.getName();
        _builder.append(_name_25, "\t\t\t");
        _builder.append(">();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (");
        CharSequence _entryName_1 = this._generatorUtils.entryName(Map.Entry.class);
        _builder.append((Object)_entryName_1, "\t\t");
        _builder.append("<");
        String _name_26 = String.class.getName();
        _builder.append(_name_26, "\t\t");
        _builder.append(", ");
        String _name_27 = String.class.getName();
        _builder.append(_name_27, "\t\t");
        _builder.append("> e : images.entrySet()) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("if (getImageFilePath(e.getKey()) == null)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("addImageFilePath(e.getKey(), e.getValue());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Each image is logged in by adding the images and creating the related path.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void initImages() {");
        _builder.newLine();
        _builder.append("\t\t");
        String _name_28 = Bundle.class.getName();
        _builder.append(_name_28, "\t\t");
        _builder.append(" b = ");
        String _name_29 = Platform.class.getName();
        _builder.append(_name_29, "\t\t");
        _builder.append(".getBundle(\"");
        String _projectSymbolicName = ProjectCreator.getProjectSymbolicName((IProject)ProjectCreator.getProject((Resource)mgl.eResource()));
        _builder.append(_projectSymbolicName, "\t\t");
        _builder.append(".editor.graphiti\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _name_30 = File.class.getName();
        _builder.append(_name_30, "\t\t");
        _builder.append(" file;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _name_31 = URL.class.getName();
        _builder.append(_name_31, "\t\t");
        _builder.append(" url = null;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//Search for all used images in graphmodel and register them in the image provider");
        _builder.newLine();
        EList _graphModels = mgl.getGraphModels();
        for (GraphModel gm : _graphModels) {
            Set _entrySet = MGLUtil.getAllImages((GraphModel)gm).entrySet();
            for (Map.Entry entry : _entrySet) {
                _builder.append("\t\t");
                _builder.append("url =  ");
                String _name_32 = FileLocator.class.getName();
                _builder.append(_name_32, "\t\t");
                _builder.append(".find(b, new ");
                String _name_33 = Path.class.getName();
                _builder.append(_name_33, "\t\t");
                _builder.append("(\"");
                String _key = (String)entry.getKey();
                _builder.append(_key, "\t\t");
                _builder.append("\"), null);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("addImage(\"");
                String _key_1 = (String)entry.getKey();
                _builder.append(_key_1, "\t\t");
                _builder.append("\", url.toString());\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t\t");
        _builder.append("b = ");
        String _name_34 = Platform.class.getName();
        _builder.append(_name_34, "\t\t");
        _builder.append(".getBundle(\"de.jabc.cinco.meta.core.ge.style.generator.runtime\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("url =  ");
        String _name_35 = FileLocator.class.getName();
        _builder.append(_name_35, "\t\t");
        _builder.append(".find(b, new ");
        String _name_36 = Path.class.getName();
        _builder.append(_name_36, "\t\t");
        _builder.append("(\"/icons/_Connection.png\"), null);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("addImage(\"_Connection.png\", url.toString());");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("addAvailableImages();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public static EList<ModelElement> getIconNodes(GraphModel gm) {
        boolean _not;
        BasicEList foundNodes = new BasicEList();
        List nodes = IterableExtensions.toList((Iterable)MGLUtil.nodes((GraphModel)gm));
        for (Node node : nodes) {
            EList annots = node.getAnnotations();
            for (Annotation annot : annots) {
                boolean _equals = annot.getName().equals("icon");
                if (!_equals) continue;
                foundNodes.add((Object)node);
            }
        }
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)gm.getIconPath());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            foundNodes.add((Object)gm);
        }
        return foundNodes;
    }
}

