/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.action;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.ge.style.generator.api.main.CincoApiGeneratorMain;
import de.jabc.cinco.meta.core.ge.style.generator.main.GraphitiGeneratorMain;
import de.jabc.cinco.meta.core.ui.listener.MGLSelectionListener;
import de.jabc.cinco.meta.core.utils.CincoUtil;
import de.jabc.cinco.meta.core.utils.PathValidator;
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;
import de.jabc.cinco.meta.plugin.event.api.util.EventApiExtension;
import de.jabc.cinco.meta.runtime.xapi.FileExtension;
import de.jabc.cinco.meta.runtime.xapi.WorkspaceExtension;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import mgl.Annotatable;
import mgl.Annotation;
import mgl.Attribute;
import mgl.GraphModel;
import mgl.MGLModel;
import mgl.Node;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.osgi.framework.Bundle;
import style.Image;
import style.Styles;

public class NewGraphitiCodeGenerator
extends AbstractHandler {
    @Extension
    private WorkspaceExtension _workspaceExtension = new WorkspaceExtension();
    @Extension
    private FileExtension _fileExtension = new FileExtension();
    @Extension
    private GeneratorUtils _generatorUtils = GeneratorUtils.getInstance();
    @Extension
    private EventApiExtension _eventApiExtension = new EventApiExtension();
    private IProject project = null;
    private HashSet<String> folders;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IFile cpdFile = MGLSelectionListener.INSTANCE.getSelectedCPDFile();
            if (cpdFile == null) {
                throw new RuntimeException("No current cpd file in MGLSelectionListener...");
            }
            StringConcatenation _builder = new StringConcatenation();
            String _projectSymbolicName = ProjectCreator.getProjectSymbolicName((IProject)ProjectCreator.getProject((Resource)((MGLModel[])Conversions.unwrapArray((Object)this._generatorUtils.allMGLs, MGLModel.class))[0].eResource()));
            _builder.append(_projectSymbolicName);
            _builder.append(".editor.graphiti");
            String name_editorProject = _builder.toString();
            IProject _project = this._workspaceExtension.getWorkspaceRoot().getProject(name_editorProject);
            if (_project != null) {
                _project.delete(true, true, null);
            }
            Set<String> _reqBundles = this.getReqBundles(cpdFile.getProject());
            Functions.Function1<MGLModel, EList<GraphModel>> _function = new Functions.Function1<MGLModel, EList<GraphModel>>(){

                public EList<GraphModel> apply(MGLModel it) {
                    return it.getGraphModels();
                }
            };
            Functions.Function1<GraphModel, Set<String>> _function_1 = new Functions.Function1<GraphModel, Set<String>>(){

                public Set<String> apply(GraphModel it) {
                    return NewGraphitiCodeGenerator.this.additionalBundles(it);
                }
            };
            Iterable _flatMap = IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap((Iterable)this._generatorUtils.allMGLs, (Functions.Function1)_function), (Functions.Function1)_function_1);
            Set bundles = IterableExtensions.toSet((Iterable)Iterables.concat(_reqBundles, (Iterable)_flatMap));
            this.project = ProjectCreator.createDefaultPluginProject((String)name_editorProject, (Set)bundles, null);
            ProjectCreator.addAdditionalNature((IProject)this.project, null, (String[])new String[]{"org.eclipse.xtext.ui.shared.xtextNature"});
            for (final MGLModel mglModel : this._generatorUtils.allMGLs) {
                boolean _not;
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)mglModel.getGraphModels());
                boolean bl = _not = !_isNullOrEmpty;
                if (!_not) continue;
                this.folders = CollectionLiterals.newHashSet();
                this.copyImages(mglModel);
                Styles _styles = CincoUtil.getStyles((MGLModel)mglModel);
                GraphitiGeneratorMain _graphitiGeneratorMain = new GraphitiGeneratorMain(mglModel, cpdFile, _styles, this.folders);
                Procedures.Procedure1<GraphitiGeneratorMain> _function_2 = new Procedures.Procedure1<GraphitiGeneratorMain>(){

                    public void apply(GraphitiGeneratorMain it) {
                        Consumer<String> _function = new Consumer<String>(){

                            @Override
                            public void accept(String it) {
                                ProjectCreator.exportPackage((IProject)(this).NewGraphitiCodeGenerator.this.project, (String)it);
                            }
                        };
                        NewGraphitiCodeGenerator.this.getExpPackages(mglModel).forEach(_function);
                        it.doGenerate(NewGraphitiCodeGenerator.this.project);
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)_graphitiGeneratorMain, (Procedures.Procedure1)_function_2);
                new CincoApiGeneratorMain(mglModel).doGenerate(this.project);
            }
            this.sanitizeManifestFile(name_editorProject);
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void sanitizeManifestFile(String projectName) {
        try {
            this._workspaceExtension.getWorkspaceRoot().getProject(projectName).getFile("META-INF/MANIFEST.MF").touch(null);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Set<String> getReqBundles(IProject project) {
        String _eventCorePluginID = this._eventApiExtension.getEventCorePluginID();
        String _eventApiPluginID = this._eventApiExtension.getEventApiPluginID();
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                Bundle _bundle = Platform.getBundle((String)it);
                String _symbolicName = null;
                if (_bundle != null) {
                    _symbolicName = _bundle.getSymbolicName();
                }
                return _symbolicName;
            }
        };
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)ListExtensions.map(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.emf.transaction", "org.eclipse.graphiti", "org.eclipse.graphiti.mm", "org.eclipse.graphiti.ui", "org.eclipse.core.resources", "org.eclipse.ui", "org.eclipse.ui.ide", "org.eclipse.ui.navigator", "org.eclipse.ui.views.properties.tabbed", "org.eclipse.gef", "org.eclipse.xtext.ui", "org.eclipse.xtext.xbase.lib", "de.jabc.cinco.meta.core.ge.style.model", "de.jabc.cinco.meta.core.ge.style.generator", "de.jabc.cinco.meta.core.referenceregistry", "de.jabc.cinco.meta.core.ui", "de.jabc.cinco.meta.util", "de.jabc.cinco.meta.runtime", "de.jabc.cinco.meta.core.utils", "de.jabc.cinco.meta.core.capi", "de.jabc.cinco.meta.core.wizards", "javax.el", "com.sun.el", "de.jabc.cinco.meta.core.ge.style.generator.runtime", _eventCorePluginID, _eventApiPluginID})), (Functions.Function1)_function));
        String _name = project.getName();
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)_filterNull, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_name}))));
    }

    private Set<String> additionalBundles(GraphModel gm) {
        Functions.Function1<Attribute, EList<Annotation>> _function = new Functions.Function1<Attribute, EList<Annotation>>(){

            public EList<Annotation> apply(Attribute it) {
                return it.getAnnotations();
            }
        };
        Functions.Function1<Annotation, Boolean> _function_1 = new Functions.Function1<Annotation, Boolean>(){

            public Boolean apply(Annotation it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)"grammar");
            }
        };
        Functions.Function1<Annotation, String> _function_2 = new Functions.Function1<Annotation, String>(){

            public String apply(Annotation it) {
                return (String)it.getValue().get(1);
            }
        };
        Functions.Function1<String, String> _function_3 = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return it.substring(0, it.lastIndexOf("."));
            }
        };
        Functions.Function1<String, String> _function_4 = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return it.substring(0, it.lastIndexOf("."));
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)this._generatorUtils.allModelAttributes(gm), (Functions.Function1)_function)), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4));
    }

    private List<String> getExpPackages(MGLModel mgl) {
        String _string = this._generatorUtils.packageName((Annotatable)mgl).toString();
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_string}));
    }

    private void copyImages(MGLModel mgl) {
        try {
            HashMap images = CollectionLiterals.newHashMap();
            EList _graphModels = mgl.getGraphModels();
            for (GraphModel gm : _graphModels) {
                boolean _not;
                String iconPath = gm.getIconPath();
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)iconPath);
                boolean bl = _not = !_isNullOrEmpty;
                if (!_not) continue;
                images.put(iconPath, PathValidator.getURLForString((EObject)gm, (String)iconPath));
            }
            EList _nodes = mgl.getNodes();
            for (Node node : _nodes) {
                EList annots = node.getAnnotations();
                for (Annotation annot : annots) {
                    boolean _not;
                    boolean _equals = annot.getName().equals("icon");
                    if (!_equals) continue;
                    String iconPath = (String)annot.getValue().get(0);
                    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)iconPath);
                    boolean bl = _not = !_isNullOrEmpty;
                    if (!_not) continue;
                    images.put(iconPath, PathValidator.getURLForString((EObject)mgl, (String)iconPath));
                }
            }
            Styles styles = CincoUtil.getStyles((MGLModel)mgl);
            TreeIterator ti = styles.eResource().getAllContents();
            while (ti.hasNext()) {
                Image img;
                String path;
                boolean _isRelativePath;
                EObject o = (EObject)ti.next();
                if (!(o instanceof Image) || !(_isRelativePath = PathValidator.isRelativePath((String)(path = (img = (Image)o).getPath())))) continue;
                URL url = PathValidator.getURLForString((EObject)img, (String)path);
                images.put(path, url);
            }
            Set _entrySet = images.entrySet();
            for (Map.Entry it : _entrySet) {
                URI _uRI = ((URL)it.getValue()).toURI();
                File source = new File(_uRI);
                this.exportFolder((String)it.getKey());
                String _key = (String)it.getKey();
                FileInputStream _fileInputStream = new FileInputStream(source);
                this._workspaceExtension.createFile((IContainer)this.project, _key, (InputStream)_fileInputStream);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean exportFolder(String fileName) {
        boolean _xblockexpression = false;
        int index = fileName.lastIndexOf("/");
        boolean _xifexpression = false;
        if (index > -1) {
            boolean _xblockexpression_1 = false;
            String folderPath = fileName.substring(0, index);
            _xifexpression = _xblockexpression_1 = this.folders.add(folderPath);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

