/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.wizards.project;

import de.jabc.cinco.meta.core.wizards.project.CincoProductProjectCreator;
import de.jabc.cinco.meta.core.wizards.project.CreateExampleProjectPage;
import de.jabc.cinco.meta.core.wizards.project.CreateNewProjectPage;
import de.jabc.cinco.meta.core.wizards.project.ExampleFeature;
import de.jabc.cinco.meta.core.wizards.project.MainPage;
import java.util.EnumSet;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class NewMGLProjectWizard
extends Wizard
implements IWorkbenchWizard {
    MainPage mainPage = new MainPage("mainPage");
    CreateExampleProjectPage examplesPage = new CreateExampleProjectPage("examplesPage");
    CreateNewProjectPage newProjectPage = new CreateNewProjectPage("newProjectPage");

    public void addPages() {
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.examplesPage);
        this.addPage((IWizardPage)this.newProjectPage);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mainPage) {
            if (this.mainPage.isCreateExample()) {
                return this.examplesPage;
            }
            return this.newProjectPage;
        }
        return null;
    }

    public boolean canFinish() {
        if (this.mainPage.isCreateExample()) {
            return this.examplesPage.isPageComplete();
        }
        return this.newProjectPage.isPageComplete();
    }

    public boolean performFinish() {
        String mglModelName;
        String packageName;
        String projectName;
        EnumSet<ExampleFeature> features = EnumSet.noneOf(ExampleFeature.class);
        if (this.mainPage.isCreateExample()) {
            projectName = this.examplesPage.getProjectName();
            packageName = this.examplesPage.getPackageName();
            mglModelName = this.examplesPage.getModelName();
            features.addAll(this.examplesPage.getSelectedFeatures());
        } else {
            projectName = this.newProjectPage.getProjectName();
            packageName = this.newProjectPage.getPackageName();
            mglModelName = this.newProjectPage.getModelName();
        }
        CincoProductProjectCreator projectCreator = new CincoProductProjectCreator(projectName, packageName, mglModelName, String.valueOf(mglModelName) + "Tool", this.mainPage.isCreateExample(), features);
        projectCreator.create();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("New Cinco Product Project");
    }
}

