/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.wizards.project;

import de.jabc.cinco.meta.core.wizards.CincoWizardUtils;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateNewProjectPage
extends WizardPage {
    private Button btnProjectAsPkg;
    private Text txtProjectName;
    private Text txtPackageName;
    private Text txtModelName;

    protected CreateNewProjectPage(String pageName) {
        super(pageName);
        this.setTitle("Start New Cinco Product Project");
        this.setDescription("Create new Cinco Product project with minimal required files");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label lblProjectName = new Label(comp, 0);
        lblProjectName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblProjectName.setText("&Project Name");
        this.txtProjectName = new Text(comp, 2048);
        this.txtProjectName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnProjectAsPkg = new Button(comp, 32);
        this.btnProjectAsPkg.setSelection(true);
        this.btnProjectAsPkg.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.btnProjectAsPkg.setText("Use project name as package name");
        this.btnProjectAsPkg.setEnabled(false);
        Label lblPackageName = new Label(comp, 0);
        lblPackageName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblPackageName.setText("Package Name");
        this.txtPackageName = new Text(comp, 2048);
        this.txtPackageName.setEnabled(false);
        this.txtPackageName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label modelName = new Label(comp, 0);
        modelName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        modelName.setText("Model &Name");
        this.txtModelName = new Text(comp, 2048);
        this.txtModelName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.addListeners();
        this.initContents();
        this.setControl((Control)comp);
    }

    private void initContents() {
        this.txtModelName.setText("SomeGraph");
        this.txtProjectName.setText("info.scce.cinco.product.somegraph");
        this.txtPackageName.setText("info.scce.cinco.product.somegraph");
        this.dialogChanged();
    }

    private void addListeners() {
        SelectionListener btnSelLis = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateNewProjectPage.this.btnProjectAsPkg.getSelection() && CreateNewProjectPage.this.txtProjectName.getText() != null) {
                    CreateNewProjectPage.this.txtPackageName.setText(CreateNewProjectPage.this.txtProjectName.getText());
                }
                CreateNewProjectPage.this.txtPackageName.setEnabled(!CreateNewProjectPage.this.btnProjectAsPkg.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        KeyListener txtProjectNameListener = new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (CreateNewProjectPage.this.btnProjectAsPkg.getSelection()) {
                    CreateNewProjectPage.this.txtPackageName.setText(CreateNewProjectPage.this.txtProjectName.getText());
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        };
        KeyListener pageCompleteValidationListener = new KeyListener(){

            public void keyReleased(KeyEvent e) {
                CreateNewProjectPage.this.dialogChanged();
            }

            public void keyPressed(KeyEvent e) {
            }
        };
        this.btnProjectAsPkg.addSelectionListener(btnSelLis);
        this.txtProjectName.addKeyListener(txtProjectNameListener);
        this.txtPackageName.addKeyListener(pageCompleteValidationListener);
        this.txtProjectName.addKeyListener(pageCompleteValidationListener);
        this.txtModelName.addKeyListener(pageCompleteValidationListener);
    }

    private void updateStatus(String msg) {
        this.setErrorMessage(msg);
        if (this.getContainer().getCurrentPage() != null) {
            this.getWizard().getContainer().updateMessage();
            this.getWizard().getContainer().updateButtons();
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private void dialogChanged() {
        String projectNameError = CincoWizardUtils.validateProjectName(this.txtProjectName.getText());
        String packageNameError = CincoWizardUtils.validatePackageName(this.txtPackageName.getText());
        String modelNameError = CincoWizardUtils.validateModelName(this.txtModelName.getText());
        if (projectNameError != null) {
            this.updateStatus(projectNameError);
        } else if (packageNameError != null) {
            this.updateStatus(packageNameError);
        } else if (modelNameError != null) {
            this.updateStatus(modelNameError);
        } else {
            this.updateStatus(null);
        }
    }

    public String getProjectName() {
        return this.txtProjectName.getText();
    }

    public String getPackageName() {
        return this.txtPackageName.getText();
    }

    public String getModelName() {
        return this.txtModelName.getText();
    }
}

