/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.wizards.project;

import de.jabc.cinco.meta.core.utils.BuildProperties;
import de.jabc.cinco.meta.core.utils.EclipseFileUtils;
import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;
import de.jabc.cinco.meta.core.wizards.project.ExampleFeature;
import de.jabc.cinco.meta.core.wizards.templates.CincoProductWizardTemplates;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.osgi.framework.Bundle;

public class CincoProductProjectCreator {
    private final String projectName;
    private final String packageName;
    private final String mglModelName;
    private final String productName;
    private final boolean createExample;
    private final Set<ExampleFeature> features;

    public CincoProductProjectCreator(String projectName, String packageName, String mglModelName, String productName, boolean createExample, Set<ExampleFeature> features) {
        this.projectName = projectName;
        this.packageName = packageName;
        this.mglModelName = mglModelName.endsWith(".mgl") ? mglModelName.split("\\.")[0] : mglModelName;
        this.productName = productName;
        this.createExample = createExample;
        this.features = createExample ? features : Collections.emptySet();
    }

    public void create() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IProject project = ProjectCreator.createProject((String)this.projectName, this.getSrcFolders(), null, this.getReqBundles(), this.getExportedPackages(), this.getNatures(), (IProgressMonitor)monitor, null, (boolean)true, (boolean)true);
        this.modifyBuildProperties(project, (IProgressMonitor)monitor);
        try {
            IFolder modelFolder = project.getFolder("model");
            this.createResource((IResource)modelFolder, (IProgressMonitor)monitor);
            IFile mglModelFile = modelFolder.getFile(this.mglModelName.concat(".mgl"));
            IFile styleModelFile = modelFolder.getFile(this.mglModelName.concat(".style"));
            IFile cpdModelFile = modelFolder.getFile(this.productName.concat(".cpd"));
            if (!this.createExample) {
                CharSequence mglCode = CincoProductWizardTemplates.generateSomeGraphMGL(this.mglModelName, this.packageName);
                EclipseFileUtils.writeToFile((IFile)mglModelFile, (CharSequence)mglCode);
                CharSequence styleCode = CincoProductWizardTemplates.generateSomeGraphStyle();
                EclipseFileUtils.writeToFile((IFile)styleModelFile, (CharSequence)styleCode);
                CharSequence cpdCode = CincoProductWizardTemplates.generateSomeGraphCPD(this.mglModelName, this.packageName);
                EclipseFileUtils.writeToFile((IFile)cpdModelFile, (CharSequence)cpdCode);
                this.refreshSelectOpen(project, cpdModelFile, null, (IProgressMonitor)monitor);
            } else {
                IFile appearanceProviderFile;
                String mglCode = CincoProductWizardTemplates.generateFlowGraphMGL(this.mglModelName, this.packageName, this.projectName, this.features);
                EclipseFileUtils.writeToFile((IFile)mglModelFile, (CharSequence)mglCode);
                CharSequence styleCode = CincoProductWizardTemplates.generateFlowGraphStyle(this.packageName, this.features);
                EclipseFileUtils.writeToFile((IFile)styleModelFile, (CharSequence)styleCode);
                CharSequence cpdCode = CincoProductWizardTemplates.generateFlowGraphCPD(this.mglModelName, this.packageName, this.features);
                EclipseFileUtils.writeToFile((IFile)cpdModelFile, (CharSequence)cpdCode);
                IFile readmeFile = project.getFile("README.txt");
                CharSequence readmeCode = CincoProductWizardTemplates.generateReadme(this.mglModelName, this.packageName, this.projectName, this.features);
                EclipseFileUtils.writeToFile((IFile)readmeFile, (CharSequence)readmeCode);
                if (this.features.contains((Object)ExampleFeature.APPEARANCE_PROVIDER)) {
                    IFolder appearanceFolder = project.getFolder("src/" + this.packageName.replaceAll("\\.", "/") + "/appearance");
                    this.createResource((IResource)appearanceFolder, (IProgressMonitor)monitor);
                    appearanceProviderFile = appearanceFolder.getFile("SimpleArrowAppearance.java");
                    CharSequence appearanceProviderCode = CincoProductWizardTemplates.generateAppearanceProvider(this.mglModelName, this.packageName);
                    EclipseFileUtils.writeToFile((IFile)appearanceProviderFile, (CharSequence)appearanceProviderCode);
                }
                if (this.features.contains((Object)ExampleFeature.CODE_GENERATOR)) {
                    IFolder codegenFolder = project.getFolder("src/" + this.packageName.replaceAll("\\.", "/") + "/codegen");
                    this.createResource((IResource)codegenFolder, (IProgressMonitor)monitor);
                    IFile codegenFile = codegenFolder.getFile("Generate.xtend");
                    CharSequence codegenCode = CincoProductWizardTemplates.generateXtendCodeGenerator(this.mglModelName, this.packageName);
                    EclipseFileUtils.writeToFile((IFile)codegenFile, (CharSequence)codegenCode);
                }
                if (this.features.contains((Object)ExampleFeature.CUSTOM_ACTION)) {
                    IFolder customActionFolder = project.getFolder("src/" + this.packageName.replaceAll("\\.", "/") + "/action");
                    this.createResource((IResource)customActionFolder, (IProgressMonitor)monitor);
                    IFile customActionFile = customActionFolder.getFile("ShortestPathToEnd.java");
                    CharSequence customActionCode = CincoProductWizardTemplates.generateCustomAction(this.mglModelName, this.packageName);
                    EclipseFileUtils.writeToFile((IFile)customActionFile, (CharSequence)customActionCode);
                }
                if (this.features.contains((Object)ExampleFeature.ICONS)) {
                    this.copyIcons(project);
                }
                if (this.features.contains((Object)ExampleFeature.PRODUCT_BRANDING)) {
                    this.copyBranding(project);
                }
                if (this.features.contains((Object)ExampleFeature.PRIME_REFERENCES)) {
                    IFile externalLibraryEcoreFile = modelFolder.getFile("ExternalLibrary.ecore");
                    CharSequence externalLibraryEcoreCode = CincoProductWizardTemplates.generatePrimeRefEcore(this.mglModelName, this.packageName);
                    EclipseFileUtils.writeToFile((IFile)externalLibraryEcoreFile, (CharSequence)externalLibraryEcoreCode);
                    IFile externalLibraryGenmodelFile = modelFolder.getFile("ExternalLibrary.genmodel");
                    CharSequence externalLibraryGenmodelCode = CincoProductWizardTemplates.generatePrimeRefGenmodel(this.mglModelName, this.packageName, this.projectName, ProjectCreator.makeSymbolicName((String)this.projectName));
                    EclipseFileUtils.writeToFile((IFile)externalLibraryGenmodelFile, (CharSequence)externalLibraryGenmodelCode);
                }
                if (this.features.contains((Object)ExampleFeature.POST_CREATE_HOOKS) || this.features.contains((Object)ExampleFeature.TRANSFORMATION_API)) {
                    IFolder hooksFolder = project.getFolder("src/" + this.packageName.replaceAll("\\.", "/") + "/hooks");
                    this.createResource((IResource)hooksFolder, (IProgressMonitor)monitor);
                    if (this.features.contains((Object)ExampleFeature.POST_CREATE_HOOKS)) {
                        appearanceProviderFile = hooksFolder.getFile("RandomActivityName.java");
                        CharSequence randomNameHookCode = CincoProductWizardTemplates.generateRandomActivityNameHook(this.mglModelName, this.packageName);
                        EclipseFileUtils.writeToFile((IFile)appearanceProviderFile, (CharSequence)randomNameHookCode);
                    }
                    if (this.features.contains((Object)ExampleFeature.TRANSFORMATION_API)) {
                        appearanceProviderFile = hooksFolder.getFile("InitializeFlowGraphModel.java");
                        CharSequence initFlowGraphHookCode = CincoProductWizardTemplates.generateInitFlowGraphHook(this.mglModelName, this.packageName);
                        EclipseFileUtils.writeToFile((IFile)appearanceProviderFile, (CharSequence)initFlowGraphHookCode);
                    }
                }
                this.refreshSelectOpen(project, cpdModelFile, readmeFile, (IProgressMonitor)monitor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refreshSelectOpen(IProject project, IFile selection, IFile open, IProgressMonitor monitor) throws CoreException {
        ISetSelectionTarget projectExplorerView;
        project.refreshLocal(2, monitor);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (open != null) {
            IDE.openEditor((IWorkbenchPage)page, (IFile)open);
        }
        if ((projectExplorerView = (ISetSelectionTarget)page.findView("org.eclipse.ui.navigator.ProjectExplorer")) != null && selection != null) {
            projectExplorerView.selectReveal((ISelection)new StructuredSelection((Object)selection));
        }
    }

    private void modifyBuildProperties(IProject project, IProgressMonitor monitor) {
        IFile buildPropertiesFile = (IFile)project.findMember("build.properties");
        try {
            BuildProperties buildProperties = BuildProperties.loadBuildProperties((IFile)buildPropertiesFile);
            buildProperties.appendBinIncludes("icons/");
            buildProperties.appendBinIncludes("plugin.xml");
            buildProperties.appendBinIncludes("plugin.properties");
            buildProperties.appendSource("src-gen/");
            buildProperties.appendSource("xtend-gen/");
            IResource srcFolder = project.findMember("src/");
            if (srcFolder != null && srcFolder.exists()) {
                buildProperties.appendSource("src/");
            }
            buildProperties.appendBinIncludes("resources-gen/");
            buildProperties.store(buildPropertiesFile, monitor);
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
        }
    }

    private List<String> getExportedPackages() {
        ArrayList<String> exports = new ArrayList<String>();
        if (this.features.contains((Object)ExampleFeature.APPEARANCE_PROVIDER)) {
            exports.add(String.valueOf(this.packageName) + ".appearance");
        }
        if (this.features.contains((Object)ExampleFeature.CUSTOM_ACTION)) {
            exports.add(String.valueOf(this.packageName) + ".action");
        }
        if (this.features.contains((Object)ExampleFeature.POST_CREATE_HOOKS)) {
            exports.add(String.valueOf(this.packageName) + ".hooks");
        }
        if (this.features.contains((Object)ExampleFeature.CODE_GENERATOR)) {
            exports.add(String.valueOf(this.packageName) + ".codegen");
        }
        return exports;
    }

    private Set<String> getReqBundles() {
        HashSet<String> bundles = new HashSet<String>();
        bundles.add("org.eclipse.core.runtime");
        bundles.add("org.eclipse.core.resources");
        bundles.add("org.eclipse.emf.ecore");
        bundles.add("org.eclipse.emf.transaction");
        bundles.add("org.eclipse.jface");
        bundles.add("org.eclipse.ui");
        bundles.add("de.jabc.cinco.meta.runtime");
        bundles.add("de.jabc.cinco.meta.util");
        bundles.add("de.jabc.cinco.meta.core.mgl.model");
        bundles.add("de.jabc.cinco.meta.core.ge.style.model");
        bundles.add("de.jabc.cinco.meta.core.ge.style");
        bundles.add("de.jabc.cinco.meta.core.ge.style.generator.runtime");
        bundles.add("de.jabc.cinco.meta.core.referenceregistry");
        bundles.add("de.jabc.cinco.meta.core.utils");
        bundles.add("de.jabc.cinco.meta.core.event");
        if (this.features.contains((Object)ExampleFeature.CODE_GENERATOR)) {
            bundles.add("de.jabc.cinco.meta.plugin.generator.runtime");
        }
        if (this.features.contains((Object)ExampleFeature.PRIME_REFERENCES)) {
            bundles.add("de.jabc.cinco.meta.core.referenceregistry");
        }
        return bundles;
    }

    private List<String> getSrcFolders() {
        ArrayList<String> folders = new ArrayList<String>();
        EnumSet<ExampleFeature> codeFeatures = EnumSet.of(ExampleFeature.APPEARANCE_PROVIDER, ExampleFeature.CODE_GENERATOR, ExampleFeature.CUSTOM_ACTION, ExampleFeature.POST_CREATE_HOOKS, ExampleFeature.TRANSFORMATION_API);
        if (!Collections.disjoint(this.features, codeFeatures)) {
            folders.add("src");
        }
        folders.add("model");
        return folders;
    }

    private List<String> getNatures() {
        ArrayList<String> natures = new ArrayList<String>();
        natures.add("org.eclipse.xtext.ui.shared.xtextNature");
        return natures;
    }

    private void createResource(IResource resource, IProgressMonitor monitor) throws CoreException {
        if (resource == null || resource.exists()) {
            return;
        }
        if (!resource.getParent().exists()) {
            this.createResource((IResource)resource.getParent(), monitor);
        }
        switch (resource.getType()) {
            case 1: {
                ((IFile)resource).create((InputStream)new ByteArrayInputStream(new byte[0]), true, monitor);
                break;
            }
            case 2: {
                ((IFolder)resource).create(0, true, monitor);
                break;
            }
            case 4: {
                ((IProject)resource).create(monitor);
                ((IProject)resource).open(monitor);
            }
        }
    }

    private void copyFiles(IProject p, String sourceFolderName, String targetFolderName, List<String> fileNames) {
        Bundle sourceBundle = Platform.getBundle((String)"de.jabc.cinco.meta.core.wizards");
        File targetFolder = p.getFolder(targetFolderName).getLocation().toFile();
        targetFolder.mkdir();
        for (String fileName : fileNames) {
            File trgFile = p.getFolder(targetFolderName).getFile(fileName).getLocation().toFile();
            try {
                trgFile.createNewFile();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                Throwable e1 = null;
                Object var11_14 = null;
                try {
                    InputStream is = FileLocator.openStream((Bundle)sourceBundle, (IPath)new Path(sourceFolderName.concat("/").concat(fileName)), (boolean)false);
                    try {
                        try (FileOutputStream os = new FileOutputStream(trgFile);){
                            int readLength;
                            byte[] buffer = new byte[16384];
                            while ((readLength = is.read(buffer)) != -1) {
                                os.write(buffer, 0, readLength);
                            }
                        }
                        if (is == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (e1 == null) {
                            e1 = throwable;
                        } else if (e1 != throwable) {
                            e1.addSuppressed(throwable);
                        }
                        if (is != null) {
                            is.close();
                        }
                        throw e1;
                    }
                    is.close();
                }
                catch (Throwable throwable) {
                    if (e1 == null) {
                        e1 = throwable;
                    } else if (e1 != throwable) {
                        e1.addSuppressed(throwable);
                    }
                    throw e1;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void copyIcons(IProject p) {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add("Activity.png");
        fileNames.add("End.png");
        fileNames.add("Start.png");
        fileNames.add("FlowGraph.png");
        if (this.features.contains((Object)ExampleFeature.CONTAINERS)) {
            fileNames.add("Swimlane.png");
        }
        this.copyFiles(p, "example-icons", "icons", fileNames);
    }

    private void copyBranding(IProject p) {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add("Icon16.png");
        fileNames.add("Icon32.png");
        fileNames.add("Icon48.png");
        fileNames.add("Icon64.png");
        fileNames.add("Icon128.png");
        fileNames.add("splash.bmp");
        this.copyFiles(p, "example-branding", "branding", fileNames);
    }
}

