/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;

public class CincoWizardUtils {
    public static String validateModelName(String modelName) {
        if (!modelName.isEmpty()) {
            IStatus nameStatus = JavaConventions.validateIdentifier((String)modelName, (String)"1.7", (String)"1.7");
            if (nameStatus.getCode() != 0) {
                return "Model Name: " + nameStatus.getMessage();
            }
            if (!Character.isUpperCase(modelName.charAt(0))) {
                return "Model Name: must start with capital letter";
            }
        } else {
            return "Model Name: must not be empty";
        }
        return null;
    }

    public static String validatePackageName(String packageName) {
        if (!packageName.isEmpty()) {
            IStatus nameStatus = JavaConventions.validatePackageName((String)packageName, (String)"1.7", (String)"1.7");
            if (nameStatus.getCode() != 0) {
                return "Package Name: " + nameStatus.getMessage();
            }
        } else {
            return "Package Name: must not be empty";
        }
        return null;
    }

    public static String validateProjectName(String projectName) {
        IProject[] projects;
        if (projectName.isEmpty()) {
            return "Enter project name";
        }
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (p.getName().equals(projectName)) {
                return "Project: " + projectName + " already exists";
            }
            ++n2;
        }
        if (projectName.matches(".*[:/\\\\\"&<>\\?#,;].*")) {
            return "The project name contains illegal characters (:/\"&<>?#,;)";
        }
        if (!projectName.toLowerCase().equals(projectName)) {
            return "Project/Package Name: must not contain upper case letters";
        }
        return null;
    }
}

