/*
 * Decompiled with CFR 0.152.
 */
package mgl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EdgeDirection implements Enumerator
{
    NODIRECTION(0, "NODIRECTION", "NODIRECTION"),
    UNDIRECTED(1, "Undirected", "Undirected"),
    SOURCE_DIRECTED(2, "SourceDirected", "SourceDirected"),
    TARGET_DIRECTED(3, "TargetDirected", "TargetDirected"),
    BIDIRECTED(4, "Bidirected", "Bidirected");

    public static final int NODIRECTION_VALUE = 0;
    public static final int UNDIRECTED_VALUE = 1;
    public static final int SOURCE_DIRECTED_VALUE = 2;
    public static final int TARGET_DIRECTED_VALUE = 3;
    public static final int BIDIRECTED_VALUE = 4;
    private static final EdgeDirection[] VALUES_ARRAY;
    public static final List<EdgeDirection> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EdgeDirection[]{NODIRECTION, UNDIRECTED, SOURCE_DIRECTED, TARGET_DIRECTED, BIDIRECTED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EdgeDirection get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EdgeDirection result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EdgeDirection getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EdgeDirection result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EdgeDirection get(int value) {
        switch (value) {
            case 0: {
                return NODIRECTION;
            }
            case 1: {
                return UNDIRECTED;
            }
            case 2: {
                return SOURCE_DIRECTED;
            }
            case 3: {
                return TARGET_DIRECTED;
            }
            case 4: {
                return BIDIRECTED;
            }
        }
        return null;
    }

    private EdgeDirection(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

