/*
 * Decompiled with CFR 0.152.
 */
package graphmodel.internal.impl;

import de.jabc.cinco.meta.core.mgl.model.constraints.ConnectionConstraint;
import graphmodel.Edge;
import graphmodel.Node;
import graphmodel.internal.InternalEdge;
import graphmodel.internal.InternalNode;
import graphmodel.internal.InternalPackage;
import graphmodel.internal.impl.InternalModelElementImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class InternalNodeImpl
extends InternalModelElementImpl
implements InternalNode {
    protected static final int X_EDEFAULT = -1;
    protected int x = -1;
    protected static final int Y_EDEFAULT = -1;
    protected int y = -1;
    protected static final int HEIGHT_EDEFAULT = -1;
    protected int height = -1;
    protected static final int WIDTH_EDEFAULT = -1;
    protected int width = -1;
    protected EList<InternalEdge> incoming;
    protected EList<InternalEdge> outgoing;

    protected InternalNodeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return InternalPackage.Literals.INTERNAL_NODE;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int newX) {
        int oldX = this.x;
        this.x = newX;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldX, this.x));
        }
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int newY) {
        int oldY = this.y;
        this.y = newY;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldY, this.y));
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int newHeight) {
        int oldHeight = this.height;
        this.height = newHeight;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldHeight, this.height));
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int newWidth) {
        int oldWidth = this.width;
        this.width = newWidth;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldWidth, this.width));
        }
    }

    @Override
    public EList<InternalEdge> getIncoming() {
        if (this.incoming == null) {
            this.incoming = new EObjectWithInverseResolvingEList(InternalEdge.class, (InternalEObject)this, 7, 4);
        }
        return this.incoming;
    }

    @Override
    public EList<InternalEdge> getOutgoing() {
        if (this.outgoing == null) {
            this.outgoing = new EObjectWithInverseResolvingEList(InternalEdge.class, (InternalEObject)this, 8, 3);
        }
        return this.outgoing;
    }

    @Override
    public <M extends InternalNode> EList<M> getSuccessors() {
        EList<InternalNode> m = this.getSuccessors(InternalNode.class);
        return m;
    }

    @Override
    public <T extends InternalNode> EList<T> getSuccessors(Class<T> clazz) {
        BasicEList list = new BasicEList();
        if (clazz != null) {
            for (InternalEdge e : this.getOutgoing()) {
                if (!clazz.isInstance(e.get_targetElement())) continue;
                list.add((Object)((InternalNode)clazz.cast(e.get_targetElement())));
            }
        } else {
            throw new NullPointerException("Class must not be null.");
        }
        return ECollections.unmodifiableEList((EList)list);
    }

    @Override
    public <M extends InternalNode> EList<M> getPredecessors() {
        EList<InternalNode> m = this.getPredecessors(InternalNode.class);
        return m;
    }

    @Override
    public <T extends InternalNode> EList<T> getPredecessors(Class<T> clazz) {
        BasicEList list = new BasicEList();
        if (clazz != null) {
            for (InternalEdge e : this.getIncoming()) {
                if (!clazz.isInstance(e.get_sourceElement())) continue;
                list.add((Object)((InternalNode)clazz.cast(e.get_sourceElement())));
            }
        } else {
            throw new NullPointerException("Class must not be null.");
        }
        return ECollections.unmodifiableEList((EList)list);
    }

    @Override
    public <T extends Edge> EList<T> getIncoming(Class<T> clazz) {
        BasicEList list = new BasicEList();
        if (clazz != null) {
            for (InternalEdge e : this.getIncoming()) {
                if (!clazz.isInstance(e)) continue;
                list.add((Object)((Edge)clazz.cast(e)));
            }
        } else {
            throw new NullPointerException("Class must not be null.");
        }
        return ECollections.unmodifiableEList((EList)list);
    }

    @Override
    public <T extends InternalEdge> EList<T> getOutgoing(Class<T> clazz) {
        BasicEList list = new BasicEList();
        if (clazz != null) {
            for (InternalEdge e : this.getOutgoing()) {
                if (!clazz.isInstance(e)) continue;
                list.add((Object)((InternalEdge)clazz.cast(e)));
            }
        } else {
            throw new NullPointerException("Class must not be null.");
        }
        return ECollections.unmodifiableEList((EList)list);
    }

    @Override
    public boolean canConnect(Edge with, Node to) {
        return this.canStart(with.getClass()) && to.canEnd(with.getClass());
    }

    @Override
    public EList<ConnectionConstraint> getOutgoingConstraints() {
        return new BasicEList();
    }

    @Override
    public EList<ConnectionConstraint> getIncomingConstraints() {
        return new BasicEList();
    }

    @Override
    public boolean canStart(Class<? extends Edge> edgeType) {
        EList<ConnectionConstraint> outConstraints = this.getOutgoingConstraints();
        long constraintCount = outConstraints.stream().filter(c -> c.isInEdges(edgeType)).count();
        return constraintCount > 0L && outConstraints.stream().filter(c -> c.isInEdges(edgeType)).allMatch(c -> c.canConnect((Node)this.getElement(), edgeType));
    }

    @Override
    public boolean canEnd(Class<? extends Edge> edgeType) {
        EList<ConnectionConstraint> inConstraints = this.getIncomingConstraints();
        long constraintCount = inConstraints.stream().filter(c -> c.isInEdges(edgeType)).count();
        return constraintCount > 0L && inConstraints.stream().filter(c -> c.isInEdges(edgeType)).allMatch(c -> c.canConnect((Node)this.getElement(), edgeType));
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return ((InternalEList)this.getIncoming()).basicAdd((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getOutgoing()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return ((InternalEList)this.getIncoming()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getOutgoing()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getX();
            }
            case 4: {
                return this.getY();
            }
            case 5: {
                return this.getHeight();
            }
            case 6: {
                return this.getWidth();
            }
            case 7: {
                return this.getIncoming();
            }
            case 8: {
                return this.getOutgoing();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setX((Integer)newValue);
                return;
            }
            case 4: {
                this.setY((Integer)newValue);
                return;
            }
            case 5: {
                this.setHeight((Integer)newValue);
                return;
            }
            case 6: {
                this.setWidth((Integer)newValue);
                return;
            }
            case 7: {
                this.getIncoming().clear();
                this.getIncoming().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getOutgoing().clear();
                this.getOutgoing().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setX(-1);
                return;
            }
            case 4: {
                this.setY(-1);
                return;
            }
            case 5: {
                this.setHeight(-1);
                return;
            }
            case 6: {
                this.setWidth(-1);
                return;
            }
            case 7: {
                this.getIncoming().clear();
                return;
            }
            case 8: {
                this.getOutgoing().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.x != -1;
            }
            case 4: {
                return this.y != -1;
            }
            case 5: {
                return this.height != -1;
            }
            case 6: {
                return this.width != -1;
            }
            case 7: {
                return this.incoming != null && !this.incoming.isEmpty();
            }
            case 8: {
                return this.outgoing != null && !this.outgoing.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 5: {
                return this.getSuccessors();
            }
            case 6: {
                return this.getSuccessors((Class)arguments.get(0));
            }
            case 7: {
                return this.getPredecessors();
            }
            case 8: {
                return this.getPredecessors((Class)arguments.get(0));
            }
            case 9: {
                return this.getIncoming((Class)arguments.get(0));
            }
            case 10: {
                return this.getOutgoing((Class)arguments.get(0));
            }
            case 11: {
                return this.canConnect((Edge)arguments.get(0), (Node)arguments.get(1));
            }
            case 12: {
                return this.getOutgoingConstraints();
            }
            case 13: {
                return this.getIncomingConstraints();
            }
            case 14: {
                return this.canStart((Class)arguments.get(0));
            }
            case 15: {
                return this.canEnd((Class)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (x: ");
        result.append(this.x);
        result.append(", y: ");
        result.append(this.y);
        result.append(", height: ");
        result.append(this.height);
        result.append(", width: ");
        result.append(this.width);
        result.append(')');
        return result.toString();
    }
}

