/*
 * Decompiled with CFR 0.152.
 */
package graphmodel.impl;

import de.jabc.cinco.meta.core.mgl.model.constraints.ConnectionConstraint;
import graphmodel.Direction;
import graphmodel.Edge;
import graphmodel.GraphmodelPackage;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import graphmodel.impl.ModelElementImpl;
import graphmodel.internal.InternalEdge;
import graphmodel.internal.InternalNode;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class NodeImpl
extends ModelElementImpl
implements Node {
    protected NodeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return GraphmodelPackage.Literals.NODE;
    }

    @Override
    public <M extends Node> EList<M> getSuccessors() {
        EList iSucc = ((InternalNode)this.getInternalElement_()).getSuccessors();
        List collect = iSucc.stream().map(iNode -> (Node)iNode.getElement()).collect(Collectors.toList());
        BasicEList successors = new BasicEList(collect);
        return successors;
    }

    @Override
    public <T extends Node> EList<T> getSuccessors(Class<T> clazz) {
        List successors = ((InternalNode)this.getInternalElement_()).getSuccessors().stream().map(me -> me.getElement()).filter(me -> clazz.isAssignableFrom(((Node)me).getClass())).collect(Collectors.toList());
        BasicEList retval = new BasicEList();
        retval.addAll(successors);
        return retval;
    }

    @Override
    public <M extends Node> EList<M> getPredecessors() {
        EList iSucc = ((InternalNode)this.getInternalElement_()).getPredecessors();
        List collect = iSucc.stream().map(iNode -> (Node)iNode.getElement()).collect(Collectors.toList());
        BasicEList successors = new BasicEList(collect);
        return successors;
    }

    @Override
    public <T extends Node> EList<T> getPredecessors(Class<T> clazz) {
        List successors = ((InternalNode)this.getInternalElement_()).getPredecessors().stream().map(me -> me.getElement()).filter(me -> clazz.isAssignableFrom(((Node)me).getClass())).collect(Collectors.toList());
        BasicEList retval = new BasicEList();
        retval.addAll(successors);
        return retval;
    }

    @Override
    public <T extends Edge> EList<T> getIncoming(Class<T> clazz) {
        List it = ((InternalNode)this.getInternalElement_()).getIncoming().stream().filter(iNode -> clazz.isInstance(iNode.getElement())).map(iNode -> (Edge)clazz.cast(iNode.getElement())).collect(Collectors.toList());
        BasicEList bl = new BasicEList();
        bl.addAll(it);
        return bl;
    }

    @Override
    public <T extends Edge> EList<T> getOutgoing(Class<T> clazz) {
        List it = ((InternalNode)this.getInternalElement_()).getOutgoing().stream().filter(iNode -> clazz.isInstance(iNode.getElement())).map(iNode -> (Edge)clazz.cast(iNode.getElement())).collect(Collectors.toList());
        BasicEList bl = new BasicEList();
        bl.addAll(it);
        return bl;
    }

    @Override
    public boolean canConnect(Edge with, Node to) {
        return this.canStart(with.getClass()) && to.canEnd(with.getClass());
    }

    @Override
    public EList<ConnectionConstraint> getOutgoingConstraints() {
        return ((InternalNode)this.getInternalElement_()).getOutgoingConstraints();
    }

    @Override
    public EList<ConnectionConstraint> getIncomingConstraints() {
        return ((InternalNode)this.getInternalElement_()).getIncomingConstraints();
    }

    @Override
    public boolean canStart(Class<? extends Edge> edgeType) {
        return ((InternalNode)this.getInternalElement_()).canStart(edgeType);
    }

    @Override
    public boolean canEnd(Class<? extends Edge> edgeType) {
        return ((InternalNode)this.getInternalElement_()).canEnd(edgeType);
    }

    @Override
    public void move(int x, int y) {
        this.transact("Move", () -> {
            InternalNode ime = (InternalNode)this.getInternalElement_();
            int deltaX = x - ime.getX();
            int deltaY = y - ime.getY();
            if (deltaX != 0 || deltaY != 0) {
                this.preMove(this.getContainer(), x, y);
            }
            if (deltaX != 0) {
                ime.setX(x);
            }
            if (deltaY != 0) {
                ime.setY(y);
            }
            if (deltaX != 0 || deltaY != 0) {
                this.postMove(this.getContainer(), this.getContainer(), x, y, deltaX, deltaY);
            }
        });
    }

    @Override
    public void resize(int width, int height) {
        this.resize(width, height, this.getX(), this.getY());
    }

    @Override
    public void resize(int width, int height, int x, int y) {
        this.transact("Resize", () -> {
            InternalNode ime = (InternalNode)this.getInternalElement_();
            int oldWidth = ime.getWidth();
            int oldHeight = ime.getHeight();
            int oldX = ime.getX();
            int oldY = ime.getY();
            if (width != oldWidth || height != oldHeight || x != oldX || y != oldY) {
                boolean east;
                boolean north = oldY - y == 0;
                boolean west = oldX - x == 0;
                boolean south = height - oldHeight - (oldY - y) == 0;
                boolean bl = east = width - oldWidth - (oldX - x) == 0;
                Direction direction = !north && east && south && west ? Direction.NORTH : (!north && !east && south && west ? Direction.NORTH_EAST : (north && !east && south && west ? Direction.EAST : (north && !east && !south && west ? Direction.SOUTH_EAST : (north && east && !south && west ? Direction.SOUTH : (north && east && !south && !west ? Direction.SOUTH_WEST : (north && east && south && !west ? Direction.WEST : (!north && east && south && !west ? Direction.NORTH_WEST : Direction.UNSPECIFIED)))))));
                this.preResize(width, height, x, y, direction);
                if (width != oldWidth) {
                    ime.setWidth(width);
                }
                if (height != oldHeight) {
                    ime.setHeight(height);
                }
                if (x != oldX) {
                    ime.setX(x);
                }
                if (y != oldY) {
                    ime.setY(y);
                }
                this.postResize(oldWidth, oldHeight, oldX, oldY, direction);
                this.update();
            }
        });
    }

    @Override
    public void preMove(ModelElementContainer newContainer, int newX, int newY) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void postMove(ModelElementContainer source, ModelElementContainer target, int x, int y, int deltaX, int deltaY) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete() {
        this.preDelete();
        Runnable postDeleteFunction = this.getPostDeleteFunction();
        Runnable postDeleteEvent = this.getPostDeleteEvent();
        HashSet<Edge> allEdges = new HashSet<Edge>();
        allEdges.addAll((Collection<Edge>)this.getUntypedIncoming());
        allEdges.addAll((Collection<Edge>)this.getUntypedOutgoing());
        for (Edge edge : allEdges) {
            edge.delete();
        }
        if (this.getInternalElement_() == null) {
            return;
        }
        this.transact("Delete", () -> {
            EcoreUtil.delete((EObject)this.getInternalElement_());
            EcoreUtil.delete((EObject)this);
        });
        postDeleteFunction.run();
        postDeleteEvent.run();
    }

    @Override
    public Runnable getPostDeleteFunction() {
        return () -> {};
    }

    @Override
    public Runnable getPostDeleteEvent() {
        return () -> {};
    }

    @Override
    public void preDelete() {
    }

    @Override
    public boolean canMoveTo(ModelElementContainer targetContainer) {
        return targetContainer.canContain(this.getClass());
    }

    @Override
    public void moveTo(ModelElementContainer targetContainer, int x, int y) {
        this.transact("Move to", () -> {
            ModelElementContainer sourceContainer = this.getContainer();
            InternalNode ime = (InternalNode)this.getInternalElement_();
            int deltaX = x - ime.getX();
            int deltaY = y - ime.getY();
            this.preMove(targetContainer, x, y);
            this.s_moveTo(targetContainer, x, y);
            targetContainer.getInternalContainerElement().getModelElements().add((Object)ime);
            ime.setX(x);
            ime.setY(y);
            this.postMove(sourceContainer, targetContainer, x, y, deltaX, deltaY);
        });
    }

    @Override
    public boolean canClone(ModelElementContainer targetContainer) {
        return targetContainer.canContain(this.getClass());
    }

    @Override
    public <T extends Node> T clone(ModelElementContainer targetContainer) {
        InternalNode copy = (InternalNode)EcoreUtil.copy((EObject)this.getInternalElement_());
        EcoreUtil.setID((EObject)copy, (String)this.getInternalElement_().getId());
        EcoreUtil.setID((EObject)copy.getElement(), (String)this.getId());
        targetContainer.getInternalContainerElement().getModelElements().add((Object)copy);
        Node t = (Node)copy.getElement();
        return (T)t;
    }

    @Override
    public int getX() {
        return ((InternalNode)this.getInternalElement_()).getX();
    }

    @Override
    public int getY() {
        return ((InternalNode)this.getInternalElement_()).getY();
    }

    @Override
    public int getWidth() {
        return ((InternalNode)this.getInternalElement_()).getWidth();
    }

    @Override
    public int getHeight() {
        return ((InternalNode)this.getInternalElement_()).getHeight();
    }

    @Override
    public <T extends Node> T copy(ModelElementContainer targetContainer) {
        InternalNode copy = (InternalNode)EcoreUtil.copy((EObject)this.getInternalElement_());
        EcoreUtil.setID((EObject)copy, (String)EcoreUtil.generateUUID());
        targetContainer.getInternalContainerElement().getModelElements().add((Object)copy);
        Node t = (Node)copy.getElement();
        return (T)t;
    }

    @Override
    public void setX(int x) {
        this.transact("Set x", () -> ((InternalNode)this.getInternalElement_()).setX(x));
    }

    @Override
    public void setY(int y) {
        this.transact("Set Y", () -> ((InternalNode)this.getInternalElement_()).setY(y));
    }

    @Override
    public void setWidth(int width) {
        this.transact("Set width", () -> ((InternalNode)this.getInternalElement_()).setWidth(width));
    }

    @Override
    public void setHeight(int height) {
        this.transact("Set height", () -> ((InternalNode)this.getInternalElement_()).setHeight(height));
    }

    @Override
    public void preResize(int newWidth, int newHeight, int newX, int newY, Direction direction) {
    }

    @Override
    public void postResize(int oldWidth, int oldHeight, int oldX, int oldY, Direction direction) {
    }

    @Override
    public int getLayer() {
        return this.getContainer().getModelElements().indexOf((Object)this);
    }

    @Override
    public void s_moveTo(ModelElementContainer targetContainer, int x, int y) {
    }

    @Override
    public <T extends Edge> EList<T> getIncoming() {
        return this.getIncoming(Edge.class);
    }

    @Override
    public <T extends Edge> EList<T> getOutgoing() {
        return this.getOutgoing(Edge.class);
    }

    @Override
    public EList<Edge> getUntypedIncoming() {
        EList<InternalEdge> in = ((InternalNode)this.getInternalElement_()).getIncoming();
        return ECollections.unmodifiableEList(in.stream().map(me -> (Edge)me.getElement()).collect(Collectors.toList()));
    }

    @Override
    public EList<Edge> getUntypedOutgoing() {
        EList<InternalEdge> out = ((InternalNode)this.getInternalElement_()).getOutgoing();
        return ECollections.unmodifiableEList(out.stream().map(me -> (Edge)me.getElement()).collect(Collectors.toList()));
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 12: {
                return this.getSuccessors();
            }
            case 13: {
                return this.getSuccessors((Class)arguments.get(0));
            }
            case 14: {
                return this.getPredecessors();
            }
            case 15: {
                return this.getPredecessors((Class)arguments.get(0));
            }
            case 16: {
                return this.getIncoming((Class)arguments.get(0));
            }
            case 17: {
                return this.getOutgoing((Class)arguments.get(0));
            }
            case 18: {
                return this.canConnect((Edge)arguments.get(0), (Node)arguments.get(1));
            }
            case 19: {
                return this.getOutgoingConstraints();
            }
            case 20: {
                return this.getIncomingConstraints();
            }
            case 21: {
                return this.canStart((Class)arguments.get(0));
            }
            case 22: {
                return this.canEnd((Class)arguments.get(0));
            }
            case 23: {
                this.move((Integer)arguments.get(0), (Integer)arguments.get(1));
                return null;
            }
            case 24: {
                this.resize((Integer)arguments.get(0), (Integer)arguments.get(1));
                return null;
            }
            case 25: {
                this.resize((Integer)arguments.get(0), (Integer)arguments.get(1), (Integer)arguments.get(2), (Integer)arguments.get(3));
                return null;
            }
            case 26: {
                this.preMove((ModelElementContainer)arguments.get(0), (Integer)arguments.get(1), (Integer)arguments.get(2));
                return null;
            }
            case 27: {
                this.postMove((ModelElementContainer)arguments.get(0), (ModelElementContainer)arguments.get(1), (Integer)arguments.get(2), (Integer)arguments.get(3), (Integer)arguments.get(4), (Integer)arguments.get(5));
                return null;
            }
            case 28: {
                this.delete();
                return null;
            }
            case 29: {
                return this.getPostDeleteFunction();
            }
            case 30: {
                return this.getPostDeleteEvent();
            }
            case 31: {
                this.preDelete();
                return null;
            }
            case 32: {
                return this.canMoveTo((ModelElementContainer)arguments.get(0));
            }
            case 33: {
                this.moveTo((ModelElementContainer)arguments.get(0), (Integer)arguments.get(1), (Integer)arguments.get(2));
                return null;
            }
            case 34: {
                return this.canClone((ModelElementContainer)arguments.get(0));
            }
            case 35: {
                return this.clone((ModelElementContainer)arguments.get(0));
            }
            case 36: {
                return this.getX();
            }
            case 37: {
                return this.getY();
            }
            case 38: {
                return this.getWidth();
            }
            case 39: {
                return this.getHeight();
            }
            case 40: {
                return this.copy((ModelElementContainer)arguments.get(0));
            }
            case 41: {
                this.setX((Integer)arguments.get(0));
                return null;
            }
            case 42: {
                this.setY((Integer)arguments.get(0));
                return null;
            }
            case 43: {
                this.setWidth((Integer)arguments.get(0));
                return null;
            }
            case 44: {
                this.setHeight((Integer)arguments.get(0));
                return null;
            }
            case 45: {
                this.preResize((Integer)arguments.get(0), (Integer)arguments.get(1), (Integer)arguments.get(2), (Integer)arguments.get(3), (Direction)((Object)arguments.get(4)));
                return null;
            }
            case 46: {
                this.postResize((Integer)arguments.get(0), (Integer)arguments.get(1), (Integer)arguments.get(2), (Integer)arguments.get(3), (Direction)((Object)arguments.get(4)));
                return null;
            }
            case 47: {
                return this.getLayer();
            }
            case 48: {
                this.s_moveTo((ModelElementContainer)arguments.get(0), (Integer)arguments.get(1), (Integer)arguments.get(2));
                return null;
            }
            case 49: {
                return this.getIncoming();
            }
            case 50: {
                return this.getOutgoing();
            }
            case 51: {
                return this.getUntypedIncoming();
            }
            case 52: {
                return this.getUntypedOutgoing();
            }
        }
        return super.eInvoke(operationID, arguments);
    }
}

