/*
 * Decompiled with CFR 0.152.
 */
package graphmodel.impl;

import graphmodel.Container;
import graphmodel.Edge;
import graphmodel.GraphModel;
import graphmodel.GraphmodelPackage;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalModelElementContainer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public abstract class ModelElementContainerImpl
extends EObjectImpl
implements ModelElementContainer {
    protected static final String ID_EDEFAULT = "";
    protected String id = "";

    protected ModelElementContainerImpl() {
    }

    protected EClass eStaticClass() {
        return GraphmodelPackage.Literals.MODEL_ELEMENT_CONTAINER;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        String oldId = this.id;
        this.id = newId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldId, (Object)this.id));
        }
    }

    @Override
    public <T extends ModelElement> EList<T> getModelElements(Class<T> clazz) {
        BasicEList list = new BasicEList();
        if (clazz != null) {
            for (ModelElement e : this.getModelElements()) {
                if (!clazz.isInstance(e)) continue;
                list.add((Object)((ModelElement)clazz.cast(e)));
            }
        } else {
            throw new NullPointerException("Class must not be null.");
        }
        return ECollections.unmodifiableEList((EList)list);
    }

    @Override
    public EList<Node> getAllNodes() {
        return this.getModelElements(Node.class);
    }

    @Override
    public EList<Edge> getAllEdges() {
        return this.getModelElements(Edge.class);
    }

    @Override
    public EList<Container> getAllContainers() {
        return this.getModelElements(Container.class);
    }

    @Override
    public boolean canContain(EList<Class<? extends Node>> nodes) {
        return this.getInternalContainerElement().canContain(nodes);
    }

    @Override
    public boolean canContain(Class<? extends Node> node) {
        return this.getInternalContainerElement().canContain(node);
    }

    @Override
    public EList<Class<? extends Node>> getContainableTypes() {
        GraphModel rootGraphModel = null;
        if (this instanceof GraphModel) {
            rootGraphModel = (GraphModel)((Object)this);
        } else if (this instanceof Container) {
            rootGraphModel = ((Container)((Object)this)).getRootElement();
        }
        if (this.getInternalContainerElement().getContainmentConstraints().size() > 0) {
            return new BasicEList((Collection)rootGraphModel.getAllNodeTypes().stream().filter(n -> this.canContain((Class<? extends Node>)n)).collect(Collectors.toList()));
        }
        return rootGraphModel.getAllNodeTypes();
    }

    @Override
    public EList<ModelElement> getModelElements() {
        BasicEList bel = new BasicEList();
        bel.addAll((Collection)this.getInternalContainerElement().getModelElements().stream().map(me -> me.getElement()).collect(Collectors.toList()));
        return bel;
    }

    @Override
    public InternalModelElementContainer getInternalContainerElement() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Edge> EList<T> getEdges(Class<T> clazz) {
        BasicEList list = new BasicEList();
        if (clazz != null) {
            for (ModelElement e : this.getModelElements()) {
                if (!clazz.isInstance(e)) continue;
                list.add((Object)((Edge)clazz.cast(e)));
            }
        } else {
            throw new NullPointerException("Class must not be null.");
        }
        return ECollections.unmodifiableEList((EList)list);
    }

    @Override
    public <T extends Node> EList<T> getNodes(Class<T> clazz) {
        BasicEList list = new BasicEList();
        if (clazz != null) {
            for (ModelElement e : this.getModelElements()) {
                if (!clazz.isInstance(e)) continue;
                list.add((Object)((Node)clazz.cast(e)));
            }
        } else {
            throw new NullPointerException("Class must not be null.");
        }
        return ECollections.unmodifiableEList((EList)list);
    }

    @Override
    public void updateModelElements() {
        for (ModelElement me : this.getModelElements()) {
            me.update();
            if (!(me instanceof ModelElementContainer)) continue;
            ((ModelElementContainer)((Object)me)).updateModelElements();
        }
    }

    @Override
    public <T extends Node> EList<T> getNodes() {
        return this.getNodes(Node.class);
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj == this || obj instanceof IdentifiableElement && ((IdentifiableElement)obj).getId() != null && ((IdentifiableElement)obj).getId().equals(this.getId()) && obj.getClass().getName().equals(this.getClass().getName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getId(), this.getClass().getName());
    }

    @Override
    public void save() {
        try {
            this.preSave();
            this.eResource().save(null);
            this.postSave();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public InternalIdentifiableElement getInternalElement_() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void preSave() {
    }

    @Override
    public void postSave() {
    }

    @Override
    public void transact(String label, final Runnable runnable) {
        TransactionalEditingDomain.Factory factory = TransactionalEditingDomain.Factory.INSTANCE;
        Resource res = this.getInternalElement_().eResource();
        TransactionalEditingDomain dom = res == null ? factory.createEditingDomain() : TransactionUtil.getEditingDomain((Resource)res);
        if (dom == null) {
            dom = res.getResourceSet() != null ? factory.createEditingDomain(res.getResourceSet()) : factory.createEditingDomain();
        }
        if (dom != null) {
            dom.getCommandStack().execute((Command)new RecordingCommand(dom, label){

                protected void doExecute() {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getId();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setId((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setId(ID_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return ID_EDEFAULT == null ? this.id != null : !ID_EDEFAULT.equals(this.id);
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 7: {
                return this.getModelElements((Class)arguments.get(0));
            }
            case 8: {
                return this.getAllNodes();
            }
            case 9: {
                return this.getAllEdges();
            }
            case 10: {
                return this.getAllContainers();
            }
            case 11: {
                return this.canContain((EList<Class<? extends Node>>)((EList)arguments.get(0)));
            }
            case 12: {
                return this.canContain((Class)arguments.get(0));
            }
            case 13: {
                return this.getContainableTypes();
            }
            case 14: {
                return this.getModelElements();
            }
            case 15: {
                return this.getInternalContainerElement();
            }
            case 16: {
                return this.getEdges((Class)arguments.get(0));
            }
            case 17: {
                return this.getNodes((Class)arguments.get(0));
            }
            case 18: {
                this.updateModelElements();
                return null;
            }
            case 19: {
                return this.getNodes();
            }
            case 0: {
                return this.equals(arguments.get(0));
            }
            case 1: {
                return this.hashCode();
            }
            case 2: {
                this.save();
                return null;
            }
            case 3: {
                return this.getInternalElement_();
            }
            case 4: {
                this.preSave();
                return null;
            }
            case 5: {
                this.postSave();
                return null;
            }
            case 6: {
                this.transact((String)arguments.get(0), (Runnable)arguments.get(1));
                return null;
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (id: ");
        result.append(this.id);
        result.append(')');
        return result.toString();
    }
}

