/*
 * Decompiled with CFR 0.152.
 */
package graphmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Direction implements Enumerator
{
    NORTH(0, "NORTH", "NORTH"),
    NORTH_EAST(1, "NORTH_EAST", "NORTH_EAST"),
    EAST(2, "EAST", "EAST"),
    SOUTH_EAST(3, "SOUTH_EAST", "SOUTH_EAST"),
    SOUTH(4, "SOUTH", "SOUTH"),
    SOUTH_WEST(5, "SOUTH_WEST", "SOUTH_WEST"),
    WEST(6, "WEST", "WEST"),
    NORTH_WEST(7, "NORTH_WEST", "NORTH_WEST"),
    UNSPECIFIED(8, "UNSPECIFIED", "UNSPECIFIED");

    public static final int NORTH_VALUE = 0;
    public static final int NORTH_EAST_VALUE = 1;
    public static final int EAST_VALUE = 2;
    public static final int SOUTH_EAST_VALUE = 3;
    public static final int SOUTH_VALUE = 4;
    public static final int SOUTH_WEST_VALUE = 5;
    public static final int WEST_VALUE = 6;
    public static final int NORTH_WEST_VALUE = 7;
    public static final int UNSPECIFIED_VALUE = 8;
    private static final Direction[] VALUES_ARRAY;
    public static final List<Direction> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Direction[]{NORTH, NORTH_EAST, EAST, SOUTH_EAST, SOUTH, SOUTH_WEST, WEST, NORTH_WEST, UNSPECIFIED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Direction get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Direction result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Direction getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Direction result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Direction get(int value) {
        switch (value) {
            case 0: {
                return NORTH;
            }
            case 1: {
                return NORTH_EAST;
            }
            case 2: {
                return EAST;
            }
            case 3: {
                return SOUTH_EAST;
            }
            case 4: {
                return SOUTH;
            }
            case 5: {
                return SOUTH_WEST;
            }
            case 6: {
                return WEST;
            }
            case 7: {
                return NORTH_WEST;
            }
            case 8: {
                return UNSPECIFIED;
            }
        }
        return null;
    }

    private Direction(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

