/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.mgl.model.constraints;

import graphmodel.ModelElementContainer;
import graphmodel.Node;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;

public class ContainmentConstraint {
    private int lowerBound;
    private int upperBound;
    private List<Class<? extends Node>> types;

    @SafeVarargs
    public ContainmentConstraint(int lowerBound, int upperBound, Class<? extends Node> ... types) {
        this.types = Arrays.asList(types);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound != -1 ? upperBound : Integer.MAX_VALUE;
    }

    public boolean checkUpperBound(ModelElementContainer container) {
        int sum = this.sumMatchingElementsInContainer(container);
        return sum <= this.upperBound;
    }

    public boolean checkLowerBound(ModelElementContainer container) {
        int sum = this.sumMatchingElementsInContainer(container);
        return sum >= this.lowerBound;
    }

    public boolean checkConstraint(ModelElementContainer container) {
        int sum = this.sumMatchingElementsInContainer(container);
        return sum >= this.lowerBound && sum <= this.upperBound;
    }

    public boolean violationAfterInsert(Class<? extends Node> toInsert, List<Class<? extends Node>> otherInsertedNodes, ModelElementContainer container) {
        if (this.isInTypes(toInsert)) {
            return this.sumMatchingElementsInContainer(container) + this.sumElementsByType(otherInsertedNodes) >= this.upperBound;
        }
        return true;
    }

    public boolean violationAfterInsert(Node toInsert, ModelElementContainer container) {
        if (this.isInstance(toInsert)) {
            return this.sumMatchingElementsInContainer(container) >= this.upperBound;
        }
        return true;
    }

    public boolean violationAfterDelete(ModelElementContainer container, List<Class<? extends Node>> nodes) {
        int suitableElementsSum = this.sumElementsByType(nodes);
        int containedElementsSum = this.sumMatchingElementsInContainer(container);
        return containedElementsSum - suitableElementsSum < this.lowerBound;
    }

    public int sumMatchingElementsInContainer(ModelElementContainer container) {
        int i = 0;
        for (Node n : container.getAllNodes()) {
            List<Class<?>> superNodes = this.getSuperNodes(n.eClass());
            if (!this.isInstance(n) && !superNodes.stream().anyMatch(sn -> this.isInTypes((Class<?>)sn))) continue;
            ++i;
        }
        return i;
    }

    private List<Class<?>> getSuperNodes(EClass n) {
        return n.getESuperTypes().stream().map(e -> e.getInstanceClass()).collect(Collectors.toList());
    }

    private int sumElementsByType(List<Class<? extends Node>> nodes) {
        int i = 0;
        for (Class<? extends Node> nodeClass : nodes) {
            if (!this.isInTypes(nodeClass)) continue;
            ++i;
        }
        return i;
    }

    private boolean isInstance(Node e) {
        return this.types.stream().anyMatch(nt -> nt.isAssignableFrom(e.getClass()));
    }

    public boolean isInTypes(Class<?> sn) {
        return this.types.stream().anyMatch(nt -> nt.isAssignableFrom(sn));
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public List<Class<? extends Node>> getTypes() {
        return this.types;
    }

    public Set<Class<? extends Node>> getContainables(ModelElementContainer container) {
        HashSet<Class<? extends Node>> containables = new HashSet<Class<? extends Node>>();
        if (this.sumMatchingElementsInContainer(container) < this.upperBound) {
            containables.addAll(this.getTypes());
        }
        return containables;
    }
}

