/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class TemplateGenerator {
    private String pkg = null;
    private String filename = null;
    private String templateFile = null;
    private String basePath = "src-gen";
    private Template template = null;
    private IProject project = null;
    private Map<String, Object> data = null;

    public String getPkg() {
        return this.pkg;
    }

    public void setPkg(String pkg) {
        this.pkg = pkg;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public TemplateGenerator(String templateFile, IProject project) {
        this.templateFile = templateFile;
        this.project = project;
    }

    public void generateFile() throws IOException, TemplateException {
        System.out.println("Generating " + this.filename + "...");
        this.template = this.loadTemplate();
        this.saveTemplate();
    }

    private Template loadTemplate() throws IOException {
        Bundle bundle = Platform.getBundle((String)"de.jabc.cinco.meta.plugin.mcam");
        InputStream in = FileLocator.openStream((Bundle)bundle, (IPath)new Path(this.templateFile), (boolean)true);
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        String firstTemplate = "myTemplate";
        stringLoader.putTemplate(firstTemplate, IOUtils.toString((InputStream)in, (String)"UTF-8"));
        Configuration cfg = new Configuration();
        cfg.setTemplateLoader((TemplateLoader)stringLoader);
        return cfg.getTemplate(firstTemplate);
    }

    private void saveTemplate() throws IOException, TemplateException {
        String targetFilePath = this.createFilePath();
        File fname = new File(targetFilePath);
        fname.getParentFile().mkdirs();
        fname.createNewFile();
        FileWriter file = new FileWriter(fname);
        this.template.process(this.data, (Writer)file);
        ((Writer)file).flush();
        ((Writer)file).close();
    }

    private String createFilePath() {
        String pPath = this.project.getLocation().toFile().toString();
        String sep = File.separator;
        String pkgAsPath = this.pkg.replace(".", sep);
        if (!this.basePath.equals("")) {
            this.basePath = String.valueOf(this.basePath) + sep;
        }
        return String.valueOf(pPath) + sep + this.basePath + pkgAsPath + sep + this.filename;
    }
}

