/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam;

import de.jabc.cinco.meta.core.pluginregistry.IMGLMetaPlugin;
import de.jabc.cinco.meta.core.utils.BundleRegistry;
import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;
import de.jabc.cinco.meta.plugin.mcam.McamImplementationGenerator;
import de.jabc.cinco.meta.plugin.mcam.McamViewGenerator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import mgl.Annotation;
import mgl.GraphModel;
import mgl.MGLModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import productDefinition.CincoProduct;

public class MetaPluginMcam
implements IMGLMetaPlugin {
    private GraphModel gModel;
    private MGLModel mglModel;
    private String modelPackage = null;
    private String modelProjectName = null;
    private String mcamPackageSuffix = McamImplementationGenerator.mcamPackageSuffix;
    private String mcamViewPackageSuffix = McamViewGenerator.viewPackageSuffix;
    private NullProgressMonitor monitor = new NullProgressMonitor();

    public void executeMGLMetaPlugin(List<Annotation> mglAnnotations, List<MGLModel> generatedMGLs, List<MGLModel> allMGLs, CincoProduct cpd, IProject mainProject) {
        for (MGLModel mgl : allMGLs) {
            for (GraphModel gm : mgl.getGraphModels()) {
                this.execute(mgl, gm);
            }
        }
    }

    public void execute(MGLModel mgl, GraphModel gm) {
        String result = "";
        BundleRegistry.INSTANCE.addBundle("de.jabc.cinco.meta.plugin.mcam", true);
        BundleRegistry.INSTANCE.addBundle("de.jabc.cinco.meta.plugin.mcam.runtime", false);
        this.mglModel = mgl;
        this.gModel = gm;
        System.out.println("------ Model-CaM Generation for '" + this.gModel.getName() + "' ------");
        this.modelPackage = this.mglModel.getPackage();
        String[] path = this.gModel.eResource().getURI().path().split("/");
        this.modelProjectName = path[2];
        IProject mcamProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.modelProjectName);
        if (mcamProject == null) {
            return;
        }
        McamImplementationGenerator genMcam = new McamImplementationGenerator(this.mglModel, this.gModel, mcamProject, this.modelPackage, this.modelProjectName);
        try {
            IFolder f = mcamProject.getFolder("src-gen/" + genMcam.getMcamProjectBasePackage().replace(".", "/"));
            if (f != null && f.exists()) {
                this.cleanDirectory(f);
            }
            mcamProject.refreshLocal(2, (IProgressMonitor)this.monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return;
        }
        result = genMcam.generate();
        System.out.println("Editing Manifest...");
        try {
            this.writeExportedPackagesToManifest(mcamProject, genMcam);
            this.writeRequiredBundlesToManifest(mcamProject, genMcam);
            mcamProject.refreshLocal(2, (IProgressMonitor)this.monitor);
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("Creating MCaM-View-Eclipse-Project...");
        IProject mcamViewProject = this.createMcamViewEclipseProject();
        McamViewGenerator genView = new McamViewGenerator(this.mglModel, this.gModel, mcamViewProject, this.modelPackage, this.modelProjectName, genMcam);
        try {
            IFolder f = mcamViewProject.getFolder("src-gen/" + genView.getMcamViewPackage().replace(".", "/"));
            if (f != null && f.exists()) {
                this.cleanDirectory(f);
            }
            mcamViewProject.refreshLocal(2, (IProgressMonitor)this.monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return;
        }
        result = genView.generate();
        try {
            mcamViewProject.refreshLocal(2, (IProgressMonitor)this.monitor);
            mcamViewProject.close((IProgressMonitor)this.monitor);
            mcamViewProject.open((IProgressMonitor)this.monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        System.out.println("----------------------------------");
    }

    private IProject createMcamViewEclipseProject() {
        String projectName = String.valueOf(this.modelProjectName) + "." + this.mcamPackageSuffix + "." + this.mcamViewPackageSuffix;
        List<String> srcFolders = this.getSrcFolders();
        List<String> cleanDirs = this.getCleanDirectory();
        Set<String> reqBundles = this.getReqBundlesForView();
        return ProjectCreator.createProject((String)projectName, srcFolders, null, reqBundles, null, null, (IProgressMonitor)this.monitor, cleanDirs, (boolean)false);
    }

    private void writeExportedPackagesToManifest(IProject project, McamImplementationGenerator genMcam) throws IOException, CoreException {
        IFile iManiFile = project.getFolder("META-INF").getFile("MANIFEST.MF");
        Manifest manifest = new Manifest(iManiFile.getContents());
        String exportPackage = (String)genMcam.data.get("AdapterPackage");
        exportPackage = String.valueOf(exportPackage) + "," + (String)genMcam.data.get("CliPackage");
        if (genMcam.doGenerateMerge()) {
            exportPackage = String.valueOf(exportPackage) + "," + (String)genMcam.data.get("ChangeModulePackage");
        }
        manifest.getMainAttributes().putValue("Export-Package", String.valueOf(this.cleanManifestAttribute(this.getManifestAttribute(project, "Export-Package"), genMcam.getMcamProjectBasePackage())) + exportPackage);
        manifest.write(new FileOutputStream(iManiFile.getLocation().toFile()));
    }

    private void writeRequiredBundlesToManifest(IProject project, McamImplementationGenerator genMcam) throws IOException, CoreException {
        IFile iManiFile = project.getFolder("META-INF").getFile("MANIFEST.MF");
        Manifest manifest = new Manifest(iManiFile.getContents());
        String exportPackage = "de.jabc.cinco.meta.plugin.mcam.runtime";
        manifest.getMainAttributes().putValue("Require-Bundle", String.valueOf(this.cleanManifestAttribute(this.getManifestAttribute(project, "Require-Bundle"), "de.jabc.cinco.meta.plugin.mcam.runtime")) + exportPackage);
        manifest.write(new FileOutputStream(iManiFile.getLocation().toFile()));
    }

    private String getManifestAttribute(IProject project, String attrName) throws IOException, CoreException {
        IFile iManiFile = project.getFolder("META-INF").getFile("MANIFEST.MF");
        if (!iManiFile.exists()) {
            return "";
        }
        Manifest manifest = new Manifest(iManiFile.getContents());
        return manifest.getMainAttributes().getValue(attrName);
    }

    private String cleanManifestAttribute(String values, String packagePrefixToClean) {
        String[] epEntries;
        String output = "";
        if (values == null) {
            return output;
        }
        String[] stringArray = epEntries = values.split(",");
        int n = epEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (!entry.startsWith(packagePrefixToClean) && !entry.equals("null") && entry.length() > 0) {
                output = String.valueOf(output) + entry + ",";
            }
            ++n2;
        }
        return output;
    }

    private void cleanDirectory(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            return;
        }
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFolder) {
                this.cleanDirectory((IFolder)res);
            }
            if (res instanceof IFile) {
                res.delete(true, (IProgressMonitor)this.monitor);
            }
            ++n2;
        }
        folder.delete(true, (IProgressMonitor)this.monitor);
    }

    private Set<String> getReqBundlesForView() {
        HashSet<String> reqBundles = new HashSet<String>();
        return reqBundles;
    }

    private List<String> getSrcFolders() {
        ArrayList<String> folders = new ArrayList<String>();
        folders.add("src");
        folders.add("src-gen");
        return folders;
    }

    private List<String> getCleanDirectory() {
        ArrayList<String> cleanDirs = new ArrayList<String>();
        return cleanDirs;
    }
}

