/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam;

import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.plugin.mcam.McamImplementationGenerator;
import de.jabc.cinco.meta.plugin.mcam.TemplateGenerator;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import mgl.Annotation;
import mgl.GraphModel;
import mgl.MGLModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;

public class McamViewGenerator {
    public static String viewPackageSuffix = "views";
    public static String pagePackageSuffix = "pages";
    private String mglName = null;
    private GraphModel gModel;
    private String graphModelName = null;
    private IProject mcamViewProject = null;
    private String mcamViewBasePackage = null;
    private String mcamProjectBasePackage = null;
    private String graphModelProjectName = null;
    private String graphModelPackage = null;
    private boolean generateMerge = false;
    private boolean generateCheck = false;
    public Map<String, Object> data = new HashMap<String, Object>();

    public McamViewGenerator(MGLModel mglModel, GraphModel gModel, IProject project, String graphModelPackage, String graphModelProjectName, McamImplementationGenerator genMcam) {
        this.gModel = gModel;
        this.graphModelName = gModel.getName();
        GeneratorUtils gu = GeneratorUtils.getInstance();
        this.mglName = gu.getFileName(mglModel);
        this.graphModelProjectName = graphModelProjectName;
        this.graphModelPackage = graphModelPackage;
        this.mcamViewProject = project;
        this.mcamProjectBasePackage = genMcam.getMcamProjectBasePackage();
        this.mcamViewBasePackage = String.valueOf(graphModelProjectName) + "." + McamImplementationGenerator.mcamPackageSuffix + "." + viewPackageSuffix;
        this.parseAnnotations();
        this.data.put("MGLModelName", this.mglName);
        this.data.put("GraphModelName", this.graphModelName);
        this.data.put("GraphModelExtension", this.gModel.getFileExtension());
        this.data.put("GraphModelPackage", this.graphModelPackage);
        this.data.put("GraphModelProject", this.graphModelProjectName);
        this.data.put("McamViewBasePackage", this.mcamViewBasePackage);
        this.data.put("McamViewPagePackage", String.valueOf(this.mcamViewBasePackage) + "." + pagePackageSuffix);
        this.data.put("McamProject", genMcam.getProject().getName());
        this.data.put("AdapterPackage", String.valueOf(this.mcamProjectBasePackage) + "." + McamImplementationGenerator.adapterPackageSuffix);
        this.data.put("CliPackage", String.valueOf(this.mcamProjectBasePackage) + "." + McamImplementationGenerator.cliPackageSuffix);
        this.data.put("ViewViewPackage", String.valueOf(this.mcamViewBasePackage) + "." + this.graphModelName.toLowerCase() + "." + viewPackageSuffix);
    }

    public String getMcamViewBasePackage() {
        return this.mcamViewBasePackage;
    }

    public String getMcamViewPackage() {
        return String.valueOf(this.mcamViewBasePackage) + "." + this.graphModelName.toLowerCase();
    }

    public boolean doGenerateMerge() {
        return this.generateMerge;
    }

    public boolean doGenerateCheck() {
        return this.generateCheck;
    }

    private void parseAnnotations() {
        for (Annotation annotation : this.gModel.getAnnotations()) {
            if (!"mcam".equals(annotation.getName())) continue;
            EList values = annotation.getValue();
            if (values.size() == 0 || values.contains("check")) {
                this.generateCheck = true;
            }
            if (values.size() != 0 && !values.contains("merge")) continue;
            this.generateMerge = true;
        }
    }

    public String generate() {
        try {
            if (this.generateMerge) {
                this.generateConflictViewPage();
            }
            if (this.generateCheck) {
                this.generateCheckViewPage();
            }
            this.generatePageFactory();
            this.generateActivator();
            this.generatePluginXml();
            this.generateManifest();
            this.generateBuildProperties();
            this.generateContextsXml();
            return "default";
        }
        catch (TemplateException | IOException e) {
            e.printStackTrace();
            return "error";
        }
    }

    private void generateActivator() throws IOException, TemplateException {
        this.data.put("ClassName", "Activator");
        TemplateGenerator templateGen = new TemplateGenerator("templates/views/Activator.tpl", this.mcamViewProject);
        templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".java");
        templateGen.setPkg((String)this.data.get("McamViewBasePackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
    }

    private void generatePluginXml() throws IOException, TemplateException {
        TemplateGenerator templateGen = new TemplateGenerator("templates/views/plugin.tpl", this.mcamViewProject);
        templateGen.setFilename("plugin.xml");
        templateGen.setPkg("");
        templateGen.setBasePath("");
        templateGen.setData(this.data);
        templateGen.generateFile();
    }

    private void generateManifest() throws IOException, TemplateException {
        TemplateGenerator templateGen = new TemplateGenerator("templates/views/Manifest.tpl", this.mcamViewProject);
        templateGen.setFilename("MANIFEST.MF");
        templateGen.setPkg("");
        templateGen.setBasePath("META-INF");
        templateGen.setData(this.data);
        templateGen.generateFile();
    }

    private void generateBuildProperties() throws IOException, TemplateException {
        TemplateGenerator templateGen = new TemplateGenerator("templates/views/build.properties", this.mcamViewProject);
        templateGen.setFilename("build.properties");
        templateGen.setPkg("");
        templateGen.setBasePath("");
        templateGen.setData(this.data);
        templateGen.generateFile();
    }

    private void generateContextsXml() throws IOException, TemplateException {
        TemplateGenerator templateGen = new TemplateGenerator("templates/views/contexts.tpl", this.mcamViewProject);
        templateGen.setFilename("contexts.xml");
        templateGen.setPkg("");
        templateGen.setBasePath("");
        templateGen.setData(this.data);
        templateGen.generateFile();
    }

    private void generateCheckViewPage() throws IOException, TemplateException {
        this.data.put("ClassName", String.valueOf(this.graphModelName) + "CheckViewPage");
        TemplateGenerator templateGen = new TemplateGenerator("templates/views/CheckViewPage.tpl", this.mcamViewProject);
        templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".java");
        templateGen.setPkg((String)this.data.get("McamViewPagePackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
    }

    private void generateConflictViewPage() throws IOException, TemplateException {
        this.data.put("ClassName", String.valueOf(this.graphModelName) + "ConflictViewPage");
        TemplateGenerator templateGen = new TemplateGenerator("templates/views/ConflictViewPage.tpl", this.mcamViewProject);
        templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".java");
        templateGen.setPkg((String)this.data.get("McamViewPagePackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
    }

    private void generatePageFactory() throws IOException, TemplateException {
        this.data.put("ClassName", "PageFactoryImpl");
        String filename = "src-gen" + File.separator + ((String)this.data.get("McamViewBasePackage")).replace(".", File.separator) + File.separator + (String)this.data.get("ClassName") + ".java";
        IFile res = this.mcamViewProject.getFile(filename);
        if (res == null || !res.exists()) {
            TemplateGenerator templateGen = new TemplateGenerator("templates/views/PageFactoryImpl.tpl", this.mcamViewProject);
            templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".java");
            templateGen.setPkg((String)this.data.get("McamViewBasePackage"));
            templateGen.setData(this.data);
            templateGen.generateFile();
            System.out.println("CheckFactory not found... now generated!");
        }
        IFile file = this.mcamViewProject.getFile(filename);
        if (this.generateCheck) {
            String code_check = "if (model instanceof " + this.graphModelPackage + "." + this.mglName.toLowerCase() + "." + this.graphModelName + ") { \n " + (String)this.data.get("McamViewPagePackage") + "." + this.graphModelName + "CheckViewPage page = new " + (String)this.data.get("McamViewPagePackage") + "." + this.graphModelName + "CheckViewPage(id); \n" + "page.addCheckProcess(iFile, resource); \n" + "return page; } \n";
            this.insertCodeAfterMarker(file.getRawLocation().makeAbsolute().toFile(), "// @FACTORY_CHECK", code_check);
        }
        if (this.generateMerge) {
            String code_conflict = "if (model instanceof " + this.graphModelPackage + "." + this.mglName.toLowerCase() + ".internal.Internal" + this.graphModelName + ") return new " + (String)this.data.get("McamViewPagePackage") + "." + this.graphModelName + "ConflictViewPage(id, iFile, resource); \n";
            this.insertCodeAfterMarker(file.getRawLocation().makeAbsolute().toFile(), "// @FACTORY_CONFLICT", code_conflict);
        }
        String code_handle = "if (model instanceof " + this.graphModelPackage + "." + this.mglName.toLowerCase() + "." + this.graphModelName + ") return true;";
        this.insertCodeAfterMarker(file.getRawLocation().makeAbsolute().toFile(), "// @FACTORY_HANDLE", code_handle);
        String code_extension = "\"" + this.data.get("GraphModelExtension") + "\",";
        this.insertCodeAfterMarker(file.getRawLocation().makeAbsolute().toFile(), "// @PROJECT_CHECK_PAGE_EXT", code_extension);
        String code_cpadd = "if (iFile.getFileExtension().equals(\"" + this.data.get("GraphModelExtension") + "\")) \n" + "fe = new " + this.data.get("CliPackage") + "." + this.data.get("GraphModelName") + "Execution(); \n";
        this.insertCodeAfterMarker(file.getRawLocation().makeAbsolute().toFile(), "// @PROJECT_CHECK_PAGE_ADD", code_cpadd);
    }

    private void insertCodeAfterMarker(File file, String marker, String code) {
        try {
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
                String line = null;
                String originalText = new String();
                while ((line = reader.readLine()) != null) {
                    originalText = String.valueOf(originalText) + line.concat("\n");
                }
                fis.close();
                if (!originalText.contains(code)) {
                    originalText = originalText.replaceAll(marker, String.valueOf(marker) + "\n" + code);
                }
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(originalText.getBytes());
                fos.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

