/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam;

import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.plugin.mcam.TemplateGenerator;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mgl.Annotation;
import mgl.Attribute;
import mgl.ComplexAttribute;
import mgl.Edge;
import mgl.Enumeration;
import mgl.GraphModel;
import mgl.GraphicalElementContainment;
import mgl.IncomingEdgeElementConnection;
import mgl.MGLModel;
import mgl.ModelElement;
import mgl.Node;
import mgl.NodeContainer;
import mgl.OutgoingEdgeElementConnection;
import mgl.PrimitiveAttribute;
import mgl.Type;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;

public class McamImplementationGenerator {
    public static String mcamPackageSuffix = "mcam";
    public static String adapterPackageSuffix = "adapter";
    public static String cliPackageSuffix = "cli";
    public static String modulesPackageSuffix = "modules";
    public static String changeModulesPackageSuffix = "changes";
    public static String checkModulesPackageSuffix = "checks";
    private String mglName = null;
    private String mglModelId = null;
    private GraphModel gModel = null;
    private String graphModelName = null;
    private IProject mcamProject = null;
    private String mcamProjectBasePackage = null;
    private String graphModelProjectName = null;
    private String graphModelPackage = null;
    private ArrayList<String> changeModuleClasses = new ArrayList();
    private ArrayList<String> checkModuleClasses = new ArrayList();
    private String customMergeStrategy = "";
    public Map<String, Object> data = new HashMap<String, Object>();
    private boolean generateMerge = false;
    private boolean generateCheck = false;
    private ArrayList<HashMap<String, Object>> modelLabels = new ArrayList();
    private HashMap<ModelElement, ArrayList<Attribute>> entityAttributes = new HashMap();
    private HashMap<String, ArrayList<String>> fqTypeNames = new HashMap();
    private HashMap<String, ArrayList<String>> typeNames = new HashMap();
    private HashMap<ModelElement, ModelElement> extendsMap = new HashMap();
    private GeneratorUtils gu = GeneratorUtils.getInstance();

    public McamImplementationGenerator(MGLModel mglModel, GraphModel gModel, IProject project, String graphModelPackage, String graphModelProjectName) {
        this.mglName = this.gu.getFileName(mglModel);
        this.gModel = gModel;
        this.graphModelName = gModel.getName();
        this.graphModelPackage = graphModelPackage;
        this.graphModelProjectName = graphModelProjectName;
        this.mglModelId = mglModel.getPackage();
        this.mcamProject = project;
        this.mcamProjectBasePackage = String.valueOf(graphModelPackage) + "." + mcamPackageSuffix;
        this.parseAnnotations();
        this.initEntityMaps();
        this.data.put("MGLModelName", this.mglName);
        this.data.put("MGLModelID", this.mglModelId);
        this.data.put("GraphModelName", this.graphModelName);
        this.data.put("GraphModelProjectName", this.graphModelProjectName);
        this.data.put("GraphModelExtension", this.gModel.getFileExtension());
        this.data.put("GraphModelPackage", this.graphModelPackage);
        this.data.put("AdapterPackage", String.valueOf(this.mcamProjectBasePackage) + "." + adapterPackageSuffix);
        this.data.put("ChangeModulePackage", String.valueOf(this.mcamProjectBasePackage) + "." + modulesPackageSuffix + "." + changeModulesPackageSuffix);
        this.data.put("CheckModulePackage", String.valueOf(this.mcamProjectBasePackage) + "." + modulesPackageSuffix + "." + checkModulesPackageSuffix);
        this.data.put("CliPackage", String.valueOf(this.mcamProjectBasePackage) + "." + cliPackageSuffix);
        this.data.put("ChangeModules", this.changeModuleClasses);
        this.data.put("CheckModules", this.checkModuleClasses);
        this.data.put("CustomMergeStrategy", this.customMergeStrategy);
        this.data.put("MergeStrategyClass", String.valueOf(this.graphModelName) + "MergeStrategy");
        this.data.put("ModelLabels", this.modelLabels);
        this.data.put("ContainerTypes", this.typeNames.get("Container"));
        this.data.put("FqContainerTypes", this.fqTypeNames.get("Container"));
        this.data.put("NodeTypes", this.typeNames.get("Node"));
        this.data.put("FqNodeTypes", this.fqTypeNames.get("Node"));
        this.data.put("EdgeTypes", this.typeNames.get("Edge"));
        this.data.put("FqEdgeTypes", this.fqTypeNames.get("Edge"));
    }

    public IProject getProject() {
        return this.mcamProject;
    }

    public String getMcamProjectBasePackage() {
        return this.mcamProjectBasePackage;
    }

    public boolean doGenerateMerge() {
        return this.generateMerge;
    }

    public boolean doGenerateCheck() {
        return this.generateCheck;
    }

    private void initEntityMaps() {
        this.entityAttributes.put((ModelElement)this.gModel, new ArrayList());
        this.typeNames.put("GraphModel", new ArrayList());
        this.typeNames.get("GraphModel").add(this.gModel.getName());
        for (Attribute attribute : this.gModel.getAttributes()) {
            if (this.gModel.getExtends() != null && !this.gModel.getExtends().isIsAbstract()) {
                this.extendsMap.put((ModelElement)this.gModel, (ModelElement)this.gModel.getExtends());
            }
            this.entityAttributes.get(this.gModel).add(attribute);
        }
        this.typeNames.put("Container", new ArrayList());
        this.fqTypeNames.put("Container", new ArrayList());
        this.typeNames.put("Node", new ArrayList());
        this.fqTypeNames.put("Node", new ArrayList());
        this.typeNames.put("Edge", new ArrayList());
        this.fqTypeNames.put("Edge", new ArrayList());
        for (ModelElement me : MGLUtil.modelElements((GraphModel)this.gModel)) {
            if (me instanceof NodeContainer) {
                NodeContainer container = (NodeContainer)me;
                if (container.getExtends() != null) {
                    this.extendsMap.put((ModelElement)container, (ModelElement)container.getExtends());
                }
                this.typeNames.get("Container").add(container.getName());
                this.fqTypeNames.get("Container").add(MGLUtil.getFqn((ModelElement)container));
                this.entityAttributes.put((ModelElement)container, new ArrayList());
                for (Attribute attribute : container.getAttributes()) {
                    this.entityAttributes.get(container).add(attribute);
                }
                continue;
            }
            if (me instanceof Node) {
                if (((Node)me).getExtends() != null) {
                    this.extendsMap.put(me, (ModelElement)((Node)me).getExtends());
                }
                this.typeNames.get("Node").add(me.getName());
                this.fqTypeNames.get("Node").add(MGLUtil.getFqn((ModelElement)me));
                this.entityAttributes.put(me, new ArrayList());
                for (Attribute attribute : me.getAttributes()) {
                    this.entityAttributes.get(me).add(attribute);
                }
                continue;
            }
            if (!(me instanceof Edge)) continue;
            if (((Edge)me).getExtends() != null) {
                this.extendsMap.put(me, (ModelElement)((Edge)me).getExtends());
            }
            this.typeNames.get("Edge").add(me.getName());
            this.fqTypeNames.get("Edge").add(MGLUtil.getFqn((ModelElement)me));
            this.entityAttributes.put(me, new ArrayList());
            for (Attribute attribute : me.getAttributes()) {
                this.entityAttributes.get(me).add(attribute);
            }
        }
    }

    public String generate() {
        try {
            for (ModelElement element : this.entityAttributes.keySet()) {
                this.addLabelEntry(element);
                if (element.isIsAbstract() || !this.generateMerge) continue;
                this.data.put("ModelElementType", "GraphModel");
                if (!(element instanceof GraphModel)) {
                    if (element instanceof Edge) {
                        this.data.put("ModelElementType", "Edge");
                        this.generateAddEdgeChangeModule((Edge)element);
                        this.generateDeleteEdgeChangeModule((Edge)element);
                        this.generateSourceTargetChangeModule((Edge)element);
                    }
                    if (element instanceof Node) {
                        this.data.put("ModelElementType", "Node");
                        this.generateAddElementChangeModule(element);
                        this.generateDeleteElementChangeModule(element);
                        this.generateMoveResizeElementChangeModule(element);
                    }
                    if (element instanceof NodeContainer) {
                        this.data.put("ModelElementType", "Container");
                        this.generateAddElementChangeModule(element);
                        this.generateDeleteElementChangeModule(element);
                        this.generateMoveResizeElementChangeModule(element);
                    }
                }
                ModelElement elementToGen = element;
                while (elementToGen != null) {
                    for (Attribute attribute : this.entityAttributes.get(elementToGen)) {
                        this.generateAttributeChangeModule(element, attribute);
                    }
                    elementToGen = this.extendsMap.get(elementToGen);
                }
            }
            if (this.generateCheck) {
                this.generateCincoCheckModule((ModelElement)this.gModel);
                this.generateContainmentCheckModule((ModelElement)this.gModel);
                this.generateIncomingCheckModule((ModelElement)this.gModel);
                this.generateOutgoingCheckModule((ModelElement)this.gModel);
            }
            this.generateEntityId();
            this.generateModelAdapter();
            this.generateCliExecution();
            return "default";
        }
        catch (TemplateException | IOException e) {
            e.printStackTrace();
            return "error";
        }
    }

    private void parseAnnotations() {
        for (Annotation annotation : this.gModel.getAnnotations()) {
            if ("mcam".equals(annotation.getName())) {
                EList values = annotation.getValue();
                if (values.size() == 0 || values.contains("check")) {
                    this.generateCheck = true;
                }
                if (values.size() == 0 || values.contains("merge")) {
                    this.generateMerge = true;
                }
            }
            if ("mcam_changemodule".equals(annotation.getName())) {
                this.changeModuleClasses.add((String)annotation.getValue().get(0));
            }
            if ("mcam_checkmodule".equals(annotation.getName())) {
                this.checkModuleClasses.add((String)annotation.getValue().get(0));
            }
            if (!"mcam_mergestrategy".equals(annotation.getName())) continue;
            this.customMergeStrategy = (String)annotation.getValue().get(0);
        }
    }

    private void addLabelEntry(ModelElement element) {
        ModelElement elementToLabel = element;
        boolean labelFound = false;
        while (element != null) {
            for (Attribute attribute : element.getAttributes()) {
                for (Annotation annotation : attribute.getAnnotations()) {
                    if (!"mcam_label".equals(annotation.getName())) continue;
                    HashMap<String, Object> labelEntry = new HashMap<String, Object>();
                    labelEntry.put("type", elementToLabel.getName());
                    labelEntry.put("attribute", attribute.getName());
                    labelEntry.put("isModelElement", this.getModelElementType(attribute) != null);
                    this.modelLabels.add(labelEntry);
                    labelFound = true;
                }
            }
            if (labelFound) break;
            element = this.extendsMap.get(element);
        }
    }

    private String getNameForAttribute(Attribute attribute) {
        if (attribute instanceof PrimitiveAttribute) {
            return ((PrimitiveAttribute)attribute).getType().getName();
        }
        if (attribute instanceof ComplexAttribute) {
            return ((ComplexAttribute)attribute).getType().getName();
        }
        return null;
    }

    private ModelElement getModelElementType(Attribute attribute) {
        for (ModelElement element : this.entityAttributes.keySet()) {
            if (!this.getNameForAttribute(attribute).equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    private Type getEnumType(Attribute attribute) {
        for (Type type : MGLUtil.types((GraphModel)this.gModel)) {
            if (!(type instanceof Enumeration) || !this.getNameForAttribute(attribute).equals(type.getName())) continue;
            return type;
        }
        return null;
    }

    private Set<ModelElement> getPossibleContainer(ModelElement element) {
        HashSet<ModelElement> possibleContainer = new HashSet<ModelElement>();
        for (Node n : MGLUtil.getUsableNodes((GraphModel)this.gModel)) {
            if (!(n instanceof NodeContainer)) continue;
            NodeContainer container = (NodeContainer)n;
            for (GraphicalElementContainment gec : container.getContainableElements()) {
                if (gec.eCrossReferences().size() > 0) {
                    for (EObject eObj : gec.eCrossReferences()) {
                        if (!element.getName().equals(((ModelElement)eObj).getName())) continue;
                        possibleContainer.add((ModelElement)container);
                    }
                    continue;
                }
                possibleContainer.add((ModelElement)container);
            }
        }
        return possibleContainer;
    }

    private Set<ModelElement> getPossibleEdgeTargets(ModelElement element) {
        HashSet<ModelElement> possibleSources = new HashSet<ModelElement>();
        for (Node node : MGLUtil.getUsableNodes((GraphModel)this.gModel)) {
            for (IncomingEdgeElementConnection incEdge : node.getIncomingEdgeConnections()) {
                if (incEdge.eCrossReferences().size() > 0) {
                    for (EObject eObj : incEdge.eCrossReferences()) {
                        if (!element.getName().equals(((ModelElement)eObj).getName())) continue;
                        possibleSources.add((ModelElement)node);
                    }
                    continue;
                }
                possibleSources.add((ModelElement)node);
            }
        }
        for (Node n : MGLUtil.getUsableNodes((GraphModel)this.gModel)) {
            if (!(n instanceof NodeContainer)) continue;
            NodeContainer container = (NodeContainer)n;
            for (IncomingEdgeElementConnection incEdge : container.getIncomingEdgeConnections()) {
                if (incEdge.eCrossReferences().size() > 0) {
                    for (EObject eObj : incEdge.eCrossReferences()) {
                        if (!element.getName().equals(((ModelElement)eObj).getName())) continue;
                        possibleSources.add((ModelElement)container);
                    }
                    continue;
                }
                possibleSources.add((ModelElement)container);
            }
        }
        return possibleSources;
    }

    private Set<ModelElement> getPossibleEdgeSources(ModelElement element) {
        HashSet<ModelElement> possibleTargets = new HashSet<ModelElement>();
        for (Node node : MGLUtil.getUsableNodes((GraphModel)this.gModel)) {
            for (OutgoingEdgeElementConnection outEdge : node.getOutgoingEdgeConnections()) {
                if (outEdge.eCrossReferences().size() > 0) {
                    for (EObject eObj : outEdge.eCrossReferences()) {
                        if (!element.getName().equals(((ModelElement)eObj).getName())) continue;
                        possibleTargets.add((ModelElement)node);
                    }
                    continue;
                }
                possibleTargets.add((ModelElement)node);
            }
        }
        for (Node n : MGLUtil.getUsableNodes((GraphModel)this.gModel)) {
            if (!(n instanceof NodeContainer)) continue;
            NodeContainer container = (NodeContainer)n;
            for (OutgoingEdgeElementConnection outEdge : container.getOutgoingEdgeConnections()) {
                if (outEdge.eCrossReferences().size() > 0) {
                    for (EObject eObj : outEdge.eCrossReferences()) {
                        if (!element.getName().equals(((ModelElement)eObj).getName())) continue;
                        possibleTargets.add((ModelElement)container);
                    }
                    continue;
                }
                possibleTargets.add((ModelElement)container);
            }
        }
        return possibleTargets;
    }

    private void generateEntityId() throws IOException, TemplateException {
        TemplateGenerator templateGen = new TemplateGenerator("templates/adapter/EntityId.tpl", this.mcamProject);
        templateGen.setFilename(String.valueOf(this.graphModelName) + "Id.java");
        templateGen.setPkg((String)this.data.get("AdapterPackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
    }

    private void generateModelAdapter() throws IOException, TemplateException {
        TemplateGenerator templateGen = new TemplateGenerator("templates/adapter/ModelAdapter.tpl", this.mcamProject);
        templateGen.setFilename(String.valueOf(this.graphModelName) + "Adapter.java");
        templateGen.setPkg((String)this.data.get("AdapterPackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
    }

    private void generateCliExecution() throws IOException, TemplateException {
        TemplateGenerator templateGen = new TemplateGenerator("templates/cli/CliMain.tpl", this.mcamProject);
        templateGen.setFilename("CliMain.java");
        templateGen.setPkg((String)this.data.get("CliPackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
        templateGen = new TemplateGenerator("templates/cli/CliExecution.tpl", this.mcamProject);
        templateGen.setFilename("CliExecution.java");
        templateGen.setPkg((String)this.data.get("CliPackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
        templateGen = new TemplateGenerator("templates/cli/FrameworkExecution.tpl", this.mcamProject);
        templateGen.setFilename(String.valueOf(this.graphModelName) + "Execution.java");
        templateGen.setPkg((String)this.data.get("CliPackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
    }

    private void generateAttributeChangeModule(ModelElement element, Attribute attribute) throws IOException, TemplateException {
        this.data.put("ClassName", String.valueOf(element.getName()) + "Attribute" + attribute.getName().substring(0, 1).toUpperCase() + attribute.getName().substring(1) + "Change");
        this.data.put("FqModelElementName", MGLUtil.getFqn((ModelElement)element));
        this.data.put("ModelElementName", element.getName());
        this.data.put("AttributeName", attribute.getName());
        if (this.getModelElementType(attribute) != null) {
            this.data.put("AttributeCategory", "ModelElement");
            this.data.put("AttributeType", this.data.get("MGLModelID") + "." + this.data.get("MGLModelName").toString().toLowerCase() + "." + ((ComplexAttribute)attribute).getType().getName());
        } else if (this.getEnumType(attribute) != null) {
            this.data.put("AttributeCategory", "Enum");
            this.data.put("AttributeType", this.data.get("GraphModelPackage") + "." + this.data.get("GraphModelName").toString().toLowerCase() + "." + this.getEnumType(attribute).getName());
        } else {
            String attributeType;
            this.data.put("AttributeCategory", "Normal");
            if (attribute instanceof PrimitiveAttribute) {
                attributeType = EcorePackage.eINSTANCE.getEClassifier(((PrimitiveAttribute)attribute).getType().getName()).getInstanceClass().getName();
            } else if (attribute instanceof ComplexAttribute) {
                attributeType = ((ComplexAttribute)attribute).getType().getName();
            } else {
                throw new RuntimeException(String.format("Attribute %s is neither PrimitiveAttibute nor ComplextAttribute", attribute.getName()));
            }
            Integer upperBound = attribute.getUpperBound();
            if (upperBound != null && upperBound != 1) {
                attributeType = "EList<" + attributeType + ">";
            }
            this.data.put("AttributeType", attributeType);
        }
        TemplateGenerator templateGen = new TemplateGenerator("templates/modules/AttributeChangeModule.tpl", this.mcamProject);
        templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".java");
        templateGen.setPkg((String)this.data.get("ChangeModulePackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
        this.changeModuleClasses.add(String.valueOf((String)this.data.get("ChangeModulePackage")) + "." + (String)this.data.get("ClassName"));
    }

    private void generateAddElementChangeModule(ModelElement element) throws IOException, TemplateException {
        this.data.put("ClassName", String.valueOf(element.getName()) + "AddChange");
        this.data.put("FqModelElementName", MGLUtil.getFqn((ModelElement)element));
        this.data.put("ModelElementName", element.getName());
        this.data.put("PossibleContainer", this.getPossibleContainer(element));
        TemplateGenerator templateGen = new TemplateGenerator("templates/modules/AddElementModule.tpl", this.mcamProject);
        templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".java");
        templateGen.setPkg((String)this.data.get("ChangeModulePackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
        this.changeModuleClasses.add(String.valueOf((String)this.data.get("ChangeModulePackage")) + "." + (String)this.data.get("ClassName"));
    }

    private void generateDeleteElementChangeModule(ModelElement element) throws IOException, TemplateException {
        this.data.put("ClassName", String.valueOf(element.getName()) + "DeleteChange");
        this.data.put("FqModelElementName", MGLUtil.getFqn((ModelElement)element));
        this.data.put("ModelElementName", element.getName());
        this.data.put("PossibleContainer", this.getPossibleContainer(element));
        TemplateGenerator templateGen = new TemplateGenerator("templates/modules/DeleteElementModule.tpl", this.mcamProject);
        templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".java");
        templateGen.setPkg((String)this.data.get("ChangeModulePackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
        this.changeModuleClasses.add(String.valueOf((String)this.data.get("ChangeModulePackage")) + "." + (String)this.data.get("ClassName"));
    }

    private void generateDeleteEdgeChangeModule(Edge element) throws IOException, TemplateException {
        this.data.put("ClassName", String.valueOf(element.getName()) + "DeleteChange");
        this.data.put("FqModelElementName", MGLUtil.getFqn((ModelElement)element));
        this.data.put("ModelElementName", element.getName());
        Set<ModelElement> possibleEdgeSources = this.getPossibleEdgeSources((ModelElement)element);
        this.data.put("PossibleEdgeSources", possibleEdgeSources);
        HashSet<String> fqPossibleEdgeSources = new HashSet<String>();
        for (ModelElement me : possibleEdgeSources) {
            fqPossibleEdgeSources.add(MGLUtil.getFqn((ModelElement)me));
        }
        this.data.put("FqPossibleEdgeSources", fqPossibleEdgeSources);
        Set<ModelElement> possibleEdgeTargets = this.getPossibleEdgeTargets((ModelElement)element);
        this.data.put("PossibleEdgeTargets", possibleEdgeTargets);
        HashSet<String> fqPossibleEdgeTargets = new HashSet<String>();
        for (ModelElement me : possibleEdgeTargets) {
            fqPossibleEdgeTargets.add(MGLUtil.getFqn((ModelElement)me));
        }
        this.data.put("FqPossibleEdgeTargets", fqPossibleEdgeTargets);
        TemplateGenerator templateGen = new TemplateGenerator("templates/modules/DeleteEdgeModule.tpl", this.mcamProject);
        templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".java");
        templateGen.setPkg((String)this.data.get("ChangeModulePackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
        this.changeModuleClasses.add(String.valueOf((String)this.data.get("ChangeModulePackage")) + "." + (String)this.data.get("ClassName"));
    }

    private void generateAddEdgeChangeModule(Edge element) throws IOException, TemplateException {
        this.data.put("ClassName", String.valueOf(element.getName()) + "AddChange");
        this.data.put("FqModelElementName", MGLUtil.getFqn((ModelElement)element));
        this.data.put("ModelElementName", element.getName());
        Set<ModelElement> possibleEdgeSources = this.getPossibleEdgeSources((ModelElement)element);
        this.data.put("PossibleEdgeSources", possibleEdgeSources);
        HashSet<String> fqPossibleEdgeSources = new HashSet<String>();
        for (ModelElement me : possibleEdgeSources) {
            fqPossibleEdgeSources.add(MGLUtil.getFqn((ModelElement)me));
        }
        this.data.put("FqPossibleEdgeSources", fqPossibleEdgeSources);
        Set<ModelElement> possibleEdgeTargets = this.getPossibleEdgeTargets((ModelElement)element);
        this.data.put("PossibleEdgeTargets", possibleEdgeTargets);
        HashSet<String> fqPossibleEdgeTargets = new HashSet<String>();
        for (ModelElement me : possibleEdgeTargets) {
            fqPossibleEdgeTargets.add(MGLUtil.getFqn((ModelElement)me));
        }
        this.data.put("FqPossibleEdgeTargets", fqPossibleEdgeTargets);
        TemplateGenerator templateGen = new TemplateGenerator("templates/modules/AddEdgeModule.tpl", this.mcamProject);
        templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".java");
        templateGen.setPkg((String)this.data.get("ChangeModulePackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
        this.changeModuleClasses.add(String.valueOf((String)this.data.get("ChangeModulePackage")) + "." + (String)this.data.get("ClassName"));
    }

    private void generateSourceTargetChangeModule(Edge element) throws IOException, TemplateException {
        this.data.put("ClassName", String.valueOf(element.getName()) + "SourceTargetChange");
        this.data.put("FqModelElementName", MGLUtil.getFqn((ModelElement)element));
        this.data.put("ModelElementName", element.getName());
        Set<ModelElement> possibleEdgeSources = this.getPossibleEdgeSources((ModelElement)element);
        this.data.put("PossibleEdgeSources", possibleEdgeSources);
        HashSet<String> fqPossibleEdgeSources = new HashSet<String>();
        for (ModelElement me : possibleEdgeSources) {
            fqPossibleEdgeSources.add(MGLUtil.getFqn((ModelElement)me));
        }
        this.data.put("FqPossibleEdgeSources", fqPossibleEdgeSources);
        Set<ModelElement> possibleEdgeTargets = this.getPossibleEdgeTargets((ModelElement)element);
        this.data.put("PossibleEdgeTargets", possibleEdgeTargets);
        HashSet<String> fqPossibleEdgeTargets = new HashSet<String>();
        for (ModelElement me : possibleEdgeTargets) {
            fqPossibleEdgeTargets.add(MGLUtil.getFqn((ModelElement)me));
        }
        this.data.put("FqPossibleEdgeTargets", fqPossibleEdgeTargets);
        TemplateGenerator templateGen = new TemplateGenerator("templates/modules/SourceTargetChangeModule.tpl", this.mcamProject);
        templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".java");
        templateGen.setPkg((String)this.data.get("ChangeModulePackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
        this.changeModuleClasses.add(String.valueOf((String)this.data.get("ChangeModulePackage")) + "." + (String)this.data.get("ClassName"));
    }

    private void generateMoveResizeElementChangeModule(ModelElement element) throws IOException, TemplateException {
        this.data.put("ClassName", String.valueOf(element.getName()) + "MoveResizeChange");
        this.data.put("FqModelElementName", MGLUtil.getFqn((ModelElement)element));
        this.data.put("ModelElementName", element.getName());
        this.data.put("PossibleContainer", this.getPossibleContainer(element));
        TemplateGenerator templateGen = new TemplateGenerator("templates/modules/MoveResizeElementModule.tpl", this.mcamProject);
        templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".java");
        templateGen.setPkg((String)this.data.get("ChangeModulePackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
        this.changeModuleClasses.add(String.valueOf((String)this.data.get("ChangeModulePackage")) + "." + (String)this.data.get("ClassName"));
    }

    private void generateCincoCheckModule(ModelElement element) throws IOException, TemplateException {
        this.data.put("ClassName", this.data.get("GraphModelName") + "Check");
        TemplateGenerator templateGen = new TemplateGenerator("templates/modules/CincoCheckModule.tpl", this.mcamProject);
        templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".xtend");
        templateGen.setPkg((String)this.data.get("CheckModulePackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
    }

    private void generateContainmentCheckModule(ModelElement element) throws IOException, TemplateException {
        this.data.put("ClassName", this.data.get("GraphModelName") + "ContainmentCheck");
        TemplateGenerator templateGen = new TemplateGenerator("templates/modules/ContainmentCheckModule.tpl", this.mcamProject);
        templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".xtend");
        templateGen.setPkg((String)this.data.get("CheckModulePackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
        this.checkModuleClasses.add(String.valueOf((String)this.data.get("CheckModulePackage")) + "." + (String)this.data.get("ClassName"));
    }

    private void generateIncomingCheckModule(ModelElement element) throws IOException, TemplateException {
        this.data.put("ClassName", this.data.get("GraphModelName") + "IncomingCheck");
        TemplateGenerator templateGen = new TemplateGenerator("templates/modules/IncomingCheckModule.tpl", this.mcamProject);
        templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".xtend");
        templateGen.setPkg((String)this.data.get("CheckModulePackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
        this.checkModuleClasses.add(String.valueOf((String)this.data.get("CheckModulePackage")) + "." + (String)this.data.get("ClassName"));
    }

    private void generateOutgoingCheckModule(ModelElement element) throws IOException, TemplateException {
        this.data.put("ClassName", this.data.get("GraphModelName") + "OutgoingCheck");
        TemplateGenerator templateGen = new TemplateGenerator("templates/modules/OutgoingCheckModule.tpl", this.mcamProject);
        templateGen.setFilename(String.valueOf((String)this.data.get("ClassName")) + ".xtend");
        templateGen.setPkg((String)this.data.get("CheckModulePackage"));
        templateGen.setData(this.data);
        templateGen.generateFile();
        this.checkModuleClasses.add(String.valueOf((String)this.data.get("CheckModulePackage")) + "." + (String)this.data.get("ClassName"));
    }
}

