/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.tracer.views;

import info.scce.dime.tracer.impl.ProcessTypeMapper;
import info.scce.dime.tracer.util.ContextVariable;
import info.scce.dime.tracer.util.TracerEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class TracerViewInformation {
    private File file = null;
    private Resource resource = null;
    private TableViewer viewer = null;
    private TracerEnvironment environment = null;

    public File getFile() {
        return this.file;
    }

    public Resource getResource() {
        return this.resource;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public TracerEnvironment getEnvironment() {
        return this.environment;
    }

    public void closeView() {
        this.viewer.getControl().dispose();
    }

    public TracerViewInformation(File file, Resource resource, TracerEnvironment environment) {
        this.file = file;
        this.resource = resource;
        this.environment = environment;
    }

    private Collection<ContextVariable> getContextVariables() {
        if (this.environment.getNextContext() != null) {
            return this.environment.getNextContext().getVariables();
        }
        if (this.environment.getActiveContext() != null) {
            return this.environment.getActiveContext().getVariables();
        }
        return new ArrayList<ContextVariable>();
    }

    public void refresh() {
        this.viewer.setInput(this.getContextVariables());
        this.viewer.refresh();
        this.viewer.getTable().layout();
    }

    public void createTableView(Composite parent) {
        this.viewer = new TableViewer(parent, 770);
        this.createColumns(parent);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ContextVariable cv1 = (ContextVariable)e1;
                ContextVariable cv2 = (ContextVariable)e2;
                return cv1.getName().compareTo(cv2.getName());
            }
        });
        this.viewer.setInput(this.getContextVariables());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setLayout((Layout)new GridLayout(1, false));
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createColumns(Composite parent) {
        TableViewerColumn colVarName = new TableViewerColumn(this.viewer, 0);
        colVarName.getColumn().setWidth(150);
        colVarName.getColumn().setText("Name");
        colVarName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ContextVariable var = (ContextVariable)element;
                return var.getName();
            }
        });
        TableViewerColumn colVarValue = new TableViewerColumn(this.viewer, 0);
        colVarValue.getColumn().setWidth(150);
        colVarValue.getColumn().setText("Value");
        colVarValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ContextVariable var = (ContextVariable)element;
                if (var.getValue() != null) {
                    return var.getValue().toString();
                }
                return "";
            }
        });
        TableViewerColumn colVarType = new TableViewerColumn(this.viewer, 0);
        colVarType.getColumn().setWidth(150);
        colVarType.getColumn().setText("Type");
        colVarType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ContextVariable var = (ContextVariable)element;
                if (var.getType() != null) {
                    return ProcessTypeMapper.getPrimitiveTypeForClass(var.getType()).getLiteral();
                }
                return "";
            }
        });
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return new String[]{"One", "Two", "Three"};
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

