/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.tracer.views;

import info.scce.dime.tracer.impl.ProcessModelAdapter;
import info.scce.dime.tracer.impl.TracerConsoleAdapter;
import info.scce.dime.tracer.impl.TracerEclipseAdapter;
import info.scce.dime.tracer.util.TracerEnvironment;
import info.scce.dime.tracer.views.TracerViewInformation;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TracerView
extends ViewPart
implements IPartListener2 {
    public static final String ID = "info.scce.dime.process.tracer.views.TracerView";
    private Composite parent = null;
    private TracerEnvironment tracerEnvironment = null;
    private TracerEnvironment tracerConsoleEnvironment = null;
    private TracerViewInformation activeTracerView = null;
    private HashMap<File, TracerViewInformation> tracerInfoMap = new HashMap();
    private TableViewer viewer;
    private Action start_stop_action;
    private Action run_action;
    private Action step_over_action;
    private Action step_into_action;
    private Action start_console_action;
    private Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
    private URL urlStartTrace = FileLocator.find((Bundle)this.bundle, (IPath)new Path("icons/run_obj.gif"), null);
    private URL urlProcessTrace = FileLocator.find((Bundle)this.bundle, (IPath)new Path("icons/resume_co.gif"), null);
    private URL urlStepOverTrace = FileLocator.find((Bundle)this.bundle, (IPath)new Path("icons/stepover_co.gif"), null);
    private URL urlStopTrace = FileLocator.find((Bundle)this.bundle, (IPath)new Path("icons/terminatedlaunch_obj.gif"), null);
    private URL urlStepIntoTrace = FileLocator.find((Bundle)this.bundle, (IPath)new Path("icons/stepinto_co.gif"), null);

    public TracerView() {
        TracerEclipseAdapter uiAdapter = new TracerEclipseAdapter(this);
        this.tracerEnvironment = new TracerEnvironment(uiAdapter);
        TracerConsoleAdapter consoleAdapter = new TracerConsoleAdapter();
        this.tracerConsoleEnvironment = new TracerEnvironment(consoleAdapter);
    }

    public Composite getParent() {
        return this.parent;
    }

    public HashMap<File, TracerViewInformation> getTracerInfoMap() {
        return this.tracerInfoMap;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.parent.setLayout((Layout)new GridLayout(1, true));
        this.parent.setLayoutData((Object)new GridData(4, 4, true, true));
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener2)this);
        this.makeActions();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TracerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.start_console_action);
    }

    private void fillContextMenu(IMenuManager manager) {
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.start_stop_action);
        manager.add((IAction)this.run_action);
        manager.add((IAction)this.step_over_action);
        manager.add((IAction)this.step_into_action);
    }

    private void refreshView() {
        if (this.activeTracerView != null) {
            if (!this.tracerEnvironment.isRunning()) {
                this.run_action.setEnabled(false);
                this.step_over_action.setEnabled(false);
                this.step_into_action.setEnabled(false);
                this.start_stop_action.setImageDescriptor(ImageDescriptor.createFromURL((URL)this.urlStartTrace));
            } else {
                this.run_action.setEnabled(true);
                this.step_over_action.setEnabled(true);
                this.step_into_action.setEnabled(true);
                this.start_stop_action.setImageDescriptor(ImageDescriptor.createFromURL((URL)this.urlStopTrace));
            }
            this.activeTracerView.refresh();
            if (!this.parent.isDisposed()) {
                this.parent.layout(true);
                this.parent.redraw();
                this.parent.update();
            }
        }
    }

    private void showError(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String exceptionAsString = sw.toString();
        e.printStackTrace();
        MessageDialog.openError((Shell)this.parent.getShell(), (String)("Error: " + e.getClass().getSimpleName()), (String)e.getMessage());
    }

    private void makeActions() {
        this.start_stop_action = new Action(){

            public void run() {
                if (TracerView.this.activeTracerView != null) {
                    if (!TracerView.this.tracerEnvironment.isRunning()) {
                        try {
                            ProcessModelAdapter modelAdapter = new ProcessModelAdapter();
                            modelAdapter.setModel(TracerView.this.activeTracerView.getResource(), TracerView.this.activeTracerView.getFile());
                            TracerView.this.tracerEnvironment.initializeRun(modelAdapter);
                        }
                        catch (Exception e) {
                            TracerView.this.showError(e);
                        }
                    } else {
                        TracerView.this.tracerEnvironment.reset();
                    }
                    TracerView.this.refreshView();
                }
            }
        };
        this.start_stop_action.setText("|>");
        this.start_stop_action.setToolTipText("Start/Stop Tracer");
        this.start_stop_action.setImageDescriptor(ImageDescriptor.createFromURL((URL)this.urlStartTrace));
        this.run_action = new Action(){

            public void run() {
                if (TracerView.this.activeTracerView != null) {
                    while (TracerView.this.tracerEnvironment.isRunning()) {
                        try {
                            TracerView.this.tracerEnvironment.executeNextStep(false);
                        }
                        catch (Exception e) {
                            TracerView.this.showError(e);
                        }
                    }
                    TracerView.this.refreshView();
                }
            }
        };
        this.run_action.setText(">>");
        this.run_action.setToolTipText("Execute complete run");
        this.run_action.setImageDescriptor(ImageDescriptor.createFromURL((URL)this.urlProcessTrace));
        this.run_action.setEnabled(false);
        this.step_over_action = new Action(){

            public void run() {
                if (TracerView.this.activeTracerView != null) {
                    try {
                        TracerView.this.tracerEnvironment.executeNextStep(false);
                    }
                    catch (Exception e) {
                        TracerView.this.showError(e);
                    }
                    TracerView.this.refreshView();
                }
            }
        };
        this.step_over_action.setText("Step over");
        this.step_over_action.setToolTipText("Execute next Step");
        this.step_over_action.setImageDescriptor(ImageDescriptor.createFromURL((URL)this.urlStepOverTrace));
        this.step_over_action.setEnabled(false);
        this.step_into_action = new Action(){

            public void run() {
                if (TracerView.this.activeTracerView != null) {
                    try {
                        TracerView.this.tracerEnvironment.executeNextStep(true);
                    }
                    catch (Exception e) {
                        TracerView.this.showError(e);
                    }
                    TracerView.this.refreshView();
                }
            }
        };
        this.step_into_action.setText("Step into");
        this.step_into_action.setToolTipText("Step into");
        this.step_into_action.setImageDescriptor(ImageDescriptor.createFromURL((URL)this.urlStepIntoTrace));
        this.step_into_action.setEnabled(false);
        this.start_console_action = new Action(){

            public void run() {
                if (!TracerView.this.tracerConsoleEnvironment.isRunning()) {
                    try {
                        ProcessModelAdapter modelAdapter = new ProcessModelAdapter();
                        modelAdapter.setModel(TracerView.this.activeTracerView.getResource(), TracerView.this.activeTracerView.getFile());
                        TracerView.this.tracerConsoleEnvironment.initializeRun(modelAdapter);
                        while (TracerView.this.tracerConsoleEnvironment.isRunning()) {
                            TracerView.this.tracerConsoleEnvironment.executeNextStep(false);
                        }
                    }
                    catch (Exception e) {
                        TracerView.this.showError(e);
                    }
                } else {
                    TracerView.this.tracerConsoleEnvironment.reset();
                }
                TracerView.this.refreshView();
            }
        };
        this.start_console_action.setText("trace on console");
        this.start_console_action.setToolTipText("Start Console Tracer");
        this.start_console_action.setImageDescriptor(ImageDescriptor.createFromURL((URL)this.urlStartTrace));
    }

    private void hookDoubleClickAction() {
    }

    public void setFocus() {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IFile iFile;
        if (partRef instanceof EditorReference && (iFile = (IFile)((EditorReference)partRef).getEditor(false).getEditorInput().getAdapter(IFile.class)) != null) {
            String path = iFile.getRawLocation().toOSString();
            File file = new File(path);
            if (this.tracerInfoMap.keySet().contains(file)) {
                TracerViewInformation closingTracerView = this.tracerInfoMap.get(file);
                closingTracerView.closeView();
                this.tracerInfoMap.remove(file);
                if (this.activeTracerView == closingTracerView) {
                    this.activeTracerView = null;
                }
                if (!this.parent.isDisposed()) {
                    this.parent.layout(true);
                    this.parent.redraw();
                    this.parent.update();
                }
            }
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (partRef instanceof EditorReference) {
            File origFile;
            IEditorPart editor = ((EditorReference)partRef).getEditor(false);
            IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
            Resource res = null;
            if (editor instanceof DiagramEditor) {
                DiagramEditor deditor = (DiagramEditor)editor;
                TransactionalEditingDomain ed = deditor.getEditingDomain();
                ResourceSet rs = ed.getResourceSet();
                res = (Resource)rs.getResources().get(0);
            }
            if (this.parent.isDisposed()) {
                return;
            }
            Control[] controlArray = this.parent.getChildren();
            int n = controlArray.length;
            int ed = 0;
            while (ed < n) {
                Control child = controlArray[ed];
                child.setVisible(false);
                ((GridData)child.getLayoutData()).exclude = true;
                ++ed;
            }
            if (file != null && res != null && (origFile = new File(file.getRawLocation().toOSString())).exists()) {
                if (!this.tracerInfoMap.keySet().contains(origFile)) {
                    TracerViewInformation traceInfo = new TracerViewInformation(origFile, res, this.tracerEnvironment);
                    traceInfo.createTableView(this.parent);
                    this.tracerInfoMap.put(origFile, traceInfo);
                }
                this.activeTracerView = this.tracerInfoMap.get(origFile);
                this.activeTracerView.getViewer().getTable().setVisible(true);
                ((GridData)this.activeTracerView.getViewer().getTable().getLayoutData()).exclude = false;
                this.refreshView();
                this.parent.layout();
            }
        }
        if (!this.parent.isDisposed()) {
            this.parent.layout(true);
            this.parent.redraw();
            this.parent.update();
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }
}

