/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.tracer.util;

import info.scce.dime.tracer.interfaces.ModelAdapter;
import info.scce.dime.tracer.interfaces.TracerUIAdapter;
import info.scce.dime.tracer.util.TracerContext;
import java.util.Stack;

public class TracerEnvironment {
    private Stack<TracerContext> callStack = new Stack();
    private TracerContext activeContext = null;
    private TracerUIAdapter uiAdapter = null;

    public TracerEnvironment(TracerUIAdapter uiAdapter) {
        this.uiAdapter = uiAdapter;
    }

    public Stack<TracerContext> getCallStack() {
        return this.callStack;
    }

    public TracerContext getActiveContext() {
        return this.activeContext;
    }

    public TracerUIAdapter getUiAdapter() {
        return this.uiAdapter;
    }

    public boolean isRunning() {
        return !this.callStack.isEmpty();
    }

    public void initializeRun(ModelAdapter modelAdapter) throws Exception {
        TracerContext initContext = new TracerContext(modelAdapter);
        initContext.initializeRun();
        this.callStack.push(initContext);
        this.activeContext = initContext;
        this.uiAdapter.postInitialize(this);
    }

    public void executeNextStep(boolean stepInto) throws Exception {
        if (this.callStack.size() <= 0) {
            return;
        }
        this.activeContext = this.callStack.pop();
        if (this.activeContext.isRunning()) {
            this.uiAdapter.preExecute(this);
            this.activeContext.executeNextStep(this, stepInto);
            this.uiAdapter.postExecute(this);
        }
    }

    public void reset() {
        this.callStack = new Stack();
        this.activeContext = null;
    }

    public TracerContext getNextContext() {
        if (!this.callStack.isEmpty()) {
            return this.callStack.peek();
        }
        return null;
    }
}

