/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.tracer.util;

import info.scce.dime.tracer.interfaces.ModelAdapter;
import info.scce.dime.tracer.interfaces.TracerNode;
import info.scce.dime.tracer.util.ContextVariable;
import info.scce.dime.tracer.util.TracerEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class TracerContext {
    private HashMap<String, ContextVariable> context = new HashMap();
    private ModelAdapter modelAdapter = null;
    private List<ContextVariable> inputs = null;
    private List<ContextVariable> outputs = null;
    private TracerNode activeNode = null;
    private TracerNode nextNode = null;
    private boolean running = false;
    private String exitBranch = null;

    public List<ContextVariable> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<ContextVariable> inputs) {
        this.inputs = inputs;
    }

    public List<ContextVariable> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ContextVariable> outputs) {
        this.outputs = outputs;
    }

    public String getExitBranch() {
        return this.exitBranch;
    }

    public void setExitBranch(String exitBranch) {
        this.exitBranch = exitBranch;
    }

    public HashMap<String, ContextVariable> getContext() {
        return this.context;
    }

    public ModelAdapter getModelAdapter() {
        return this.modelAdapter;
    }

    public TracerNode getActiveNode() {
        return this.activeNode;
    }

    public TracerNode getNextNode() {
        return this.nextNode;
    }

    public boolean isRunning() {
        return this.running;
    }

    public TracerContext(ModelAdapter modelAdapter) {
        this.modelAdapter = modelAdapter;
    }

    public ContextVariable getById(String id) {
        return this.context.get(id);
    }

    public ContextVariable getByName(String name) {
        for (ContextVariable var : this.context.values()) {
            if (!var.getName().equals(name)) continue;
            return var;
        }
        return null;
    }

    public List<String> getContextVariableNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (ContextVariable var : this.context.values()) {
            names.add(var.getName());
        }
        return names;
    }

    public void createContextVariable(String id, String name, Class<?> type) {
        ContextVariable var = new ContextVariable();
        var.setId(id);
        var.setName(name);
        var.setType(type);
        this.context.put(id, var);
    }

    public Collection<ContextVariable> getVariables() {
        return this.context.values();
    }

    public void initializeRun() throws Exception {
        this.context = new HashMap();
        this.running = true;
        this.modelAdapter.createContextVariables(this);
        this.activeNode = this.modelAdapter.getStartNode();
    }

    public void executeNextStep(TracerEnvironment env, boolean stepInto) throws Exception {
        this.activeNode = this.nextNode = this.activeNode.execute(env, stepInto);
        if (this.nextNode == null) {
            this.running = false;
        }
    }
}

