/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.tracer.impl.nodes;

import info.scce.dime.process.process.AtomicSIB;
import info.scce.dime.process.process.Branch;
import info.scce.dime.siblibrary.SIB;
import info.scce.dime.tracer.impl.ProcessModelAdapter;
import info.scce.dime.tracer.impl.nodes.BranchNode;
import info.scce.dime.tracer.impl.nodes.DataFlowTargetNode;
import info.scce.dime.tracer.interfaces.TracerNode;
import info.scce.dime.tracer.util.ContextVariable;
import info.scce.dime.tracer.util.TracerContext;
import info.scce.dime.tracer.util.TracerEnvironment;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class AtomicNode
extends DataFlowTargetNode<AtomicSIB> {
    public AtomicNode(AtomicSIB sib) {
        super(sib);
    }

    @Override
    public TracerNode execute(TracerEnvironment env, boolean stepInto) throws Exception {
        this.adapter = (ProcessModelAdapter)env.getActiveContext().getModelAdapter();
        TracerContext context = env.getActiveContext();
        ArrayList<ContextVariable> inputParameters = new ArrayList<ContextVariable>();
        inputParameters.addAll(this.mapInputPort(context));
        inputParameters.addAll(this.mapInputStatic(context));
        Object returnValue = null;
        SIB atomicSib = (SIB)((AtomicSIB)this.sib).getSib();
        if (atomicSib == null) {
            throw new Exception("Could not find Sib (EObject) for AtomicSib!");
        }
        returnValue = this.invokeAtomicSIB(inputParameters, atomicSib);
        TracerNode nextNode = this.getNextNode(env, returnValue);
        env.getCallStack().push(context);
        return nextNode;
    }

    private Object invokeAtomicSIB(List<ContextVariable> inputParameters, SIB sib) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<Object> inputParameterValues = new ArrayList<Object>();
        Class[] inputParameterClasses = new Class[inputParameters.size()];
        int i = 0;
        for (ContextVariable inputParameter : inputParameters) {
            inputParameterValues.add(inputParameter.getValue());
            inputParameterClasses[i] = inputParameter.getType();
            ++i;
        }
        Class<?> exeClass = Class.forName(sib.getExecutorClass());
        Method exeMethod = exeClass.getMethod(sib.getExecutorMethod(), inputParameterClasses);
        return exeMethod.invoke((Object)this, inputParameterValues.toArray());
    }

    private TracerNode getNextNode(TracerEnvironment env, Object returnValue) throws Exception {
        Branch branch = null;
        String branchName = "";
        ContextVariable cv = null;
        if (returnValue instanceof Boolean) {
            Boolean value = (Boolean)returnValue;
            if (value.booleanValue()) {
                branchName = "yes";
                branch = this.getBranchForBranchName(branchName);
            } else {
                branchName = "no";
                branch = this.getBranchForBranchName(branchName);
            }
        }
        if (returnValue != null && returnValue.getClass() != null && returnValue.getClass().isEnum()) {
            branch = this.getBranchForBranchName(returnValue.toString());
        }
        if (returnValue instanceof Exception) {
            branchName = "error";
            branch = this.getBranchForBranchName(branchName);
            cv = new ContextVariable();
            cv.setValue(returnValue);
        } else if (branch == null) {
            branchName = "success";
            branch = this.getBranchForBranchName(branchName);
            cv = new ContextVariable();
            cv.setValue(returnValue);
        }
        if (branch == null) {
            throw new Exception("Could not find branch '" + branchName + "'!");
        }
        BranchNode bn = new BranchNode(branch);
        return bn.executeAfterAtomicSib(env, cv);
    }

    private Branch getBranchForBranchName(String branchName) {
        for (Branch branch : ((AtomicSIB)this.sib).getSuccessors(Branch.class)) {
            if (!branch.getName().equals(branchName)) continue;
            return branch;
        }
        return null;
    }
}

