/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.tracer.impl;

import graphmodel.Container;
import graphmodel.Edge;
import graphmodel.Node;
import info.scce.dime.process.process.AtomicSIB;
import info.scce.dime.process.process.BooleanInputStatic;
import info.scce.dime.process.process.CreateSIB;
import info.scce.dime.process.process.DataContext;
import info.scce.dime.process.process.DataFlowTarget;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.InputStatic;
import info.scce.dime.process.process.IntegerInputStatic;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.process.process.PrimitiveVariable;
import info.scce.dime.process.process.Process;
import info.scce.dime.process.process.ProcessPackage;
import info.scce.dime.process.process.ProcessSIB;
import info.scce.dime.process.process.RealInputStatic;
import info.scce.dime.process.process.SetAttributeValueSIB;
import info.scce.dime.process.process.StartSIB;
import info.scce.dime.process.process.TextInputStatic;
import info.scce.dime.process.process.TimestampInputStatic;
import info.scce.dime.process.process.UnsetAttributeValueSIB;
import info.scce.dime.tracer.impl.ProcessTypeMapper;
import info.scce.dime.tracer.impl.nodes.AtomicNode;
import info.scce.dime.tracer.impl.nodes.CreateNode;
import info.scce.dime.tracer.impl.nodes.DataFlowSourceNode;
import info.scce.dime.tracer.impl.nodes.DataFlowTargetNode;
import info.scce.dime.tracer.impl.nodes.EndNode;
import info.scce.dime.tracer.impl.nodes.ProcessNode;
import info.scce.dime.tracer.impl.nodes.SetAttributeNode;
import info.scce.dime.tracer.impl.nodes.StartNode;
import info.scce.dime.tracer.impl.nodes.UnsetAttributeNode;
import info.scce.dime.tracer.interfaces.ModelAdapter;
import info.scce.dime.tracer.interfaces.TracerNode;
import info.scce.dime.tracer.util.ContextVariable;
import info.scce.dime.tracer.util.TracerContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramsPackage;

public class ProcessModelAdapter
implements ModelAdapter {
    private String modelName;
    private File modelFile;
    private Diagram diagram;
    private Process model;
    private Process modelWrapper;

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public File getModelFile() {
        return this.modelFile;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public Process getModel() {
        return this.model;
    }

    @Override
    public EObject getModelEObject() {
        return this.model;
    }

    @Override
    public TracerNode getStartNode() {
        return new StartNode((StartSIB)this.model.getStartSIBs().get(0));
    }

    private Object getObjectById(String id) {
        for (Node node : this.model.getAllNodes()) {
            if (!node.getId().equals(id)) continue;
            return node;
        }
        for (Container container : this.model.getAllContainers()) {
            if (!container.getId().equals(id)) continue;
            return container;
        }
        for (Edge edge : this.model.getAllEdges()) {
            if (!edge.getId().equals(id)) continue;
            return edge;
        }
        return null;
    }

    @Override
    public void createContextVariables(TracerContext context) throws ClassNotFoundException {
        for (DataContext dContext : this.model.getDataContexts()) {
            for (PrimitiveVariable pVar : dContext.getPrimitiveVariables()) {
                this.createContextVarForDataNode(pVar, context);
            }
        }
    }

    private void createContextVarForDataNode(PrimitiveVariable pVar, TracerContext context) throws ClassNotFoundException {
        String id = pVar.getId();
        String name = pVar.getName();
        Class<?> type = ProcessTypeMapper.getClassForPrimitiveVariable(pVar);
        context.createContextVariable(id, name, type);
    }

    public TracerNode createTracerNode(DataFlowTarget sib) {
        if (sib instanceof StartSIB) {
            return new StartNode((StartSIB)sib);
        }
        if (sib instanceof EndSIB) {
            return new EndNode((EndSIB)sib);
        }
        if (sib instanceof ProcessSIB) {
            return new ProcessNode((ProcessSIB)sib);
        }
        if (sib instanceof AtomicSIB) {
            return new AtomicNode((AtomicSIB)sib);
        }
        if (sib instanceof CreateSIB) {
            return new CreateNode((CreateSIB)sib);
        }
        if (sib instanceof SetAttributeValueSIB) {
            return new SetAttributeNode((SetAttributeValueSIB)sib);
        }
        if (sib instanceof UnsetAttributeValueSIB) {
            return new UnsetAttributeNode((UnsetAttributeValueSIB)sib);
        }
        return null;
    }

    public Object getValueForInputStatic(InputStatic input) {
        if (input instanceof BooleanInputStatic) {
            return ((BooleanInputStatic)input).isValue();
        }
        if (input instanceof IntegerInputStatic) {
            return ((IntegerInputStatic)input).getValue();
        }
        if (input instanceof RealInputStatic) {
            return ((RealInputStatic)input).getValue();
        }
        if (input instanceof TextInputStatic) {
            return ((TextInputStatic)input).getValue();
        }
        if (input instanceof TimestampInputStatic) {
            return ((TimestampInputStatic)input).getValue();
        }
        return null;
    }

    @Override
    public void readModel(File arg0) {
        this.modelFile = arg0;
        ProcessPackage.eINSTANCE.eClass();
        PictogramsPackage.eINSTANCE.eClass();
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("process", new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.getResource(URI.createFileURI((String)arg0.getAbsolutePath()), true);
        for (EObject obj : resource.getContents()) {
            if ("Diagram".equals(obj.eClass().getName())) {
                this.diagram = (Diagram)obj;
            }
            if (!"Process".equals(obj.eClass().getName())) continue;
            this.model = (Process)obj;
        }
        this.modelName = this.model.getModelName();
    }

    @Override
    public void setModel(Resource resource, File file) throws Exception {
        this.modelFile = file;
        for (EObject obj : resource.getContents()) {
            if ("Diagram".equals(obj.eClass().getName())) {
                this.diagram = (Diagram)obj;
            }
            if (!"Process".equals(obj.eClass().getName())) continue;
            this.model = (Process)obj;
        }
        this.modelName = this.model.getModelName();
        this.modelWrapper = this.model;
    }

    public void setModel(Process newModel) throws Exception {
        this.modelName = newModel.getModelName();
        URI uri = EcoreUtil.getURI((EObject)newModel);
        this.modelFile = new File(uri.path());
        for (EObject obj : newModel.eResource().getContents()) {
            if ("Diagram".equals(obj.eClass().getName())) {
                this.diagram = (Diagram)obj;
            }
            if (!"ProcessModel".equals(obj.eClass().getName())) continue;
            this.model = (Process)obj;
        }
        this.modelWrapper = this.model;
    }

    @Override
    public void highlight(TracerNode node) {
        TracerNode sibNode;
        if (node instanceof DataFlowSourceNode) {
            sibNode = (DataFlowSourceNode)node;
            ((DataFlowSourceNode)sibNode).getSib().highlight();
        }
        if (node instanceof DataFlowTargetNode) {
            sibNode = (DataFlowTargetNode)node;
            ((DataFlowTargetNode)sibNode).getSib().highlight();
        }
    }

    @Override
    public List<ContextVariable> createInputList() throws ClassNotFoundException {
        ArrayList<ContextVariable> inputs = new ArrayList<ContextVariable>();
        StartSIB start = (StartSIB)this.model.getStartSIBs().get(0);
        for (Output output : start.getOutputs()) {
            Class<?> outputClass = null;
            if (output instanceof PrimitiveOutputPort) {
                outputClass = ProcessTypeMapper.getClassForPrimitiveOutputPort((PrimitiveOutputPort)output);
            }
            ContextVariable cv = new ContextVariable();
            cv.setName(output.getName());
            cv.setType(outputClass);
            inputs.add(cv);
        }
        return inputs;
    }
}

