/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.mgl.ui.handlers;

import com.google.inject.Inject;
import com.google.inject.Provider;
import de.jabc.cinco.meta.core.ui.listener.MGLSelectionListener;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class MGLGenerationHandler
extends AbstractHandler {
    @Inject
    private IGenerator generator;
    @Inject
    private Provider<EclipseResourceFileSystemAccess2> fileAccessProvider;
    @Inject
    IResourceDescriptions resourceDescriptions;
    @Inject
    IResourceSetProvider resourceSetProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            this.callGenerator();
        }
        catch (Exception e) {
            throw new ExecutionException("Exception in MGL 2 Ecore Transformation", (Throwable)e);
        }
        return null;
    }

    private void callGenerator() {
        IFile file = MGLSelectionListener.INSTANCE.getCurrentMGLFile();
        ResourceSet rSet = this.resourceSetProvider.get(file.getProject());
        Resource res = rSet.createResource(URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true));
        try {
            res.load(null);
            EclipseResourceFileSystemAccess2 access = (EclipseResourceFileSystemAccess2)this.fileAccessProvider.get();
            access.setProject(file.getProject());
            access.setMonitor(null);
            OutputConfiguration defaultOutput = new OutputConfiguration("DEFAULT_OUTPUT");
            defaultOutput.setOutputDirectory("./src-gen");
            defaultOutput.setCreateOutputDirectory(true);
            defaultOutput.setOverrideExistingResources(true);
            defaultOutput.setCleanUpDerivedResources(true);
            defaultOutput.setSetDerivedProperty(true);
            defaultOutput.setCanClearOutputDirectory(true);
            access.getOutputConfigurations().put("DEFAULT_OUTPUT", defaultOutput);
            access.setPostProcessor(new EclipseResourceFileSystemAccess2.IFileCallback(){

                public boolean beforeFileDeletion(IFile file) {
                    return false;
                }

                public void afterFileUpdate(IFile file) {
                }

                public void afterFileCreation(IFile file) {
                }
            });
            this.generator.doGenerate(res, (IFileSystemAccess)access);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            file.getProject().refreshLocal(0, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

