/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.mgl.ui;

import com.google.inject.Inject;
import com.google.inject.Provider;
import de.jabc.cinco.meta.core.mgl.ui.internal.MGLActivator;
import de.jabc.cinco.meta.core.utils.CincoUtil;
import de.jabc.cinco.meta.util.xapi.ResourceExtension;
import mgl.Annotation;
import mgl.GraphModel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;
import style.Style;
import style.Styles;

public class MGLHyperLinkHelper
extends HyperlinkHelper {
    private String[] annotationsForClasses = new String[]{"contextMenuAction", "doubleClickAction", "preDelete", "postCreate", "postAttributeValueChange", "postDelete", "postMove", "postResize", "postSelect", "mcam_checkmodule"};
    @Inject
    Provider<XtextHyperlink> provider;
    @Inject
    IResourceServiceProvider.Registry reg;

    public MGLHyperLinkHelper() {
        MGLActivator.getInstance().getInjector("de.jabc.cinco.meta.core.mgl.MGL").injectMembers((Object)this);
    }

    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        EObjectAtOffsetHelper oHelper = new EObjectAtOffsetHelper();
        EObject object = oHelper.resolveElementAt(resource, offset);
        if (!(object instanceof Annotation)) {
            return;
        }
        Annotation annot = (Annotation)object;
        if ("style".equals(annot.getName())) {
            GraphModel gm = (GraphModel)new ResourceExtension().getContent((Resource)resource, GraphModel.class, 0);
            if (gm == null) {
                return;
            }
            Style style = CincoUtil.findStyle((Styles)CincoUtil.getStyles((GraphModel)gm), (String)((String)annot.getValue().get(0)));
            if (style == null) {
                return;
            }
            ICompositeNode annotNode = NodeModelUtils.getNode((EObject)annot);
            Region region = new Region(annotNode.getOffset(), annotNode.getLength());
            URIConverter uriConverter = resource.getResourceSet().getURIConverter();
            URI uri = EcoreUtil.getURI((EObject)style);
            URI normUri = uri.isPlatformResource() ? uri : uriConverter.normalize(uri);
            XtextHyperlink xtextHyperlink = (XtextHyperlink)this.getHyperlinkProvider().get();
            xtextHyperlink.setHyperlinkRegion(region);
            xtextHyperlink.setHyperlinkText(this.getLabelProvider().getText((Object)style));
            xtextHyperlink.setURI(normUri);
            acceptor.accept((IHyperlink)xtextHyperlink);
        } else if (this.isJavaClassAnnotation(annot.getName())) {
            GraphModel gModel = (GraphModel)new ResourceExtension().getContent((Resource)resource, GraphModel.class, 0);
            if (gModel == null) {
                return;
            }
            Annotation contextMenu = annot;
            ICompositeNode annotNode = NodeModelUtils.getNode((EObject)annot);
            Region region = new Region(annotNode.getOffset(), annotNode.getLength());
            URIConverter uriConverter = resource.getResourceSet().getURIConverter();
            URI uri2 = URI.createURI((String)((String)annot.getValue().get(0)));
            String URI2 = uri2.toString();
            String path = this.searchPath(URI2);
            if (path == null) {
                return;
            }
            URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
            URI normUri = uri.isPlatformResource() ? uri : uriConverter.normalize(uri);
            XtextHyperlink xtextHyperlink = (XtextHyperlink)this.getHyperlinkProvider().get();
            xtextHyperlink.setHyperlinkRegion(region);
            xtextHyperlink.setHyperlinkText(this.getLabelProvider().getText((Object)contextMenu));
            xtextHyperlink.setURI(normUri);
            acceptor.accept((IHyperlink)xtextHyperlink);
        }
    }

    private boolean isJavaClassAnnotation(String annotName) {
        String[] stringArray = this.annotationsForClasses;
        int n = this.annotationsForClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String knownName = stringArray[n2];
            if (knownName.equals(annotName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String searchPath(String searchClass) {
        IProject[] projects;
        String path = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            IJavaProject jproject = JavaCore.create((IProject)iProject);
            if (jproject.exists()) {
                try {
                    IType type = jproject.findType(searchClass);
                    if (type != null) {
                        return type.getPath().toString();
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return path;
    }
}

