/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.mgl.ui;

import com.google.inject.Inject;
import de.jabc.cinco.meta.core.mgl.ui.MGLHyperLinkHelper;
import mgl.Annotation;
import mgl.ModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkHelper;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

public class MGLHyperLinkDetector
implements IHyperlinkDetector {
    @Inject
    private IHyperlinkHelper helper;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (!(textViewer instanceof XtextSourceViewer)) {
            return null;
        }
        EObjectAtOffsetHelper resolver = new EObjectAtOffsetHelper();
        XtextSourceViewer viewer = (XtextSourceViewer)textViewer;
        XtextDocument doc = (XtextDocument)viewer.getInput();
        Resource res = new ResourceSetImpl().getResource(doc.getResourceURI(), true);
        EObject object = resolver.resolveElementAt((XtextResource)res, region.getOffset());
        if (object instanceof Annotation && ((Annotation)object).getParent() instanceof ModelElement) {
            return new MGLHyperLinkHelper().createHyperlinksByOffset((XtextResource)res, region.getOffset(), canShowMultipleHyperlinks);
        }
        return this.helper.createHyperlinksByOffset((XtextResource)res, region.getOffset(), canShowMultipleHyperlinks);
    }
}

