/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.validation;

import de.jabc.cinco.meta.core.ge.style.validation.JStyleValidator;
import de.jabc.cinco.meta.core.utils.CincoUtil;
import de.jabc.cinco.meta.core.utils.PathValidator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import style.AbstractPosition;
import style.AbstractShape;
import style.Alignment;
import style.Appearance;
import style.ConnectionDecorator;
import style.ContainerShape;
import style.GraphicsAlgorithm;
import style.Image;
import style.NodeStyle;
import style.Size;
import style.Style;
import style.StylePackage;

public class StyleValidator
extends JStyleValidator {
    public static final String NOT_EXPORTED = "package is not exported";
    public static final String NO_PATH = "noPathSpecified";
    public static final String INVALID_PATH = "invalidPath";

    @Check
    public void checkConnectionDecoratorShapePosition(ConnectionDecorator cd) {
        if (cd.getDecoratorShape() != null && cd.getDecoratorShape() instanceof AbstractShape) {
            boolean _tripleNotEquals;
            GraphicsAlgorithm _decoratorShape = cd.getDecoratorShape();
            AbstractShape abs = (AbstractShape)_decoratorShape;
            AbstractPosition _position = abs.getPosition();
            boolean bl = _tripleNotEquals = _position != null;
            if (_tripleNotEquals) {
                this.error("Positions are not allowed", (EStructuralFeature)StylePackage.Literals.CONNECTION_DECORATOR__DECORATOR_SHAPE);
            }
        }
    }

    @Check
    public void checkConnectionDecoratorShapeSize(ConnectionDecorator cd) {
        GraphicsAlgorithm _decoratorShape;
        AbstractShape abs;
        if (cd.getDecoratorShape() != null && cd.getDecoratorShape() instanceof AbstractShape && ((abs = (AbstractShape)(_decoratorShape = cd.getDecoratorShape())).getSize().getHeight() < 0 || abs.getSize().getWidth() < 0 || abs.getSize().getHeight() > 1000 || abs.getSize().getWidth() > 1000)) {
            this.warning("The size should be in [0,1000]", (EStructuralFeature)StylePackage.Literals.CONNECTION_DECORATOR__DECORATOR_SHAPE);
        }
    }

    @Check
    public void checkConnectionDecoratorLocation(ConnectionDecorator cd) {
        if (cd.getLocation() > 1.0 || cd.getLocation() < 0.0) {
            this.warning("The location should be in [0,1]", (EStructuralFeature)StylePackage.Literals.CONNECTION_DECORATOR__LOCATION);
        }
    }

    @Check
    public void checkImagePath(Image image) {
        String _checkPath;
        String retVal;
        boolean _isEmpty;
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)image.getPath());
        if (_isNullOrEmpty) {
            this.warning("No Path specified", (EStructuralFeature)StylePackage.Literals.IMAGE__PATH, NO_PATH, new String[0]);
        }
        boolean bl = _not = !(_isEmpty = (retVal = (_checkPath = PathValidator.checkPath((EObject)image, (String)image.getPath()))).isEmpty());
        if (_not) {
            this.error(retVal, (EStructuralFeature)StylePackage.Literals.IMAGE__PATH, INVALID_PATH, new String[0]);
        }
    }

    @Check
    public void checkAppearanceInheritance(Appearance app) {
        boolean _not;
        ArrayList<String> retvalList = this.checkInheritance(app);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(retvalList);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            this.error("Circle in appearance inheritances caused by: " + retvalList, (EStructuralFeature)StylePackage.Literals.APPEARANCE__PARENT);
        }
    }

    public ArrayList<String> checkInheritance(Appearance app) {
        Appearance current = app;
        ArrayList<String> apps = new ArrayList<String>();
        while (current != null) {
            boolean _contains = apps.contains(current.getName());
            if (_contains) {
                return apps;
            }
            apps.add(current.getName());
            current = current.getParent();
        }
        return null;
    }

    @Check
    public void checkColorBackground(Appearance app) {
        if (app.getBackground().getB() > 255 || app.getBackground().getR() > 255 || app.getBackground().getG() > 255) {
            this.error("Number(s) too large", (EStructuralFeature)StylePackage.Literals.APPEARANCE__BACKGROUND);
        }
        if (app.getBackground().getB() < 0 || app.getBackground().getR() < 0 || app.getBackground().getG() < 0) {
            this.error("Number(s) has to be positiv", (EStructuralFeature)StylePackage.Literals.APPEARANCE__BACKGROUND);
        }
    }

    @Check
    public void checkColorForeground(Appearance app) {
        if (app.getForeground().getB() > 255 || app.getForeground().getR() > 255 || app.getForeground().getG() > 255) {
            this.error("Number(s) too large", (EStructuralFeature)StylePackage.Literals.APPEARANCE__FOREGROUND);
        }
        if (app.getForeground().getB() < 0 || app.getForeground().getR() < 0 || app.getForeground().getG() < 0) {
            this.error("Number(s) has to be positiv", (EStructuralFeature)StylePackage.Literals.APPEARANCE__FOREGROUND);
        }
    }

    @Check
    public void checkMainShapePosition(AbstractShape abs) {
        AbstractPosition pos;
        EObject _eContainer = abs.eContainer();
        if (_eContainer instanceof NodeStyle && (pos = abs.getPosition()) instanceof Alignment) {
            this.error("Relativ positions are not allowed in the topmost element", (EStructuralFeature)StylePackage.Literals.ABSTRACT_SHAPE__POSITION);
        }
    }

    @Check
    public void checkMainShapeSize(AbstractShape abs) {
        Size size;
        EObject _eContainer = abs.eContainer();
        if (_eContainer instanceof NodeStyle && ((size = abs.getSize()).isHeightFixed() || size.isWidthFixed())) {
            this.error("Root shape's size is not allowed to be fixed", (EStructuralFeature)StylePackage.Literals.ABSTRACT_SHAPE__SIZE);
        }
    }

    @Check
    public void checkAnchorShapeUnique(AbstractShape abs) {
        boolean _isAnchorShape = abs.isAnchorShape();
        if (_isAnchorShape) {
            boolean _greaterThan;
            AbstractShape rootShape = abs;
            ContainerShape currentParentShape = abs.getParentContainerShape();
            while (currentParentShape != null) {
                rootShape = currentParentShape;
                currentParentShape = rootShape.getParentContainerShape();
            }
            int _anchorShapeCount = this.anchorShapeCount(rootShape);
            boolean bl = _greaterThan = _anchorShapeCount > 1;
            if (_greaterThan) {
                this.error("Only one shape per style may be marked as an achor", (EStructuralFeature)StylePackage.Literals.ABSTRACT_SHAPE__ANCHOR_SHAPE);
            }
        }
    }

    private int anchorShapeCount(AbstractShape abs) {
        ArrayList<AbstractShape> shapesToCheck = new ArrayList<AbstractShape>();
        shapesToCheck.add(abs);
        int anchorShapeOccurances = 0;
        int i = 0;
        while (i < shapesToCheck.size()) {
            AbstractShape currentShape = (AbstractShape)shapesToCheck.get(i);
            boolean _isAnchorShape = currentShape.isAnchorShape();
            if (_isAnchorShape) {
                ++anchorShapeOccurances;
            }
            if (currentShape instanceof ContainerShape) {
                shapesToCheck.addAll((Collection<AbstractShape>)((ContainerShape)currentShape).getChildren());
            }
            ++i;
        }
        return anchorShapeOccurances;
    }

    @Check
    public void checkAppearanceProviderAnnotation(Style style) {
        boolean _tripleNotEquals;
        String _appearanceProvider = style.getAppearanceProvider();
        boolean bl = _tripleNotEquals = _appearanceProvider != null;
        if (_tripleNotEquals) {
            boolean _not;
            boolean _isEmpty = style.getAppearanceProvider().isEmpty();
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                boolean _not_1;
                String parameter = style.getAppearanceProvider().replace("\"", "");
                boolean _equals = parameter.equals("");
                boolean bl3 = _not_1 = !_equals;
                if (_not_1) {
                    IType correctFile = this.findClass(parameter);
                    if (correctFile != null) {
                        boolean _exists = correctFile.exists();
                        if (_exists) {
                            IProject[] projects;
                            String packageExport = correctFile.getPackageFragment().getElementName();
                            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                            IProject[] iProjectArray = projects = root.getProjects();
                            int n = projects.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IProject project = iProjectArray[n2];
                                IJavaProject package_ = this.findPackage(parameter);
                                if (package_ == null) {
                                    this.error("Package not found", (EStructuralFeature)StylePackage.Literals.STYLE__APPEARANCE_PROVIDER);
                                } else {
                                    IProject project1;
                                    boolean isExported;
                                    IFolder folder;
                                    IFile manifest;
                                    boolean _exists_1;
                                    boolean _equals_1 = project.getName().equals(package_.getElementName());
                                    if (_equals_1 && (_exists_1 = (manifest = (folder = project.getFolder("META-INF")).getFile("MANIFEST.MF")).exists()) && !(isExported = this.findExportedPackage(project1 = project, packageExport))) {
                                        this.warning("Corresponding package is not exported", (EStructuralFeature)StylePackage.Literals.STYLE__APPEARANCE_PROVIDER, NOT_EXPORTED, new String[0]);
                                    }
                                }
                                ++n2;
                            }
                        } else {
                            this.error("Java Class does not exists", (EStructuralFeature)StylePackage.Literals.STYLE__APPEARANCE_PROVIDER);
                        }
                    } else {
                        this.error("Java Class does not exists", (EStructuralFeature)StylePackage.Literals.STYLE__APPEARANCE_PROVIDER);
                    }
                } else {
                    this.error("Java Class cannot be an empty String", (EStructuralFeature)StylePackage.Literals.STYLE__APPEARANCE_PROVIDER);
                }
            } else {
                this.error("AppearanceProvider needs a Java Class as a parameter", (EStructuralFeature)StylePackage.Literals.STYLE__APPEARANCE_PROVIDER);
            }
        }
    }

    public IJavaProject findPackage(String parameter) {
        IProject[] projects;
        IType javaClass = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IProject project = iProjectArray[n2];
                IJavaProject _create = JavaCore.create((IProject)project);
                IJavaProject jproject = _create;
                boolean _exists = jproject.exists();
                if (_exists) {
                    try {
                        javaClass = jproject.findType(parameter);
                        if (javaClass != null) {
                            return jproject;
                        }
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) break block5;
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public boolean findExportedPackage(IProject project, String packageName) {
        try {
            boolean _contains;
            boolean _not;
            IFile iManiFile = project.getFolder("META-INF").getFile("MANIFEST.MF");
            CincoUtil.refreshFiles(null, (IFile[])new IFile[]{iManiFile});
            InputStream _contents = iManiFile.getContents();
            Manifest manifest = new Manifest(_contents);
            String value = manifest.getMainAttributes().getValue("Export-Package");
            if (value == null) {
                String _string;
                value = _string = new String("");
            }
            boolean bl = _not = !(_contains = value.contains(packageName));
            return !_not;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IType findClass(String parameter) {
        IProject[] projects;
        IType javaClass = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IProject project = iProjectArray[n2];
                IJavaProject _create = JavaCore.create((IProject)project);
                IJavaProject jproject = _create;
                boolean _exists = jproject.exists();
                if (_exists) {
                    try {
                        javaClass = jproject.findType(parameter);
                        if (javaClass != null) {
                            return javaClass;
                        }
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) break block5;
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            }
            ++n2;
        }
        return javaClass;
    }
}

