/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.validation;

import de.jabc.cinco.meta.core.ge.style.validation.AbstractStyleValidator;
import de.jabc.cinco.meta.core.utils.PathValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import style.AbstractShape;
import style.ConnectionDecorator;
import style.ContainerShape;
import style.EdgeStyle;
import style.Image;
import style.MultiText;
import style.NodeStyle;
import style.Style;
import style.StylePackage;
import style.Styles;
import style.Text;

public class JStyleValidator
extends AbstractStyleValidator {
    public static String NO_PATH = "noPathSpecified";
    public static String INVALID_PATH = "invalidPath";

    @Check
    public void imagePath(Image image) {
        String retVal;
        if (image.getPath() == null || image.getPath().isEmpty()) {
            this.warning("No Path specified", (EStructuralFeature)StylePackage.Literals.IMAGE__PATH, NO_PATH, new String[0]);
        }
        if (!(retVal = PathValidator.checkPath((EObject)image, (String)image.getPath())).isEmpty()) {
            this.error(retVal, (EStructuralFeature)StylePackage.Literals.IMAGE__PATH, INVALID_PATH, new String[0]);
        }
    }

    @Check
    public void checkUniqueStyleNames(NodeStyle ns) {
        List nodeStyles = this.getStyles((Style)ns).stream().filter(s -> s instanceof NodeStyle && s.getName().equals(ns.getName())).collect(Collectors.toList());
        if (nodeStyles.size() >= 2) {
            this.error("Duplicate nodeStyle definition: " + ns.getName(), (EStructuralFeature)StylePackage.Literals.STYLE__NAME);
        }
    }

    @Check
    public void checkUniqueStyleNames(EdgeStyle es) {
        List tmp = ((Styles)es.eContainer()).getStyles().stream().filter(s -> s instanceof EdgeStyle && s.getName().equals(es.getName())).collect(Collectors.toList());
        if (tmp.size() >= 2) {
            this.error("Duplicate edgeStyle definition: " + es.getName(), (EStructuralFeature)StylePackage.Literals.STYLE__NAME);
        }
    }

    @Check
    public void checkUniqueDecoratorNames(ConnectionDecorator cd) {
        List filtered = ((EdgeStyle)cd.eContainer()).getDecorator().stream().filter(tmp -> tmp.getName() != null && tmp.getName().equals(cd.getName()) && !tmp.getName().isEmpty()).collect(Collectors.toList());
        if (filtered.size() >= 2) {
            this.error("Duplicate decorator name: " + cd.getName(), (EStructuralFeature)StylePackage.Literals.CONNECTION_DECORATOR__NAME);
        }
    }

    @Check
    public void checkNoShapeNamesInDecorator(ConnectionDecorator cd) {
        AbstractShape abstractShape = (AbstractShape)cd.getDecoratorShape();
        String sName = abstractShape.getName();
        if (sName != null && !sName.isEmpty()) {
            this.error("Naming elements not allowed here. Assign a name directly to the decorator", (EStructuralFeature)StylePackage.Literals.CONNECTION_DECORATOR__DECORATOR_SHAPE);
        }
    }

    @Check
    public void checkUniqueShapeNames(AbstractShape as) {
        AbstractShape mainShape = this.getMainShape(as);
        ArrayList<AbstractShape> shapes = new ArrayList<AbstractShape>();
        this.getAllShapes(mainShape, shapes);
        List namedShapes = shapes.stream().filter(s -> s.getName() != null && s.getName().equals(as.getName())).collect(Collectors.toList());
        if (namedShapes.size() >= 2) {
            this.error("Duplicate shape name...", (EStructuralFeature)StylePackage.Literals.ABSTRACT_SHAPE__NAME);
        }
    }

    @Check
    public void checkParameterCount(Style s) {
        int parameterCount = s.getParameterCount();
        if (parameterCount < 0) {
            this.error("Negative parameter count not allowed...", (EStructuralFeature)StylePackage.Literals.STYLE__PARAMETER_COUNT);
        }
        if (parameterCount > 0) {
            boolean containsTextElement = false;
            ArrayList<AbstractShape> shapes = new ArrayList<AbstractShape>();
            if (s instanceof NodeStyle) {
                this.getAllShapes(((NodeStyle)s).getMainShape(), shapes);
            } else {
                this.getAllShapes((EdgeStyle)s, shapes);
            }
            for (AbstractShape as : shapes) {
                if (!(as instanceof Text) && !(as instanceof MultiText)) continue;
                containsTextElement = true;
                break;
            }
            if (!containsTextElement) {
                this.warning("Parameter count is greater than 1 but no (multi)text element defined...", (EStructuralFeature)StylePackage.Literals.STYLE__PARAMETER_COUNT);
            }
        }
    }

    private List<Style> getStyles(Style s) {
        return ((Styles)s.eContainer()).getStyles();
    }

    private void getAllShapes(AbstractShape as, List<AbstractShape> result) {
        result.add(as);
        if (as instanceof ContainerShape) {
            for (AbstractShape s : ((ContainerShape)as).getChildren()) {
                this.getAllShapes(s, result);
            }
        }
    }

    private void getAllShapes(EdgeStyle es, List<AbstractShape> result) {
        for (ConnectionDecorator cd : es.getDecorator()) {
            result.add((AbstractShape)cd.getDecoratorShape());
        }
    }

    private AbstractShape getMainShape(AbstractShape as) {
        AbstractShape i = as;
        while (i != null && i.eContainer() instanceof AbstractShape) {
            i = (AbstractShape)i.eContainer();
        }
        return i;
    }
}

