/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.feature.handler;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.ui.listener.MGLSelectionListener;
import de.jabc.cinco.meta.core.utils.PathValidator;
import de.jabc.cinco.meta.util.xapi.FileExtension;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import mgl.Annotation;
import mgl.MGLModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import productDefinition.CincoProduct;
import productDefinition.MGLDescriptor;

public class GenerateFeatureXML {
    public static void generate(final String packageName, final HashMap<String, Set<String>> annotationToMGLPackageMap, final HashMap<String, Set<String>> annotationToPackageMap, final HashMap<String, Set<String>> annotationToFragmentMap, final HashMap<String, Set<String>> annotationToMGLFragmentMap, Set<String> otherPluginIDs, Set<String> otherFragmentIDs, IProject featureProject) {
        try {
            final Set<String> plugins = otherPluginIDs;
            final Set<String> fragments = otherFragmentIDs;
            Consumer<MGLModel> _function = new Consumer<MGLModel>(){

                @Override
                public void accept(MGLModel model) {
                    Iterables.addAll((Collection)plugins, GenerateFeatureXML.collectPlugins(model, annotationToPackageMap, annotationToMGLPackageMap, packageName));
                    Iterables.addAll((Collection)fragments, GenerateFeatureXML.collectFragments(model, annotationToFragmentMap, annotationToMGLFragmentMap, packageName));
                }
            };
            GenerateFeatureXML.allMGLs().forEach(_function);
            CharSequence featureXML = GenerateFeatureXML.generateXML(plugins, fragments, packageName);
            IFile xmlFile = featureProject.getFile("feature.xml");
            boolean _exists = xmlFile.exists();
            if (_exists) {
                String _string = featureXML.toString();
                StringInputStream _stringInputStream = new StringInputStream(_string);
                xmlFile.setContents((InputStream)_stringInputStream, true, true, null);
            } else {
                String _string_1 = featureXML.toString();
                StringInputStream _stringInputStream_1 = new StringInputStream(_string_1);
                xmlFile.create((InputStream)_stringInputStream_1, true, null);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static CharSequence generateXML(Iterable<String> plugins, Iterable<String> fragments, String packageName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<feature id=\"");
        _builder.append(packageName);
        _builder.append(".feature\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("label=\"");
        _builder.append(packageName, "\t");
        _builder.append(" Feature \"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("version=\"1.0.0.qualifier\">");
        _builder.newLine();
        _builder.append("<includes");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("id=\"de.jabc.cinco.meta.feature\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("version=\"0.0.0\"/>");
        _builder.newLine();
        for (String pl : plugins) {
            boolean _notEquals;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(packageName);
            _builder_1.append(".feature");
            String _string = _builder_1.toString();
            boolean bl = _notEquals = !Objects.equal((Object)pl, (Object)_string);
            if (!_notEquals) continue;
            _builder.append("\t");
            _builder.append("<plugin");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("id=\"");
            _builder.append(pl, "\t\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("download-size=\"0\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("install-size=\"0\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("version=\"0.0.0\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("unpack=\"false\"/>");
            _builder.newLine();
        }
        for (String frg : fragments) {
            _builder.append("\t");
            _builder.append("<plugin");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("id=\"");
            _builder.append(frg, "\t\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("download-size=\"0\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("install-size=\"0\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("version=\"0.0.0\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("fragment=\"true\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("unpack=\"false\"/>");
            _builder.newLine();
        }
        _builder.append("</feature>");
        _builder.newLine();
        return _builder;
    }

    public static Iterable<String> collectPlugins(MGLModel model, final HashMap<String, Set<String>> annotationToPackageMap, final HashMap<String, Set<String>> annotationToMGLPackageMap, final String packageName) {
        Functions.Function1<Annotation, Iterable<String>> _function = new Functions.Function1<Annotation, Iterable<String>>(){

            public Iterable<String> apply(Annotation anno) {
                boolean _tripleNotEquals;
                Iterable _xblockexpression = null;
                HashSet pkgs = (HashSet)annotationToPackageMap.get(anno.getName());
                if (pkgs == null) {
                    HashSet _hashSet;
                    pkgs = _hashSet = new HashSet();
                }
                Iterable _xifexpression = null;
                Set _get = (Set)annotationToMGLPackageMap.get(anno.getName());
                boolean bl = _tripleNotEquals = _get != null;
                if (_tripleNotEquals) {
                    Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

                        public String apply(String mglDepPkg) {
                            return String.format("%s.%s", packageName, mglDepPkg);
                        }
                    };
                    _xifexpression = IterableExtensions.map((Iterable)((Iterable)annotationToMGLPackageMap.get(anno.getName())), (Functions.Function1)_function);
                } else {
                    _xifexpression = new HashSet();
                }
                HashSet mglPkgs = _xifexpression;
                _xblockexpression = Iterables.concat(pkgs, mglPkgs);
                return _xblockexpression;
            }
        };
        return Iterables.concat((Iterable)ListExtensions.map((List)model.getAnnotations(), (Functions.Function1)_function));
    }

    public static Iterable<String> collectFragments(MGLModel model, final HashMap<String, Set<String>> annotationToFragmentMap, final HashMap<String, Set<String>> annotationToMGLFragmentMap, final String packageName) {
        Functions.Function1<Annotation, Iterable<String>> _function = new Functions.Function1<Annotation, Iterable<String>>(){

            public Iterable<String> apply(Annotation anno) {
                boolean _tripleNotEquals;
                Iterable _xblockexpression = null;
                HashSet frgm = (HashSet)annotationToFragmentMap.get(anno.getName());
                if (frgm == null) {
                    HashSet _hashSet;
                    frgm = _hashSet = new HashSet();
                }
                Iterable _xifexpression = null;
                Set _get = (Set)annotationToMGLFragmentMap.get(anno.getName());
                boolean bl = _tripleNotEquals = _get != null;
                if (_tripleNotEquals) {
                    Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

                        public String apply(String mglDepFrg) {
                            return String.format("%s.%s", packageName, mglDepFrg);
                        }
                    };
                    _xifexpression = IterableExtensions.map((Iterable)((Iterable)annotationToMGLFragmentMap.get(anno.getName())), (Functions.Function1)_function);
                } else {
                    _xifexpression = new HashSet();
                }
                HashSet mglFrgm = _xifexpression;
                _xblockexpression = Iterables.concat(frgm, mglFrgm);
                return _xblockexpression;
            }
        };
        return Iterables.concat((Iterable)ListExtensions.map((List)model.getAnnotations(), (Functions.Function1)_function));
    }

    public static List<MGLModel> allMGLs() {
        List _xblockexpression = null;
        IFile cpdFile = MGLSelectionListener.INSTANCE.getSelectedCPDFile();
        CincoProduct cpd = MGLSelectionListener.INSTANCE.getSelectedCPD();
        final IProject cpdProject = cpdFile.getProject();
        Functions.Function1<MGLDescriptor, MGLModel> _function = new Functions.Function1<MGLDescriptor, MGLModel>(){

            public MGLModel apply(MGLDescriptor descriptor) {
                MGLModel _xblockexpression = null;
                FileExtension fileExtension = new FileExtension();
                String path = PathValidator.getRelativePath((String)descriptor.getMglPath(), (IProject)cpdProject);
                IFile file = cpdProject.getFile(path);
                _xblockexpression = (MGLModel)fileExtension.getContent(file, MGLModel.class);
                return _xblockexpression;
            }
        };
        _xblockexpression = ListExtensions.map((List)cpd.getMgls(), (Functions.Function1)_function);
        return _xblockexpression;
    }
}

