/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.feature.handler;

import com.google.inject.Inject;
import de.jabc.cinco.meta.core.feature.handler.FeaturePOMTemplate;
import de.jabc.cinco.meta.core.feature.handler.GenerateFeatureXML;
import de.jabc.cinco.meta.core.pluginregistry.PluginRegistry;
import de.jabc.cinco.meta.core.ui.listener.MGLSelectionListener;
import de.jabc.cinco.meta.core.utils.BundleRegistry;
import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.util.StringInputStream;
import productDefinition.CincoProduct;

public class GenerateFeatureProjectHandler
extends AbstractHandler {
    @Inject
    IResourceDescriptions resourceDescriptions;
    @Inject
    IResourceSetProvider resourceSetProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IFile file = MGLSelectionListener.INSTANCE.getSelectedCPDFile();
            if (file != null) {
                ResourceSetImpl rSet = new ResourceSetImpl();
                this.generateFeature(file, (ResourceSet)rSet);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private void generateFeature(IFile file, ResourceSet rSet) {
        Resource res = rSet.createResource(URI.createPlatformResourceURI((String)file.getFullPath().toPortableString(), (boolean)true));
        try {
            res.load(null);
            CincoProduct cpd = (CincoProduct)res.getContents().get(0);
            String packageName = ProjectCreator.getProjectSymbolicName((IProject)ProjectCreator.getProject((Resource)cpd.eResource()));
            String projectName = String.valueOf(packageName) + ".feature";
            ArrayList<String> srcFolders = new ArrayList<String>();
            srcFolders.add("src");
            ArrayList referencedProjects = new ArrayList();
            HashSet<String> requiredBundles = new HashSet<String>();
            IResource iRes = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(cpd.eResource().getURI().toPlatformString(true)));
            String symbolicName = iRes != null ? ProjectCreator.getProjectSymbolicName((IProject)iRes.getProject()) : file.getProject().getName();
            requiredBundles.add(symbolicName);
            ArrayList exportedPackages = new ArrayList();
            ArrayList<String> additionalNatures = new ArrayList<String>();
            additionalNatures.add("org.eclipse.pde.FeatureNature");
            IProject featureProject = ProjectCreator.createProject((String)projectName, srcFolders, referencedProjects, requiredBundles, exportedPackages, additionalNatures, null, (boolean)false);
            try {
                HashMap annotationToMGLPackageMap = PluginRegistry.getInstance().getMGLDependentPlugins();
                HashMap annotationToPackageMap = PluginRegistry.getInstance().getUsedPlugins();
                HashMap annotationToFragmentMap = PluginRegistry.getInstance().getUsedFragments();
                HashMap annotationToMGLFragmentMap = PluginRegistry.getInstance().getMGLDependentFragments();
                HashSet<String> otherPluginIDs = new HashSet<String>();
                otherPluginIDs.addAll(BundleRegistry.INSTANCE.getPluginIDs());
                otherPluginIDs.addAll(this.customPluginIDs());
                Set otherFragmentIDs = BundleRegistry.INSTANCE.getFragmentIDs();
                GenerateFeatureXML.generate(packageName, annotationToMGLPackageMap, annotationToPackageMap, annotationToFragmentMap, annotationToMGLFragmentMap, otherPluginIDs, otherFragmentIDs, featureProject);
            }
            catch (Exception e) {
                throw new Exception("Could not create feature.xml", e);
            }
            try {
                this.mavenizeFeatureProject(featureProject, packageName);
            }
            catch (Exception e) {
                throw new Exception("Could not create pom.xml for feature project", e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Set<String> customPluginIDs() {
        HashSet<String> ids = new HashSet<String>();
        ids.add("org.apache.felix.scr");
        return ids;
    }

    private void mavenizeFeatureProject(IProject featureProject, String packageName) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        StringInputStream content = new StringInputStream(FeaturePOMTemplate.content(packageName).toString());
        IFile productPOMFile = featureProject.getFile("pom.xml");
        if (productPOMFile.exists()) {
            productPOMFile.setContents((InputStream)content, false, false, (IProgressMonitor)monitor);
        } else {
            productPOMFile.create((InputStream)content, false, (IProgressMonitor)monitor);
        }
    }
}

