/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.gratext.tmpl.file;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.plugin.template.FileTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mgl.Annotatable;
import mgl.Attribute;
import mgl.ComplexAttribute;
import mgl.ContainingElement;
import mgl.Edge;
import mgl.Enumeration;
import mgl.GraphModel;
import mgl.MGLModel;
import mgl.ModelElement;
import mgl.Node;
import mgl.NodeContainer;
import mgl.PrimitiveAttribute;
import mgl.ReferencedModelElement;
import mgl.ReferencedType;
import mgl.Type;
import mgl.UserDefinedType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import productDefinition.Annotation;

public class GrammarTmpl
extends FileTemplate {
    @Extension
    protected MGLUtil _mGLUtil = new MGLUtil();
    @Extension
    protected GeneratorUtils _generatorUtils = GeneratorUtils.getInstance();
    private final Map<String, String> importMappings = CollectionLiterals.newHashMap();
    private Map<MGLModel, Set<Type>> typesWithOrigins = CollectionLiterals.newHashMap();

    public String getTargetFileName() {
        StringConcatenation _builder = new StringConcatenation();
        String _fileName = this._generatorUtils.getFileName(this.getModel());
        _builder.append(_fileName);
        _builder.append("Gratext.xtext");
        return _builder.toString();
    }

    public void init() {
        Functions.Function1<ReferencedType, Pair<String, String>> _function = new Functions.Function1<ReferencedType, Pair<String, String>>(){

            public Pair<String, String> apply(ReferencedType pr) {
                Pair _switchResult = null;
                EObject _type = GrammarTmpl.this._graphModelExtension.getType(pr);
                boolean _matched = false;
                if (_type instanceof ModelElement) {
                    boolean _not;
                    _matched = true;
                    Pair _xifexpression = null;
                    boolean _isLocal = ((ReferencedModelElement)pr).isLocal();
                    boolean bl = _not = !_isLocal;
                    if (_not) {
                        String _alias = GrammarTmpl.this.alias(MGLUtil.mglModel((Object)pr.getImprt()));
                        String _nsURI = MGLUtil.nsURI((Annotatable)MGLUtil.mglModel((Object)pr.getImprt()));
                        _xifexpression = Pair.of((Object)_alias, (Object)_nsURI);
                    } else {
                        String _alias_1 = GrammarTmpl.this.alias(GrammarTmpl.this.getModel());
                        String _nsURI_1 = MGLUtil.nsURI((Annotatable)GrammarTmpl.this.getModel());
                        _xifexpression = Pair.of((Object)_alias_1, (Object)_nsURI_1);
                    }
                    _switchResult = _xifexpression;
                }
                if (!_matched && _type instanceof EClassifier) {
                    _matched = true;
                    EObject _type_1 = GrammarTmpl.this._graphModelExtension.getType(pr);
                    String _name = ((EClassifier)_type_1).getEPackage().getName();
                    EObject _type_2 = GrammarTmpl.this._graphModelExtension.getType(pr);
                    String _nsURI = ((EClassifier)_type_2).getEPackage().getNsURI();
                    _switchResult = Pair.of((Object)_name, (Object)_nsURI);
                }
                return _switchResult;
            }
        };
        Functions.Function1<Pair<String, String>, Boolean> _function_1 = new Functions.Function1<Pair<String, String>, Boolean>(){

            public Boolean apply(Pair<String, String> it) {
                String _key = (String)it.getKey();
                return _key != null;
            }
        };
        Functions.Function1<Pair<String, String>, Boolean> _function_2 = new Functions.Function1<Pair<String, String>, Boolean>(){

            public Boolean apply(Pair<String, String> it) {
                return !Objects.equal((Object)it.getValue(), (Object)MGLUtil.nsURI((Annotatable)GrammarTmpl.this.getModel())) && !Objects.equal((Object)it.getKey(), (Object)"ecore");
            }
        };
        Consumer<Pair<String, String>> _function_3 = new Consumer<Pair<String, String>>(){

            @Override
            public void accept(Pair<String, String> it) {
                GrammarTmpl.this._collectionExtension.add(GrammarTmpl.this.importMappings, it);
            }
        };
        IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)this._graphModelExtension.getPrimeReferences(this.getModel()), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2).forEach(_function_3);
        this.typesWithOrigins = MGLUtil.typesWithOrigins((GraphModel)this.getGraphModel());
    }

    public CharSequence modelRule(GraphModel it) {
        StringConcatenation _xblockexpression = null;
        Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                boolean _isIsAbstract = it.isIsAbstract();
                return !_isIsAbstract;
            }
        };
        Iterable containables = IterableExtensions.filter((Iterable)this._generatorUtils.getUsableNodes((ContainingElement)it), (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        String _name = this.getGraphModel().getName();
        _builder.append(_name);
        _builder.append(" returns GratextInternal");
        String _name_1 = this.getGraphModel().getName();
        _builder.append(_name_1);
        _builder.append(":{GratextInternal");
        String _name_2 = this.getGraphModel().getName();
        _builder.append(_name_2);
        _builder.append("}");
        _builder.newLineIfNotEmpty();
        _builder.append("'");
        String _name_3 = this.getGraphModel().getName();
        _builder.append(_name_3);
        _builder.append("' (id = _ID)?");
        _builder.newLineIfNotEmpty();
        _builder.append("('{'");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _attributes = this.attributes((ModelElement)it);
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        boolean _hasElements = false;
        for (Node containable : containables) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("( modelElements += ", "\t");
            } else {
                _builder.appendImmediate((Object)"| modelElements += ", "\t");
            }
            _builder.append("\t");
            String _name_4 = containable.getName();
            _builder.append(_name_4, "\t");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append(")*", "\t");
        }
        _builder.append("'}')?");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence containerRule(NodeContainer node) {
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        StringConcatenation _xblockexpression = null;
        Functions.Function1<Edge, Iterable<ModelElement>> _function = new Functions.Function1<Edge, Iterable<ModelElement>>(){

            public Iterable<ModelElement> apply(Edge it) {
                Set _allSubclasses = MGLUtil.getAllSubclasses((ModelElement)it);
                return Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Edge[]{it})), (Iterable)_allSubclasses);
            }
        };
        Set outEdges = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)this._graphModelExtension.getOutgoingEdges((Node)node), (Functions.Function1)_function));
        Predicate<ModelElement> _function_1 = new Predicate<ModelElement>(){

            @Override
            public boolean test(ModelElement it) {
                return it.isIsAbstract();
            }
        };
        outEdges.removeIf(_function_1);
        Functions.Function1<ModelElement, Iterable<ModelElement>> _function_2 = new Functions.Function1<ModelElement, Iterable<ModelElement>>(){

            public Iterable<ModelElement> apply(ModelElement it) {
                Set _allSubclasses = MGLUtil.getAllSubclasses((ModelElement)it);
                return Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ModelElement[]{it})), (Iterable)_allSubclasses);
            }
        };
        Functions.Function1<ModelElement, Boolean> _function_3 = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                return it.isIsAbstract();
            }
        };
        Set containables = IterableExtensions.toSet((Iterable)this._collectionExtension.drop(IterableExtensions.flatMap((Iterable)this._graphModelExtension.getContainables((ContainingElement)node), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
        StringConcatenation _builder = new StringConcatenation();
        String _name = node.getName();
        _builder.append(_name);
        _builder.append(" returns GratextInternal");
        String _name_1 = node.getName();
        _builder.append(_name_1);
        _builder.append(":{GratextInternal");
        String _name_2 = node.getName();
        _builder.append(_name_2);
        _builder.append("}");
        _builder.newLineIfNotEmpty();
        _builder.append("'");
        String _name_3 = node.getName();
        _builder.append(_name_3);
        _builder.append("' (id = _ID)? ( ('at' x=_EInt ',' y=_EInt)?");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("& ('size' width=_EInt ',' height=_EInt)?");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("& ('index' index=_EInt)? ");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append("('{'");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _attributes = this.attributes((ModelElement)node);
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = containables.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _greaterThan;
            _builder.append("\t");
            _builder.append("( modelElements += ");
            String _name_4 = ((ModelElement[])Conversions.unwrapArray((Object)containables, ModelElement.class))[0].getName();
            _builder.append(_name_4, "\t");
            _builder.newLineIfNotEmpty();
            int _size = containables.size();
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                int _size_1 = containables.size();
                int _minus = _size_1 - 1;
                IntegerRange _upTo = new IntegerRange(1, _minus);
                for (Integer i : _upTo) {
                    _builder.append("\t");
                    _builder.append("| modelElements += ");
                    String _name_5 = ((ModelElement[])Conversions.unwrapArray((Object)containables, ModelElement.class))[i].getName();
                    _builder.append(_name_5, "\t");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("\t");
            _builder.append(")*");
            _builder.newLine();
        }
        boolean bl3 = _not_1 = !(_isEmpty_1 = outEdges.isEmpty());
        if (_not_1) {
            boolean _greaterThan_1;
            _builder.append("\t");
            _builder.append("( outgoingEdges += ");
            String _name_6 = ((ModelElement[])Conversions.unwrapArray((Object)outEdges, ModelElement.class))[0].getName();
            _builder.append(_name_6, "\t");
            _builder.newLineIfNotEmpty();
            int _size_2 = outEdges.size();
            boolean bl4 = _greaterThan_1 = _size_2 > 1;
            if (_greaterThan_1) {
                int _size_3 = outEdges.size();
                int _minus_1 = _size_3 - 1;
                IntegerRange _upTo_1 = new IntegerRange(1, _minus_1);
                for (Integer i_1 : _upTo_1) {
                    _builder.append("\t");
                    _builder.append("| outgoingEdges += ");
                    String _name_7 = ((ModelElement[])Conversions.unwrapArray((Object)outEdges, ModelElement.class))[i_1].getName();
                    _builder.append(_name_7, "\t");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("\t");
            _builder.append(")*");
            _builder.newLine();
        }
        _builder.append("'}')?");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence nodeRule(Node node) {
        boolean _not;
        StringConcatenation _xblockexpression = null;
        Functions.Function1<Edge, Iterable<ModelElement>> _function = new Functions.Function1<Edge, Iterable<ModelElement>>(){

            public Iterable<ModelElement> apply(Edge it) {
                Set _allSubclasses = MGLUtil.getAllSubclasses((ModelElement)it);
                return Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Edge[]{it})), (Iterable)_allSubclasses);
            }
        };
        Set outEdges = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)this._graphModelExtension.getOutgoingEdges(node), (Functions.Function1)_function));
        Predicate<ModelElement> _function_1 = new Predicate<ModelElement>(){

            @Override
            public boolean test(ModelElement it) {
                return it.isIsAbstract();
            }
        };
        outEdges.removeIf(_function_1);
        StringConcatenation _builder = new StringConcatenation();
        String _name = node.getName();
        _builder.append(_name);
        _builder.append(" returns GratextInternal");
        String _name_1 = node.getName();
        _builder.append(_name_1);
        _builder.append(":{GratextInternal");
        String _name_2 = node.getName();
        _builder.append(_name_2);
        _builder.append("}");
        _builder.newLineIfNotEmpty();
        _builder.append("'");
        String _name_3 = node.getName();
        _builder.append(_name_3);
        _builder.append("' (id = _ID)? ( ('at' x=_EInt ',' y=_EInt)?");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("& ('size' width=_EInt ',' height=_EInt)?");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("& ('index' index=_EInt)? ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append("('{'");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _attributes = this.attributes((ModelElement)node);
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = outEdges.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _greaterThan;
            _builder.append("\t");
            _builder.append("( outgoingEdges += ");
            String _name_4 = ((ModelElement[])Conversions.unwrapArray((Object)outEdges, ModelElement.class))[0].getName();
            _builder.append(_name_4, "\t");
            _builder.newLineIfNotEmpty();
            int _size = outEdges.size();
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                int _size_1 = outEdges.size();
                int _minus = _size_1 - 1;
                IntegerRange _upTo = new IntegerRange(1, _minus);
                for (Integer i : _upTo) {
                    _builder.append("\t");
                    _builder.append("| outgoingEdges += ");
                    String _name_5 = ((ModelElement[])Conversions.unwrapArray((Object)outEdges, ModelElement.class))[i].getName();
                    _builder.append(_name_5, "\t");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("\t");
            _builder.append(")*");
            _builder.newLine();
        }
        _builder.append("'}')?");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence edgeRule(Edge edge) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = edge.getName();
        _builder.append(_name);
        _builder.append(" returns GratextInternal");
        String _name_1 = edge.getName();
        _builder.append(_name_1);
        _builder.append(":{GratextInternal");
        String _name_2 = edge.getName();
        _builder.append(_name_2);
        _builder.append("}");
        _builder.newLineIfNotEmpty();
        _builder.append("'-");
        String _name_3 = edge.getName();
        _builder.append(_name_3);
        _builder.append("->' _targetElement = [_graphmodel::InternalNode|_ID]");
        _builder.newLineIfNotEmpty();
        _builder.append("('via' (bendpoints += _Point)+)?");
        _builder.newLine();
        _builder.append("(decorators += _Decoration)*");
        _builder.newLine();
        _builder.append("('{'");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("('id' id = _ID)?");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _attributes = this.attributes((ModelElement)edge);
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("'}')?");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        return _builder;
    }

    public CharSequence typeRule(UserDefinedType type) {
        StringConcatenation _xblockexpression = null;
        Set subTypes = MGLUtil.getAllSubTypes((UserDefinedType)type);
        StringConcatenation _builder = new StringConcatenation();
        String _name = type.getName();
        _builder.append(_name);
        _builder.append(" returns GratextInternal");
        String _name_1 = type.getName();
        _builder.append(_name_1);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("__");
        String _name_2 = type.getName();
        _builder.append(_name_2, "\t");
        Functions.Function1<UserDefinedType, CharSequence> _function = new Functions.Function1<UserDefinedType, CharSequence>(){

            public CharSequence apply(UserDefinedType it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("__");
                String _name = it.getName();
                _builder.append(_name);
                return _builder.toString();
            }
        };
        String _join = IterableExtensions.join((Iterable)subTypes, (CharSequence)"|", (CharSequence)"|", (CharSequence)"", (Functions.Function1)_function);
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append(";");
        _builder.newLine();
        _builder.append("__");
        String _name_3 = type.getName();
        _builder.append(_name_3);
        _builder.append(" returns GratextInternal");
        String _name_4 = type.getName();
        _builder.append(_name_4);
        _builder.append(":{GratextInternal");
        String _name_5 = type.getName();
        _builder.append(_name_5);
        _builder.append("}");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("'");
        String _name_6 = type.getName();
        _builder.append(_name_6, "\t");
        _builder.append("' (id = _ID)? '{'");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _attributes = this.attributes((ModelElement)type);
        _builder.append((Object)_attributes, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("'}'");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence enumRule(Enumeration type) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("enum ");
        String _name = type.getName();
        _builder.append(_name);
        _builder.append(" returns ");
        String _alias = this.alias(MGLUtil.mglModel((Object)type));
        _builder.append(_alias);
        _builder.append("::");
        String _name_1 = type.getName();
        _builder.append(_name_1);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String literal) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("^");
                _builder.append(literal);
                return _builder.toString();
            }
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)type.getLiterals(), (Functions.Function1)_function), (CharSequence)" | ");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append(";");
        _builder.newLine();
        return _builder;
    }

    public CharSequence typeReference(MGLModel it, Attribute attr) {
        StringConcatenation _xblockexpression = null;
        MGLModel containingMGLModel = null;
        Object _switchResult = null;
        boolean _matched = false;
        if (attr instanceof PrimitiveAttribute) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("_");
            String _literal = ((PrimitiveAttribute)attr).getType().getLiteral();
            _builder.append(_literal);
            _switchResult = _builder;
        }
        if (!_matched && attr instanceof ComplexAttribute) {
            _matched = true;
            String _xifexpression = null;
            if (this._graphModelExtension.containsEnumeration(it, ((ComplexAttribute)attr).getType().getName()) || this._graphModelExtension.containsUserDefinedType(it, ((ComplexAttribute)attr).getType().getName())) {
                _xifexpression = ((ComplexAttribute)attr).getType().getName();
            } else {
                String _xifexpression_1 = null;
                boolean _containsModelElement = this._graphModelExtension.containsModelElement(it, ((ComplexAttribute)attr).getType().getName());
                if (_containsModelElement) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("[");
                    String _alias = this.alias(this.getModel());
                    _builder.append(_alias);
                    _builder.append("::");
                    String _name = ((ComplexAttribute)attr).getType().getName();
                    _builder.append(_name);
                    _builder.append("|_ID]");
                    _xifexpression_1 = _builder;
                } else {
                    String _xifexpression_2 = null;
                    containingMGLModel = this._graphModelExtension.getContainingImportedMglModel(it, ((ComplexAttribute)attr).getType().getName());
                    if (containingMGLModel != null) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("[");
                        String _alias_1 = this.alias(containingMGLModel);
                        _builder_1.append(_alias_1);
                        _builder_1.append("::");
                        String _name_1 = ((ComplexAttribute)attr).getType().getName();
                        _builder_1.append(_name_1);
                        _builder_1.append("|_ID]");
                        _xifexpression_2 = _builder_1;
                    } else {
                        _xifexpression_2 = ((ComplexAttribute)attr).getType().getName();
                    }
                    _xifexpression_1 = _xifexpression_2;
                }
                _xifexpression = _xifexpression_1;
            }
            _switchResult = _xifexpression;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public CharSequence typeReference(ReferencedType ref) {
        StringConcatenation _xblockexpression = null;
        EObject type = this._graphModelExtension.getType(ref);
        StringConcatenation _xifexpression = null;
        if (type != null) {
            Pair _xifexpression_1;
            StringConcatenation _xblockexpression_1 = null;
            Pair _switchResult = null;
            EObject it = type;
            boolean _matched = false;
            if (it instanceof ModelElement) {
                boolean _not;
                _matched = true;
                _xifexpression_1 = null;
                boolean _isLocal = ((ReferencedModelElement)ref).isLocal();
                boolean bl = _not = !_isLocal;
                if (_not) {
                    String _alias = this.alias(MGLUtil.mglModel((Object)ref.getImprt()));
                    String _name = ((ModelElement)it).getName();
                    _xifexpression_1 = Pair.of((Object)_alias, (Object)_name);
                } else {
                    String _alias_1 = this.alias(this.getModel());
                    String _name_1 = ((ModelElement)it).getName();
                    _xifexpression_1 = Pair.of((Object)_alias_1, (Object)_name_1);
                }
                _switchResult = _xifexpression_1;
            }
            if (!_matched && it instanceof EClass) {
                _matched = true;
                _xifexpression_1 = null;
                String _name = ((EClass)it).getEPackage().getName();
                boolean _equals = Objects.equal((Object)_name, (Object)"ecore");
                if (_equals) {
                    String _name_1 = ((EClass)it).getName();
                    _xifexpression_1 = Pair.of((Object)"_ecore", (Object)_name_1);
                } else {
                    String _name_2 = ((EClass)it).getEPackage().getName();
                    String _name_3 = ((EClass)it).getName();
                    _xifexpression_1 = Pair.of((Object)_name_2, (Object)_name_3);
                }
                _switchResult = _xifexpression_1;
            }
            Pair entry = _switchResult;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("[");
            String _key = (String)entry.getKey();
            _builder.append(_key);
            _builder.append("::");
            String _value = (String)entry.getValue();
            _builder.append(_value);
            _builder.append("|_ID]");
            _xifexpression = _xblockexpression_1 = _builder;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public CharSequence gratextName(Attribute attr) {
        String _switchResult = null;
        boolean _matched = false;
        if (attr instanceof ComplexAttribute) {
            _matched = true;
            String _switchResult_1 = null;
            Type _type = ((ComplexAttribute)attr).getType();
            boolean _matched_1 = false;
            if (_type instanceof UserDefinedType) {
                _matched_1 = true;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("gratext_");
                String _name = ((ComplexAttribute)attr).getName();
                _builder.append(_name);
                _switchResult_1 = _builder;
            }
            if (!_matched_1) {
                _switchResult_1 = ((ComplexAttribute)attr).getName();
            }
            _switchResult = _switchResult_1;
        }
        if (!_matched) {
            _switchResult = attr.getName();
        }
        return _switchResult;
    }

    public CharSequence attributes(ModelElement elm) {
        CharSequence _xblockexpression = null;
        EList _annotations = null;
        if (this._generatorUtils.cpd != null) {
            _annotations = this._generatorUtils.cpd.getAnnotations();
        }
        boolean _exists = false;
        if (_annotations != null) {
            Functions.Function1<Annotation, Boolean> _function = new Functions.Function1<Annotation, Boolean>(){

                public Boolean apply(Annotation it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)"sortGratext");
                }
            };
            _exists = IterableExtensions.exists((Iterable)_annotations, (Functions.Function1)_function);
        }
        boolean sorted = _exists;
        Iterable _xifexpression = null;
        if (sorted) {
            Functions.Function1<Attribute, String> _function_1 = new Functions.Function1<Attribute, String>(){

                public String apply(Attribute it) {
                    return it.getName();
                }
            };
            _xifexpression = IterableExtensions.sortBy((Iterable)this._graphModelExtension.getAllAttributes(elm), (Functions.Function1)_function_1);
        } else {
            _xifexpression = this._graphModelExtension.getAllAttributes(elm);
        }
        Iterable attrs = _xifexpression;
        String _xifexpression_1 = null;
        _xifexpression_1 = sorted ? " \n" : " &\n";
        String attrSeparator = _xifexpression_1;
        Functions.Function1<Attribute, String> _function_2 = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute it) {
                String _switchResult = null;
                boolean _matched = false;
                if (it.getUpperBound() < 0 || it.getUpperBound() > 1) {
                    _matched = true;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("( '");
                    String _name = it.getName();
                    _builder.append(_name);
                    _builder.append("' '[' ( ^");
                    CharSequence _gratextName = GrammarTmpl.this.gratextName(it);
                    _builder.append((Object)_gratextName);
                    _builder.append(" += ");
                    CharSequence _typeReference = GrammarTmpl.this.typeReference(GrammarTmpl.this.getModel(), it);
                    _builder.append((Object)_typeReference);
                    _builder.append(" ( ',' ^");
                    CharSequence _gratextName_1 = GrammarTmpl.this.gratextName(it);
                    _builder.append((Object)_gratextName_1);
                    _builder.append(" += ");
                    CharSequence _typeReference_1 = GrammarTmpl.this.typeReference(GrammarTmpl.this.getModel(), it);
                    _builder.append((Object)_typeReference_1);
                    _builder.append(" )* )? ']' )?");
                    _switchResult = _builder.toString();
                }
                if (!_matched) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("( '");
                    String _name_1 = it.getName();
                    _builder_1.append(_name_1);
                    _builder_1.append("' ^");
                    CharSequence _gratextName_2 = GrammarTmpl.this.gratextName(it);
                    _builder_1.append((Object)_gratextName_2);
                    _builder_1.append(" = ");
                    CharSequence _typeReference_2 = GrammarTmpl.this.typeReference(GrammarTmpl.this.getModel(), it);
                    _builder_1.append((Object)_typeReference_2);
                    _builder_1.append(" )?");
                    _switchResult = _builder_1.toString();
                }
                return _switchResult;
            }
        };
        String attrsStr = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)attrs, (Functions.Function1)_function_2), (CharSequence)attrSeparator);
        CharSequence _switchResult = null;
        if (elm instanceof Node) {
            _switchResult = this.prime((Node)elm);
        }
        CharSequence primeStr = _switchResult;
        CharSequence _xifexpression_2 = null;
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)attrs);
        if (_isEmpty) {
            _xifexpression_2 = primeStr;
        } else {
            String _xifexpression_3 = null;
            _xifexpression_3 = primeStr != null ? "( " + primeStr + attrSeparator + attrsStr + " )" : "( " + attrsStr + " )";
            _xifexpression_2 = _xifexpression_3;
        }
        _xblockexpression = _xifexpression_2;
        return _xblockexpression;
    }

    public CharSequence prime(Node node) {
        StringConcatenation _xblockexpression = null;
        ReferencedType ref = this._graphModelExtension.getAnyPrimeReference(node);
        StringConcatenation _xifexpression = null;
        if (ref != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("( '");
            String _name = ref.getName();
            _builder.append(_name);
            _builder.append("' prime = ");
            CharSequence _typeReference = this.typeReference(ref);
            _builder.append((Object)_typeReference);
            _builder.append(" | 'libraryComponentUID' libraryComponentUID = _STRING )");
            _xifexpression = _builder;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public CharSequence imports() {
        StringConcatenation _xblockexpression = null;
        Functions.Function1<MGLModel, Boolean> _function = new Functions.Function1<MGLModel, Boolean>(){

            public Boolean apply(MGLModel m) {
                boolean _equalMGLModels = MGLUtil.equalMGLModels((MGLModel)m, (MGLModel)GrammarTmpl.this.getModel());
                return !_equalMGLModels;
            }
        };
        Iterable typeOrigins = IterableExtensions.filter(this.typesWithOrigins.keySet(), (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import \"");
        String _nsURI = MGLUtil.nsURI((Annotatable)this.getGraphModel());
        _builder.append(_nsURI);
        _builder.append("/");
        String _lowerCase = this.getGraphModel().getName().toLowerCase();
        _builder.append(_lowerCase);
        _builder.append("/gratext\"");
        _builder.newLineIfNotEmpty();
        _builder.append("import \"");
        String _nsURI_1 = MGLUtil.nsURI((Annotatable)this.getModel());
        _builder.append(_nsURI_1);
        _builder.append("\" as ");
        String _alias = this.alias(this.getModel());
        _builder.append(_alias);
        _builder.newLineIfNotEmpty();
        Functions.Function1<Map.Entry<String, String>, String> _function_1 = new Functions.Function1<Map.Entry<String, String>, String>(){

            public String apply(Map.Entry<String, String> it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("import \"");
                String _value = it.getValue();
                _builder.append(_value);
                _builder.append("\" as ");
                String _key = it.getKey();
                _builder.append(_key);
                return _builder.toString();
            }
        };
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(this.importMappings.entrySet(), (Functions.Function1)_function_1), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        for (MGLModel typeOrigin : typeOrigins) {
            boolean _not;
            boolean _contains = this.importMappings.values().contains(MGLUtil.nsURI((Annotatable)typeOrigin));
            boolean bl = _not = !_contains;
            if (!_not) continue;
            _builder.append("import \"");
            String _nsURI_2 = MGLUtil.nsURI((Annotatable)typeOrigin);
            _builder.append(_nsURI_2);
            _builder.append("\" as ");
            String _alias_1 = this.alias(typeOrigin);
            _builder.append(_alias_1);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("import \"http://www.jabc.de/cinco/gdl/graphmodel/internal\" as _graphmodel");
        _builder.newLine();
        _builder.append("import \"http://www.eclipse.org/emf/2002/Ecore\" as _ecore");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public String alias(MGLModel mglModel) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("_mgl_");
        String _lowerCase = this._generatorUtils.getFileName(mglModel).toLowerCase();
        _builder.append(_lowerCase);
        return _builder.toString();
    }

    public String escaped(String pkg) {
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return "^" + it;
            }
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)pkg.split("\\."))), (Functions.Function1)_function), (CharSequence)".");
    }

    public static Set<UserDefinedType> allUserDefinedTypes(GraphModel graphModel) {
        Functions.Function1<UserDefinedType, Iterable<ModelElement>> _function = new Functions.Function1<UserDefinedType, Iterable<ModelElement>>(){

            public Iterable<ModelElement> apply(UserDefinedType it) {
                Set _allSubTypes = MGLUtil.getAllSubTypes((UserDefinedType)it);
                Iterable _plus = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new UserDefinedType[]{it})), (Iterable)_allSubTypes);
                ArrayList _allSuperTypes = MGLUtil.allSuperTypes((ModelElement)it);
                return Iterables.concat((Iterable)_plus, (Iterable)_allSuperTypes);
            }
        };
        Functions.Function1<ModelElement, Iterable<Type>> _function_1 = new Functions.Function1<ModelElement, Iterable<Type>>(){

            public Iterable<Type> apply(ModelElement it) {
                Iterable _complexAttributeTypesDeeply = MGLUtil.getComplexAttributeTypesDeeply((ModelElement)it);
                return Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ModelElement[]{it})), (Iterable)_complexAttributeTypesDeeply);
            }
        };
        return IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap((Iterable)GeneratorUtils.getInstance().getUsableUserDefinedTypes((ContainingElement)graphModel), (Functions.Function1)_function), (Functions.Function1)_function_1), UserDefinedType.class));
    }

    public CharSequence template() {
        Object _containerRule;
        StringConcatenation _xblockexpression = null;
        Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                boolean _isIsAbstract = it.isIsAbstract();
                return !_isIsAbstract;
            }
        };
        Iterable usableNodes = IterableExtensions.filter((Iterable)this._generatorUtils.getUsableNodes((ContainingElement)this.getGraphModel(), true), (Functions.Function1)_function);
        Functions.Function1<Edge, Boolean> _function_1 = new Functions.Function1<Edge, Boolean>(){

            public Boolean apply(Edge it) {
                boolean _isIsAbstract = it.isIsAbstract();
                return !_isIsAbstract;
            }
        };
        Iterable usableEdges = IterableExtensions.filter((Iterable)this._generatorUtils.getUsableEdges((ContainingElement)this.getGraphModel()), (Functions.Function1)_function_1);
        Set<UserDefinedType> usableUserDefinedTypes = GrammarTmpl.allUserDefinedTypes(this.getGraphModel());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("grammar ");
        String _escaped = this.escaped(this.getPackage());
        _builder.append(_escaped);
        _builder.append(".");
        String _fileName = this._generatorUtils.getFileName(this.getModel());
        _builder.append(_fileName);
        _builder.append("Gratext hidden(_WS, _ML_COMMENT, _SL_COMMENT)");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _imports = this.imports();
        _builder.append((Object)_imports);
        _builder.newLineIfNotEmpty();
        CharSequence _modelRule = this.modelRule(this.getGraphModel());
        _builder.append((Object)_modelRule);
        _builder.newLineIfNotEmpty();
        Iterable _filter = Iterables.filter((Iterable)usableNodes, NodeContainer.class);
        for (NodeContainer node : _filter) {
            _containerRule = this.containerRule(node);
            _builder.append(_containerRule);
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Functions.Function1<Node, Boolean> _function_2 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                return !(it instanceof NodeContainer);
            }
        };
        Iterator<UserDefinedType> _filter_1 = IterableExtensions.filter((Iterable)usableNodes, (Functions.Function1)_function_2);
        _containerRule = _filter_1.iterator();
        while (_containerRule.hasNext()) {
            Node node_1 = (Node)_containerRule.next();
            CharSequence _nodeRule = this.nodeRule(node_1);
            _builder.append((Object)_nodeRule);
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        for (Edge edge : usableEdges) {
            CharSequence _edgeRule = this.edgeRule(edge);
            _builder.append((Object)_edgeRule);
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        for (UserDefinedType type : usableUserDefinedTypes) {
            CharSequence _typeRule = this.typeRule(type);
            _builder.append((Object)_typeRule);
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Set _enumerations = this._graphModelExtension.getEnumerations(this.getGraphModel());
        for (Enumeration type_1 : _enumerations) {
            CharSequence _enumRule = this.enumRule(type_1);
            _builder.append((Object)_enumRule);
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("_Decoration returns _graphmodel::_Decoration:{_graphmodel::_Decoration}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("'decorate' (nameHint = _EString)? 'at' locationShift = _Point");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.newLine();
        _builder.append("_Point returns _graphmodel::_Point:{_graphmodel::_Point}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("'(' x = _EInt ',' y = _EInt ')'");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.newLine();
        _builder.append("_EString returns _ecore::EString:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("_STRING");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.newLine();
        _builder.append("_EInt returns _ecore::EInt:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("_SIGN? _INT");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.newLine();
        _builder.append("_ELong returns _ecore::ELong:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("_SIGN? _INT");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.newLine();
        _builder.append("_EDouble returns _ecore::EDouble:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("_SIGN? _INT? '.' _INT");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.newLine();
        _builder.append("_EFloat returns _ecore::EFloat:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("_SIGN? _INT? '.' _INT");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.newLine();
        _builder.append("_EBoolean returns _ecore::EBoolean:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("'true' | 'false'");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.newLine();
        _builder.append("_EDate returns _ecore::EDate:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("_STRING");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.newLine();
        _builder.append("terminal _ID : '^'?('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'-'|'0'..'9')* ;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("terminal _SIGN : '+' | '-' ;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("terminal _INT returns _ecore::EInt: ('0'..'9')+ ;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("terminal _STRING\t: ");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("'\"' ( '\\\\' . /* 'b'|'t'|'n'|'f'|'r'|'u'|'\"'|\"'\"|'\\\\' */ | !('\\\\'|'\"') )* '\"' |");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\"'\" ( '\\\\' . /* 'b'|'t'|'n'|'f'|'r'|'u'|'\"'|\"'\"|'\\\\' */ | !('\\\\'|\"'\") )* \"'\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("; ");
        _builder.newLine();
        _builder.append("terminal _ML_COMMENT\t: '/*' -> '*/' ;");
        _builder.newLine();
        _builder.append("terminal _SL_COMMENT \t: '//' !('\\n'|'\\r')* ('\\r'? '\\n')? ;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("terminal _WS\t\t\t: (' '|'\\t'|'\\r'|'\\n')+ ;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("terminal _ANY_OTHER: . ;");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

