/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.gratext;

import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.plugin.dsl.FileContainerDescription;
import de.jabc.cinco.meta.plugin.dsl.PackageDescription;
import de.jabc.cinco.meta.plugin.gratext.build.GratextLanguageBuild;
import de.jabc.cinco.meta.plugin.gratext.tmpl.file.GrammarTmpl;
import de.jabc.cinco.meta.plugin.gratext.tmpl.project.GratextProjectTmpl;
import de.jabc.cinco.meta.runtime.xapi.FileExtension;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import de.jabc.cinco.meta.runtime.xapi.WorkspaceExtension;
import java.util.concurrent.LinkedTransferQueue;
import mgl.GraphModel;
import mgl.MGLModel;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;

public class GratextBuilder
extends AbstractHandler {
    public static LinkedTransferQueue<GratextProjectTmpl> PROJECT_REGISTRY = new LinkedTransferQueue();
    protected WorkspaceExtension workspace = new WorkspaceExtension();
    protected ResourceExtension resources = new ResourceExtension();
    protected FileExtension files = new FileExtension();
    private GeneratorUtils generatorUtils = GeneratorUtils.getInstance();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        GratextProjectTmpl gratextProjTmpl = PROJECT_REGISTRY.poll();
        while (gratextProjTmpl != null) {
            IProject gratextProject = (IProject)gratextProjTmpl.getProjectDescription().getIResource();
            MGLModel mglModel = gratextProjTmpl.getModel();
            GraphModel graphModel = gratextProjTmpl.getGraphModel();
            this.workspace.buildIncremental(gratextProject);
            try {
                GrammarTmpl tmpl = new GrammarTmpl();
                tmpl.setModel(mglModel);
                tmpl.setGraphModel(graphModel);
                tmpl.setParent((FileContainerDescription)new PackageDescription(gratextProjTmpl.getProjectName()));
                IFile file = this.createFile(gratextProjTmpl.getProjectName(), "bin/" + mglModel.getPackage().replace('.', '/') + "/gratext/", String.valueOf(this.generatorUtils.getFileName(mglModel)) + "Gratext.xtext", tmpl.getContent());
                file.setDerived(true, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            gratextProjTmpl.proceed();
            new GratextLanguageBuild(gratextProject).runAndWait();
            gratextProjTmpl = PROJECT_REGISTRY.poll();
        }
        return null;
    }

    private IFile createFile(String projectName, String folderName, String fileName, CharSequence content) {
        IProject project = this.workspace.getWorkspaceRoot().getProject(projectName);
        IFolder folder = this.workspace.createFolder((IContainer)project, folderName);
        return this.workspace.createFile((IContainer)folder, fileName, content);
    }
}

